<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$app				= JFactory::getApplication();
$data				= $displayData['data'];
$api				= $data->api;
$user    			= $data->user;
$asset				= $data->asset;
$params  			= $data->item->params;
$profileApp			= $params->get('profile_component', 'none');
$theme 				= $params->get('theme', 'default');

$start				= $app->input->getInt('start', 0);
$surveyUri			= CommunitySurveysHelperRoute::getSurveyRoute($data->item->slug, $data->item->catslug, $data->item->language, $start);
$authorUrl			= $api->getUserProfileUrl($profileApp, $data->item->created_by);
$authorName			= $this->escape($data->item->author);
$surveyAuthor		= $profileApp != 'none' ? JHtml::link($authorUrl, $authorName, array('itemprop'=>'url')) : $authorName;
$return             = base64_encode(JUri::getInstance());

if(
		$params->get('show_title') ||
		($params->get('show_intro') && empty($data->response)) ||
		$params->get('show_author') ||
		$params->get('show_category') ||
		$params->get('show_create_date') ||
		$params->get('social_sharing'))
{
	?>
	<div class="panel panel-<?php echo $theme;?>">
		<div class="panel-body">
			<div class="media">
				<div class="media-body">
					
					<?php if($params->get('show_title', 1) == 1):?>
					<h1 class="no-space-top margin-bottom-10 survey-title">
						<?php
						if($data->item->private == 1 || !$params->get('link_titles', 1))
						{
						    echo $this->escape($data->item->title);
						}
						else 
						{
						    echo JHtml::link(JRoute::_($surveyUri), $this->escape($data->item->title));
						}
						?>
					</h1>
					<?php endif;?>
					
					<div class="survey-description">
						<?php 
						//************************ QUESTION DESCRIPTION **************************//
						if(empty($data->response))
						{
							echo $data->item->event->beforeDisplayContent;
							echo $data->item->text;
							echo $data->item->event->afterDisplayContent;
						}
						//********************** END QUESTION DESCRIPTION *************************//
						?>
					</div>
					
					<?php if($params->get('show_author', 1) == 1 || $params->get('show_category', 1) == 1 || $params->get('show_create_date', 1) == 1):?>
					<div class="margin-bottom-10 margin-top-10 muted text-muted">
						<?php if($params->get('show_author', 1) == 1):?>
						<span class="author-name">
							<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_SUBMITTED_BY', $surveyAuthor);?>
						</span>
						<?php endif;?>
						
						<?php if($params->get('show_category', 1) == 1):?>
						<span class="category-title">
							<?php echo JText::sprintf('COM_COMMUNITYSURVEYS_SURVEY_CATEGORY_TEXT', 
									JHtml::link(CommunitySurveysHelperRoute::getCategoryRoute($data->item->catid, $data->item->language), $data->item->category_title));?>
						</span>
						<?php endif;?>
						
						<?php if($params->get('show_create_date', 1) == 1):?>
						<span class="question-date">
							<?php echo CjLibDateUtils::getHumanReadableDate($data->item->created);?>
						</span>
						<?php endif;?>
					</div>
					<?php endif;?>
					
					<?php
					//******************************* TAGS ************************************//
					if ($params->get('show_tags', 1) && !empty($data->item->tags))
					{
						$data->item->tagLayout = new JLayoutFile('joomla.content.tags');
						echo $data->item->tagLayout->render($data->item->tags->itemTags);
					}
					//***************************** END TAGS **********************************//
					//*************************** SOCIAL SHARING *****************************// 
					if($params->get('social_sharing', 1) == 1)
					{
					    JPluginHelper::importPlugin( 'corejoomla' );
					    $results = $app->triggerEvent( 'onSocialsDisplay', array( 'com_communitysurveys.survey', $params ) );
					    if(!empty($results))
					    {
					        ?>
    						<hr/>
    						<div class="social-sharing">
    							<p><?php echo JText::_('COM_COMMUNITYSURVEYS_SOCIAL_SHARING_DESC');?></p>
								<?php echo implode(' ', $results);?>
							</div>
							<?php
						}
					}
					//************************ END SOCIAL SHARING ***************************// 
					?>
				</div>
			</div>
		</div>
		
		<?php if($params->get('access-edit') || $params->get('access-edit-state')):?>
		<div class="panel-footer">
			<div class="muted text-muted">
				<?php if($params->get('access-edit')):?>
				<a href="<?php echo JRoute::_(CommunitySurveysHelperRoute::getFormRoute($data->item->id).'&return='.$return);?>" class="muted text-muted">
					<?php echo JText::_('JGLOBAL_EDIT');?>
				  </a>
				<?php endif;?>
				
				<?php 
				if($params->get('access-edit-state'))
				{
					if($data->item->state == 0 || $data->item->state == -2)
					{
						?>
						| <a href="#"  onclick="document.adminForm.cid.value=<?php echo $data->item->id;?>;Joomla.submitbutton('surveys.publish'); return false;" class="muted text-muted">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_PUBLISH');?>
					  	</a>
					  	<?php 
					}
					else
					{
						?>
						| <a href="#"  onclick="document.adminForm.cid.value=<?php echo $data->item->id;?>;Joomla.submitbutton('surveys.unpublish'); return false;" class="muted text-muted">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_UNPUBLISH');?>
					  	</a>
					  	<?php 
					}
					
					if($data->item->state == -2 && $user->authorise('core.admin', $asset))
					{
						?>
						| <a href="#" onclick="Joomla.submitbutton('surveys.delete'); return false;" class="muted text-muted">
							<?php echo JText::_('COM_COMMUNITYSURVEYS_PERMANENTLY_DELETE');?>
						  </a>
					  	<?php
					}
					else
					{
						?>
						| <a href="#" onclick="Joomla.submitbutton('surveys.trash'); return false;" class="muted text-muted">
							<?php echo JText::_('JTRASH');?>
						  </a>
						<?php
					}
				}
				?>
			</div>
		</div>
		<?php endif;?>
		
	</div>
	<?php 
}

if(empty($data->response) && $params->get('show_confidentiality'))
{
	?>
	<div class="panel panel-<?php echo $theme;?> confidential-notice">
		<div class="panel-body">
			<?php echo $params->get('anonymous', 0) == 1 ? JText::_('COM_COMMUNITYSURVEYS_ANONYMOUS_SURVEY_NOTICE') : JText::_('COM_COMMUNITYSURVEYS_ONYMOUS_SURVEY_NOTICE');?>
		</div>
	</div>
	<?php
}