<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_cjforum
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$data = $displayData['data'];
$sitename = JFactory::getConfig()->get('sitename');
?>
<!doctype html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?php echo $sitename;?></title>

    <!-- Bootstrap core CSS -->
    <link href="media/css/bootstrap.min.css" rel="stylesheet">
    <link href="media/css/font-awesome.min.css" rel="stylesheet">
    <style type="text/css">
        html {font-size: 16px;font-family: sans-serif;line-height: 1.15;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;-ms-overflow-style: scrollbar;-webkit-tap-highlight-color: transparent;}
        body {margin: 0;font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol";font-size: .875rem;font-weight: 400;line-height: 1.5;color: #212529;text-align: left;background-color: #fff;}
        .feather {width: 16px;height: 16px;vertical-align: text-bottom;}
        .sidebar {position: fixed;top: 0;bottom: 0;left: 0;z-index: 100;padding: 48px 0 0;box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);}
        .sidebar-sticky {position: relative;top: 0;height: calc(100vh - 48px);padding-top: .5rem;overflow-x: hidden;overflow-y: auto;}
        @supports ((position: -webkit-sticky) or (position: sticky)) {.sidebar-sticky {position: -webkit-sticky;position: sticky;}}
        .sidebar .nav-link {font-weight: 500;color: #333;}
        .sidebar .nav-link .feather {margin-right: 4px;color: #999;}
        .sidebar .nav-link.active {color: #007bff;}
        .sidebar .nav-link:hover .feather,.sidebar .nav-link.active .feather {color: inherit;}
        .sidebar-heading {font-size: .75rem;text-transform: uppercase;}
        [role="main"] {padding-top: 48px;}
        .navbar-brand {padding-top: .75rem;padding-bottom: .75rem;font-size: 1rem;background-color: rgba(0, 0, 0, .25);box-shadow: inset -1px 0 0 rgba(0, 0, 0, .25);}
        .navbar .form-control {padding: .75rem 1rem;border-width: 0;border-radius: 0;}
        .form-control-dark {color: #fff;background-color: rgba(255, 255, 255, .1);border-color: rgba(255, 255, 255, .1);}
        .form-control-dark:focus {border-color: transparent;box-shadow: 0 0 0 3px rgba(255, 255, 255, .25);}
        .border-top { border-top: 1px solid #e5e5e5; }
        .border-bottom { border-bottom: 1px solid #e5e5e5; }
        .p-0 {padding: 0 !important;}
        .mr-0,.mx-0 {margin-right: 0 !important;}
        .pr-4,.px-4 {padding-right: 1.5rem !important;}
        .pl-4,.px-4 {padding-left: 1.5rem !important;}
        .mb-3,.my-3 {margin-bottom: 1rem !important;}
        .flex-md-nowrap {-ms-flex-wrap: nowrap !important;flex-wrap: nowrap !important;}
        .shadow {box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;}
        .bg-dark {background-color: #343a40 !important;}
        .ml-sm-auto,.mx-sm-auto {margin-left: auto !important;}
        a.bg-dark:hover, a.bg-dark:focus,button.bg-dark:hover,button.bg-dark:focus {background-color: #1d2124 !important;}
        .d-none {display: none !important;}
        .d-md-block {display: block !important;}
        .bg-light {background-color: #f8f9fa !important;}
        a.bg-light:hover, a.bg-light:focus,button.bg-light:hover,button.bg-light:focus {background-color: #dae0e5 !important;}
        .flex-column {-ms-flex-direction: column !important;flex-direction: column !important;}
        .ml-sm-auto,.mx-sm-auto {margin-left: auto !important;float: none;}
        .navbar-brand {display: inline-block;padding-top: 0.3125rem;padding-bottom: 0.3125rem;margin-right: 1rem;font-size: 1.25rem;line-height: inherit;white-space: nowrap;}
        .navbar-brand:hover, .navbar-brand:focus {text-decoration: none;}
        .navbar-dark .navbar-brand {color: #fff;}
        .navbar-dark .navbar-brand:hover, .navbar-dark .navbar-brand:focus {color: #fff;}        
    </style>
  </head>

  <body id="cj-wrapper">
	<nav class="navbar navbar-dark navbar-fixed-top bg-dark flex-md-nowrap p-0 shadow">
		<a class="navbar-brand col-sm-3 col-md-2 mr-0" href="index.html"><?php echo $sitename?></a>
	</nav>

	<div class="container-fluid tabs">
		<div class="row">
			<nav class="col-md-2 d-none d-md-block bg-light sidebar">
				<div class="sidebar-sticky">
					<ul class="nav flex-column">
						<li class="nav-item">
							<a data-toggle="tab" class="nav-link active" href="#tab-responses">
								<i class="fa fa-list"></i> <?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_RESPONSES')?>
							</a>
						</li>
					</ul>
				</div>
			</nav>

			<main role="main" class="col-md-10 ml-sm-auto px-4">
    			<div class="tab-content">
    				<div id="tab-responses" class="tab-pane active">
    					<h2 class="mb-3"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_MY_RESPONSES')?></h2>
    					<table class="table table-hover table-striped table-bordered">
    						<thead>
    							<tr>
    								<th><?php echo JText::_('JGLOBAL_TITLE');?></th>
    								<th width="25%"><?php echo JText::_('JDATE');?></th>
    								<th width="25%"><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_COMPLETED');?></th>
    							</tr>
    						</thead>
    						<tbody>
    							<?php if(count($data->responses)):?>
    								<?php foreach ($data->responses as $i=>$item):?>
    								<tr>
    									<td>
    										<a data-toggle="tab" href="#tab-content-<?php echo $item->id;?>" class="response-item" data-url="responses/<?php echo $item->id;?>.html">
    											<?php echo $this->escape($item->title);?>
    										</a>
    									</td>
    									<td><?php echo JHtml::_('date', $item->created, JText::_('DATE_FORMAT_LC2')); ?></td>
    									<td><?php echo JHtml::_('date', $item->completed, JText::_('DATE_FORMAT_LC2')); ?></td>
    								</tr>
    								<?php endforeach;?>
    							<?php else :?>
    							<tr>
    								<td colspan="3">
    									<div class="alert alert-info"><?php echo JText::_('JGLOBAL_SELECT_NO_RESULTS_MATCH');?></div>
    								</td>
    							</tr>
    							<?php endif;?>
    						</tbody>
    					</table>
    				</div>
    				<?php if(count($data->responses)):?>
						<?php foreach ($data->responses as $i=>$item):?>
						<div id="tab-content-<?php echo $item->id;?>" class="tab-pane">
							<h2 class="page-header"><?php echo $this->escape($item->title);?></h2>
    						REPLACE-<?php echo $item->id;?>
    					</div>
    					<?php endforeach;?>
    				<?php endif;?>
    			</div>
			</main>
		</div>
	</div>

	<!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="media/js/jquery-3.3.1.slim.min.js"></script>
    <script>window.jQuery || document.write('<script src="media/js/jquery-3.3.1.min.js"><\/script>')</script>
    <script src="media/js/bootstrap.min.js"></script>
    <script type="text/javascript">
    jQuery(document).ready(function($){
    	$('a.response-item').click(function() {
        	$('a[href="#tab-responses"]').parent().removeClass('active');
        });
    });
    </script>
  </body>
</html>