<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined ( 'JPATH_PLATFORM' ) or die ();
require_once JPATH_ROOT . '/components/com_communitysurveys/helpers/route.php';

$user 		= JFactory::getUser ();
$document 	= JFactory::getDocument ();
$data 		= $displayData ['data'];
$item 		= $data->item;
$report 	= $data->report;
$params 	= $data->params;
$theme 		= $params->get ( 'theme', 'default' );
$layout 	= 'pdf';
?>
<div class="consolidated-report">
	<?php
	if (! empty ( $report->questions )) 
	{
	    foreach ( $report->questions as $item ) 
		{
			if (in_array($item->question_type, array(CS_PAGE_HEADER, CS_FILE_UPLOAD)))
			{
				continue;
			}
			?>
	    	<div class="panel panel-<?php echo $theme;?>">
	    		<div style="font-size: 140%; font-weight: bold; margin-top: 0; padding-top: 0;"><?php echo $this->escape($item->title);?></div>
	    		<?php
				$description = strip_tags ( $item->description );
				if (! empty ( $description )) 
				{
					?>
	    			<div class="panel-body"><?php echo $item->description;?></div>
	    			<?php
				}
				
				$layouts = array (
						CS_CHOICE_RADIO => 'choice',
						CS_CHOICE_CHECKBOX => 'choice',
						CS_CHOICE_SELECT => 'choice',
						CS_CHOICE_SLIDER => 'slider',
						CS_CHOICE_NPS => 'nps',
						CS_GRID_RADIO => 'grid',
						CS_GRID_CHECKBOX => 'grid',
						CS_GRID_MATCHING => 'grid',
						CS_CHOICE_MULTIRATING => 'multirating',
						CS_IMAGE_CHOOSE_IMAGE => 'image',
						CS_IMAGE_CHOOSE_IMAGES => 'image',
						CS_CHOICE_RANKING => 'ranking',
						CS_FREE_TEXT_SINGLE_LINE => 'textbox',
						CS_FREE_TEXT_MULTILINE => 'textbox',
						CS_FREE_TEXT_PASSWORD => 'textbox',
						CS_FREE_TEXT_RICH_TEXT => 'rich_textbox',
						CS_SPECIAL_EMAIL => 'textbox',
						CS_SPECIAL_NAME => 'name',
						CS_SPECIAL_CALENDAR => 'calendar',
						CS_SPECIAL_ADDRESS => 'address',
						CS_SPECIAL_SIGNATURE => 'signature'
				);
				
				echo $this->sublayout ( $layouts [$item->question_type], array ('item' => $item, 'params' => $params) );
				?>
	    		<hr />
			</div>
	    	<?php
		}
	} 
	else 
	{
		?>
		<p class="alert alert-info">
		<i class="fa fa-info-circle"></i> <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS');?></p>
		<?php
	}
	?>
</div>