<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$theme 				= $params->get('theme', 'default');
$free_text 			= '';
$required			= $item->mandatory ? ' required' : '';
$correct_answer 	= true;
$icon 				= $item->question_type == CS_GRID_CHECKBOX ? 'fa fa-square-o' : 'fa fa-circle-o';
$colWidth			= count($item->columns) > 0 ? round(75 / count($item->columns), 2) : 0;
?>
<div class="table-responsive">
	<table style="border:1px solid grey; border-collapse:collapse;">
		<thead>
			<tr>
				<th style="border:1px solid grey; text-align: center;" width="25%"></th>
				<?php 
				foreach($item->columns as $column)
				{
					?>
					<th style="border:1px solid grey; text-align: center; padding: 5px;" width="<?php echo $colWidth;?>%"><?php echo $this->escape($column->title);?></th>
					<?php 
				}
				?>
			</tr>
		<thead>
		<tbody>
			<?php
			foreach($item->answers as $answer)
			{
				if($answer->answer_type != 'x')
				{
					continue;
				}
				?>
				<tr>
					<td style="border:1px solid grey; padding: 5px;"><?php echo $this->escape($answer->title);?></td>
					<?php
					foreach($item->columns as $column)
					{
						$votes = 0;
						foreach ($item->responses as $response)
						{
							if($response->answer_id == $answer->id && $response->column_id == $column->id)
							{
								$votes += $response->votes;
							}
						}
						?>
						<td style="border:1px solid grey; text-align: center;"><?php echo $votes;?></td>
						<?php 
					}
					?>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
</div>