<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

$params 			= $displayData['params'];
$item 				= $displayData['item'];
$free_text 			= '';
?>
<div class="pdf-question">
	<table border="1" cellpadding="2" cellspacing="0">
		<thead>
			<tr>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_QUESTION');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_ANSWER');?></th>
				<th><?php echo JText::_('COM_COMMUNITYSURVEYS_LABEL_RESULT');?></th>
			</tr>
		<thead>
		<tbody>
			<?php
			foreach($item->answers as $answer)
			{
			    $selected = true;
			    ?>
			    <tr>
                    <td><?php echo $this->escape($answer->title);?></td>
                    <td>
                        <?php 
                        if(!empty($item->responses))
                        {
                            $selected = false;
                            foreach($item->columns as $column)
                            {
                                foreach ($item->responses as $response)
                                {
                                    if($response->answer_id == $answer->id && $response->column_id == $column->id)
                                    {
                                        echo $this->escape($column->title);
                                        $selected = true;
                                        break;
                                    }
                                }
                            }
                        }
                        ?>
                    </td>
                    <td>
                        <?php 
                        if($selected)
                        {
                            ?><span style="font-family: zapfdingbats;">4</span>&nbsp;<?php 
                            echo JText::_('COM_COMMUNITYSURVEYS_RESULT_YOUR_ANSWER');
                        }
                        ?>
                    </td>
			    </tr>
			    <?php
			}
			?>
		</tbody>
	</table>
</div>