<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_communitysurveys/tables');
require_once JPATH_ADMINISTRATOR . '/components/com_communitysurveys/models/response.php';

class CommunitySurveysModelResponses extends CommunitySurveysModelResponse
{
    public function __construct($config = array())
    {
        parent::__construct($config);
    }
    
    public function getResponsesExportData($authorId)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $params = JComponentHelper::getParams('com_communitysurveys');
        $userDisplayName = $params->get('user_display_name', 'name');
        $data = new stdClass();
        
        // Select the required fields from the table.
        $query->select('a.id, a.survey_id, a.created, a.created_by, a.state, a.ip_address, a.completed')
        ->select('case when a.completed > a.created then '.
            $db->q(JText::_('COM_COMMUNITYSURVEYS_RESPONSE_FINALIZED')).' else '.
            $db->q(JText::_('COM_COMMUNITYSURVEYS_RESPONSE_PENDING')).' end as completion_status');
        $query->from('#__survey_responses AS a');
        
        // join over tracking table
        $query->select('c.country_name, t.city, t.browser_name, t.browser_version, t.os, t.browser_info')
        ->join('LEFT', '#__survey_tracking AS t ON t.post_id = a.id AND t.post_type = 1')
        ->join('LEFT', '#__corejoomla_countries AS c ON c.country_code = t.country AND c.language = '.$db->q('*'));
        
        // Join over the categories.
        $query->select('q.title AS title, q.alias, q.checked_out, q.checked_out_time, q.language')
        ->join('LEFT', '#__survey_surveys AS q ON q.id = a.survey_id');
        
        // Join over the users for the author.
        $query->select('ua.'.$userDisplayName.' AS author_name, ua.name, ua.username, ua.email')
        ->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
        
        $query->where('a.created_by = ' . (int) $authorId);
        
        // Add the list ordering clause.
        $orderCol = $this->state->get('list.ordering', 'a.id');
        $orderDirn = $this->state->get('list.direction', 'asc');
        $query->order($db->escape($orderCol . ' ' . $orderDirn));
        
        $db->setQuery($query);
        $data->responses = $db->loadObjectList();
        
        if(empty($data->responses))
        {
            return '';
        }
        
        JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
        $questionsModel = JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
        $state = $questionsModel->getState();
        $params = $state->get('params');
        
        $targetDir = CS_MEDIA_DIR . '/downloads/' . $authorId;
        $filename = $targetDir . '/export.zip';
        JFolder::create($targetDir);
        JFile::delete($filename);
        
        $zip = new ZipArchive();
        $zip->open($filename, ZipArchive::CREATE);
        $html = JLayoutHelper::render('export.data', array('data'=>$data));
        
        foreach ($data->responses as $response)
        {
            $questionsModel->setState('filter.survey_id', $response->survey_id);
            $questionsModel->setState('filter.category_id', null);
            $questionsModel->setState('filter.page_id', 0);
            $questionsModel->setState('filter.question_id', null);
            $questionsModel->setState('filter.unique', false);
            $questionsModel->setState('filter.response_id', $response->id);
            $questionsModel->setState('list.ordering', 'p.sort_order asc, a.sort_order');
            $questionsModel->setState('list.direction', 'asc');
            $questionsModel->setState('list.limit', 0);
            $questions = $questionsModel->getItems();
            
            $content = '';
            foreach ($questions as $question)
            {
                $question->rid = $response->id;
                $content .= SurveyHelper::renderLayout('bootstrap3.results.question', array('title'=>$response->title,'item'=>$question, 'params'=>$params));
            }
            
            $html = str_replace('REPLACE-'.$response->id, $content, $html);
        }
        
        JFile::write($targetDir . 'index.html', $html);
        $zip->addFile($targetDir . 'index.html', 'index.html');
        
        $zip->addFile(CJLIB_MEDIA_PATH . '/bootstrap/css/bootstrap.min.css', 'media/css/bootstrap.min.css');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/css/font-awesome.min.css', 'media/css/font-awesome.min.css');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/fonts/fontawesome-webfont.svg', 'media/fonts/fontawesome-webfont.svg');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/fonts/fontawesome-webfont.ttf', 'media/fonts/fontawesome-webfont.ttf');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/fonts/fontawesome-webfont.woff', 'media/fonts/fontawesome-webfont.woff');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/fonts/fontawesome-webfont.woff2', 'media/fonts/fontawesome-webfont.woff2');
        $zip->addFile(CJLIB_MEDIA_PATH . '/fontawesome/fonts/FontAwesome.eot', 'media/fonts/FontAwesome.eot');
        $zip->addFile(CJLIB_MEDIA_PATH . '/bootstrap/js/bootstrap.min.js', 'media/js/bootstrap.min.js');
        $zip->addFile(CJLIB_MEDIA_PATH . '/jquery/jquery-3.3.1.slim.min.js', 'media/js/jquery-3.3.1.slim.min.js');
        
        $zip->close();
        
        return $filename;
    }
}