<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysModelSurvey extends JModelItem
{
	protected $_context = 'com_communitysurveys.survey';

	protected function populateState ()
	{
		$app = JFactory::getApplication('site');
		
		// Load state from the request.
		$pk = $app->input->getInt('id');
		$this->setState('survey.id', $pk);

		// Load the parameters.
		$params = $app->getParams();
		$this->setState('params', $params);
		
		// TODO: Tune these values based on other permissions.
		$user = JFactory::getUser();
		
		if ((! $user->authorise('core.edit.state', 'com_communitysurveys')) && (! $user->authorise('core.edit', 'com_communitysurveys')))
		{
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}
		
		$this->setState('filter.language', JLanguageMultilang::isEnabled());
	}

	public function getItem ($pk = null)
	{
		$user = $this->getUser();
		$pk = (! empty($pk)) ? $pk : (int) $this->getState('survey.id');
		
		if ($this->_item === null)
		{
			$this->_item = array();
		}
		
		if (! isset($this->_item[$pk]))
		{
			$params = JComponentHelper::getParams('com_communitysurveys');
			$userDisplayName = $params->get('user_display_name', 'name');
			
			try
			{
				$db = $this->getDbo();
				$query = $db->getQuery(true)->select(
						$this->getState('item.select', 
								'a.id, a.title, a.alias, a.description, a.endtext, a.custom_header, a.responses, a.metakey, a.metadesc, a.access, a.metadata,'. 
								'a.language, a.ip_address, a.published, a.private, a.max_responses, a.survey_key, a.redirect_url, a.restrictions,'.
								// If badcats is not null, this means that the survey is inside an unpublished category
								// In this case, the state is set to 0 to indicate Unpublished (even if the survey state is Published)
								'CASE WHEN badcats.id is null THEN a.published ELSE 0 END AS state, a.catid, a.created, a.created_by, ' . 
								'CASE WHEN a.modified = ' . $db->quote($db->getNullDate()) .' THEN a.created ELSE a.modified END as modified, ' .
								'a.modified_by, a.checked_out, a.checked_out_time, a.publish_up, a.publish_down, a.attribs, a.ordering'));
				
				$query->from('#__survey_surveys AS a');
				
				// Join on category table.
				$query
					->select('c.title AS category_title, c.alias AS category_alias, c.access AS category_access')
					->join('LEFT', '#__categories AS c on c.id = a.catid');
				
				// Join on user table.
				$query
					->select('u.'.$userDisplayName.' AS author')
					->select('u.email AS author_email')
					->join('LEFT', '#__users AS u on u.id = a.created_by');
				
				// Filter by language
				if ($this->getState('filter.language'))
				{
					$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
				}
				
				// Join over the categories to get parent category titles
				$query
					->select('parent.title as parent_title, parent.id as parent_id, parent.path as parent_route, parent.alias as parent_alias')
					->join('LEFT', '#__categories as parent ON parent.id = c.parent_id')
					->where('a.id = ' . (int) $pk);
				
				if ((! $user->authorise('core.edit.state', 'com_communitysurveys')) && (! $user->authorise('core.edit', 'com_communitysurveys')))
				{
					// Filter by start and end dates.
					$nullDate = $db->quote($db->getNullDate());
					$date = JFactory::getDate();
					
					$nowDate = $db->quote($date->toSql());
					
					$query
						->where('(a.publish_up = ' . $nullDate . ' OR a.publish_up <= ' . $nowDate . ')')
						->where('(a.publish_down = ' . $nullDate . ' OR a.publish_down >= ' . $nowDate . ')');
				}
				
				// Join to check for category published state in parent categories up the tree
				// If all categories are published, badcats.id will be null, and we just use the survey state
				$subquery = ' (SELECT cat.id as id FROM #__categories AS cat JOIN #__categories AS parent ';
				$subquery .= 'ON cat.lft BETWEEN parent.lft AND parent.rgt ';
				$subquery .= 'WHERE parent.extension = ' . $db->quote('com_communitysurveys');
				$subquery .= ' AND parent.published <= 0 GROUP BY cat.id)';
				$query->join('LEFT OUTER', $subquery . ' AS badcats ON badcats.id = c.id');
				
				// Filter by published state.
				$published = $this->getState('filter.published');
				$archived = $this->getState('filter.archived');
				
				if (is_numeric($published))
				{
					$query->where('(a.published = ' . (int) $published . ' OR a.published =' . (int) $archived . ')');
				}
// echo $query->dump();
// jexit();				
				$db->setQuery($query);
				$data = $db->loadObject();
				
				if (empty($data))
				{
				    throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_SURVEY_NOT_FOUND'), 404);
				}
				
				// Check for published state if filter set.
				if (((is_numeric($published)) || (is_numeric($archived))) && (($data->state != $published) && ($data->state != $archived)))
				{
				    throw new Exception(JText::_('COM_COMMUNITYSURVEYS_ERROR_SURVEY_NOT_FOUND'), 404);
				}
				
				// Convert parameter fields to objects.
				$registry = new JRegistry();
				$registry->loadString($data->attribs);
				$params = $this->getState('params');
				
				if($params)
				{
				    $data->params = clone $params;
				}
				else 
				{
				    $data->params =  new JRegistry();
				}
				
				$data->params->merge($registry);
				
				$registry = new JRegistry();
				$registry->loadString($data->metadata);
				$data->metadata = $registry;
				
				// Technically guest could edit an survey, but lets not check
				// that to improve performance a little.
				if (! $user->get('guest'))
				{
					$userId = $user->get('id');
					$asset = 'com_communitysurveys.survey.' . $data->id;
					
					// Check general edit permission first.
					if ($user->authorise('core.edit', $asset))
					{
						$data->params->set('access-edit', true);
					}
					// Now check if edit.own is available.
					elseif (! empty($userId) && $user->authorise('core.edit.own', $asset))
					{
						// Check for a valid user and that they are the owner.
						if ($userId == $data->created_by)
						{
							$data->params->set('access-edit', true);
						}
					}
					
					// Check general edit state permission first.
					if ($user->authorise('core.edit.state', $asset))
					{
						$data->params->set('access-edit-state', true);
					}
					// Now check if edit.state.own is available.
					elseif (! empty($userId) && $user->authorise('core.edit.state.own', $asset))
					{
						// Check for a valid user and that they are the owner.
						if ($userId == $data->created_by)
						{
							$data->params->set('access-edit-state', true);
						}
					}
				}
				
				// Compute view access permissions.
				if ($access = $this->getState('filter.access'))
				{
					// If the access filter has been set, we already know this
					// user can view.
					$data->params->set('access-view', true);
				}
				else
				{
					// If no access filter is set, the layout takes some
					// responsibility for display of limited information.
					$groups = $user->getAuthorisedViewLevels();
					
					if ($data->catid == 0 || $data->category_access === null)
					{
						$data->params->set('access-view', in_array($data->access, $groups));
					}
					else
					{
						$data->params->set('access-view', in_array($data->access, $groups) && in_array($data->category_access, $groups));
					}
				}
				
				$app = JFactory::getApplication();
				$language = $app->input->getCmd('lang', JFactory::getLanguage()->getTag());
				if(!empty($language))
				{
				    JLoader::import('language', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
				    $languageModel = JModelAdmin::getInstance( 'language', 'CommunitySurveysModel' );
				    
				    $translations = $languageModel->getSurveyTranslations($data->id, $language);
				    if(!empty($translations))
				    {
				        $data->language = $language;
			            foreach ($translations as $translation)
			            {
			                switch ($translation->item_type) {
			                    case CS_TRANSLATION_SURVEY_TITLE:
			                        $data->title = $translation->translation;
			                        break;
			                    
			                    case CS_TRANSLATION_SURVEY_DESC:
			                        $data->description = $translation->translation;
			                        break;
			                    
			                    case CS_TRANSLATION_SURVEY_ENDTEXT:
			                        $data->endtext = $translation->translation;
			                        break;
			                        
			                    case CS_TRANSLATION_SURVEY_HEADER:
			                        $data->custom_header = $translation->translation;
			                        break;
			                }
			                
			                if($translation->item_type == CS_TRANSLATION_PAGE_TITLE && $data->id == $translation->item_id)
			                {
			                    if(!empty($translation->translation))
			                    {
			                        $data->title = $translation->translation;
			                    }
			                    break;
			                }
			            }
				    }
				}
				
				$this->_item[$pk] = $data;
			}
			catch (Exception $e)
			{
				if ($e->getCode() == 404)
				{
					// Need to go thru the error handler to allow Redirect to work.
				    throw new Exception($e->getMessage(), 404);
				}
				else
				{
					$this->setError($e);
					$this->_item[$pk] = false;
				}
			}
		}
		
		return $this->_item[$pk];
	}
	
    public function getError($i = null, $toString = true){
    	
    	return $this->_error;
    }
    
    public function setError($error){
    	
    	$this->_error = $error;
    }
    
    private function getUser()
    {
    	$user = $this->getState('user');
    	if(empty($user))
    	{
    		$user = JFactory::getUser();
    	}
    
    	return $user;
    }
}
?>