<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

class CommunitySurveysViewForm extends JViewLegacy
{

	protected $form;

	protected $item;

	protected $return_page;

	protected $state;

	public function display ($tpl = null)
	{
		$user = JFactory::getUser();
		
		// Get model data.
		$this->state 		= $this->get('State');
		$this->item 		= $this->get('Item');
		$this->form 		= $this->get('Form');
		$this->return_page 	= $this->get('ReturnPage');
		$this->api			= new CjLibApi();
		
		if (empty($this->item->id))
		{
			$authorised = $user->authorise('core.create', 'com_communitysurveys') || 
				(count($user->getAuthorisedCategories('com_communitysurveys', 'core.create')));
		}
		else
		{
			$authorised = $this->item->params->get('access-edit');
			
			// Allow the user to edit questions till the survey is published
			if( !$authorised )
			{
				if($user->id == $this->item->created_by && $this->item->published == 3)
				{
					$authorised = true;
				}
			}
		}
		
		if ($authorised !== true)
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$this->item->tags = new JHelperTags();
		if (! empty($this->item->id))
		{
			$this->item->tags->getItemTags('com_communitysurveys.survey.', $this->item->id);
		}
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
		
		// Create a shortcut to the parameters.
		$params = &$this->state->params;
		
		// Escape strings for HTML output
		$this->pageclass_sfx = htmlspecialchars($params->get('pageclass_sfx'));
		
		$this->params = $params;
		$this->user = $user;
		
		if ($params->get('enable_category') == 1)
		{
			$this->form->setFieldAttribute('catid', 'default', $params->get('catid', 1));
			$this->form->setFieldAttribute('catid', 'readonly', 'true');
		}
		
		if($this->getLayout() == 'questions')
		{
			if(empty($this->item) || !$this->item->id)
			{
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
			}
			
			JLoader::import('joomla.application.component.model');
			JLoader::import('questions', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
			JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
			
			$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
			$questionsModel->getState(); // access the state first so that it can be modified
			
			$pages = $questionsModel->getPages($this->item->id);
			$pid = 0;
			if(!empty($pages) && isset($pages[0]))
			{
				$pid = $pages[0]->id;
			}

			$questionsModel->setState('filter.survey_id', $this->item->id);
			$questionsModel->setState('filter.category_id', 0);
			$questionsModel->setState('filter.page_id', $pid);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('list.ordering', 'a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			$this->questions = &$questions;
			$this->pages = &$pages;
			$this->pid = $pid;
		}
		
		if($this->getLayout() == 'preview')
		{
			if(empty($this->item) || !$this->item->id)
			{
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR').': RC=1', 403);
			}
			
			JLoader::import('joomla.application.component.model');
			JLoader::import('questions', JPATH_ROOT.'/components/com_communitysurveys/models');
			JLoader::import('rules', JPATH_ADMINISTRATOR.'/components/com_communitysurveys/models');
			
			$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
			$questionsModel->getState(); // access the state first so that it can be modified
			$pages = $questionsModel->getPages($this->item->id);
			
			$questionsModel->setState('filter.survey_id', $this->item->id);
			$questionsModel->setState('filter.category_id', 0);
			$questionsModel->setState('filter.page_id', 0);
			$questionsModel->setState('filter.question_id', null);
			$questionsModel->setState('list.ordering', 'a.sort_order');
			$questionsModel->setState('list.direction', 'asc');
			$questionsModel->setState('list.limit', 0);
			$questions = $questionsModel->getItems();
			
			$this->questions = &$questions;
			$this->pages = &$pages;
			
			$app = JFactory::getApplication();
			$app->input->set('tmpl', 'component');
			$app->input->set('format', 'raw');
		}
		
		JFactory::getLanguage()->load('com_communitysurveys', JPATH_ADMINISTRATOR);
		$this->_prepareDocument();
		
		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function _prepareDocument ()
	{
		$app = JFactory::getApplication();
		$menus = $app->getMenu();
		$title = null;
		
		// Because the application sets a default page title,
		// we need to get it from the menu item itself
		$menu = $menus->getActive();
		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_COMMUNITYSURVEYS_FORM_EDIT_SURVEY'));
		}
		
		$title = $this->params->def('page_title', JText::_('COM_COMMUNITYSURVEYS_FORM_EDIT_SURVEY'));
		if ($app->get('sitename_pagetitles', 0) == 1)
		{
		    $title = JText::sprintf('JPAGETITLE', $app->get('sitename'), $title);
		}
		elseif ($app->get('sitename_pagetitles', 0) == 2)
		{
		    $title = JText::sprintf('JPAGETITLE', $title, $app->get('sitename'));
		}
		$this->document->setTitle($title);
		
		$pathway = $app->getPathWay();
		$pathway->addItem($title, '');
		
		if ($this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}
		
		if ($this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
	}
	
	public function getForm()
	{
		if (!is_object($this->form))
		{
			$this->form = $this->get('Form');
		}

		return $this->form;
	}
}
