<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewReport extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	public function display($tpl = null)
	{
		$app          = JFactory::getApplication();
		$user         = JFactory::getUser();
		$this->item   = $this->get('Item');
		$this->state  = $this->get('State');
		$this->layout = $this->getLayout();
		$this->params = $this->state->get('params');
		
		if($user->guest || ($this->item->created_by != $user->id && !$user->authorise('core.admin', 'com_communitysurveys.survey.'.$this->item->id)))
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		switch ($this->layout)
		{
			case 'response':
				
				$rid = $app->input->getInt('rid', 0);
				JLoader::import('response', JPATH_ROOT.'/components/com_communitysurveys/models');
				$responseModel = JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
				$filename = @$responseModel->createPdfResponse($this->item->id, $rid);
				
				if(file_exists($filename))
				{
					$document = JFactory::getDocument();
					$document->setMimeEncoding('application/pdf');
					JFactory::getApplication()->setHeader(
							'Content-disposition', 'attachment; filename="'.basename($filename).'"; creation-date="' . JFactory::getDate()->toRFC822() . '"', true);
					readfile($filename);
				}
				
				break;
				
			case 'consolidated':
			default:
				
				$this->report = $this->get('consolidatedReport');
				$html = SurveyHelper::renderLayout('pdf.reports.consolidated', array('data'=>$this), CS_LAYOUTS_BASE_PATH);
				
				// create new PDF document
				require_once JPATH_ROOT.'/components/com_communitysurveys/helpers/tcpdf.php';
				$pdf = new CJQPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
				
				// set default header data
				$pdf->SetHeaderData('', 0, $this->item->title, '');
				
				// set document information
				$pdf->SetCreator(PDF_CREATOR);
				$pdf->SetAuthor('corejoomla.com');
				$pdf->SetTitle('Survey Report');
				$pdf->SetSubject('Survey Consolidated Report');
				$pdf->SetKeywords('survey, report');
				
				// set header and footer fonts
				$fontname = $this->params->get('pdf_fontname', 'helvetica');
				
				$pdf->setHeaderFont(Array($fontname, '', PDF_FONT_SIZE_MAIN));
				$pdf->setFooterFont(Array($fontname, '', PDF_FONT_SIZE_DATA));
				
				// set default monospaced font
				$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
				
				//set margins
				$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
				$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
				$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
				
				//set auto page breaks
				$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
				
				//set image scale factor
				$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
				
				// ---------------------------------------------------------
				
				// set font
				$pdf->SetFont($fontname);
				$pdf->AddPage();
				$pdf->writeHTML($html, true, false, true, false, '');
				$pdf->lastPage();
				$pdf->Output('report.pdf', 'D');
				break;
		}
	}
}
