<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewResult extends JViewLegacy
{
	public $items;

	public $pagination;

	public $state;

	public function display($tpl = null)
	{
		$app			= JFactory::getApplication();
		$user			= JFactory::getUser();
		$model			= $this->getModel();
		
		$this->id		= $app->input->getInt('id', 0);
		$this->rid 		= $app->input->getInt('rid', 0);
		$this->key 		= $app->input->getCmd('key');

		if($user->guest && empty($this->key))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		if(!$model->isUserAuthorised($this->id, $this->rid, $this->key) && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->id))
		{
			throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		$this->item   = $this->get('Item');
		$this->print  = $app->input->getBool('print');
		$this->state  = $this->get('State');
		$this->params = $this->state->get('params');
		$this->layout = $this->getLayout();
		$this->name   = $this->get('name');
		
		$model->setState('response.id', $this->rid);
		$this->questions = $this->get('Response');
		
		if($this->print)
		{
			$app->input->set('tmpl', 'component');
			$app->input->set('format', 'raw');
			JFactory::getDocument()->setMetaData('robots', 'noindex, nofollow');
		}

		parent::display($tpl);
	}
}