<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('JPATH_PLATFORM') or die;

class CommunitySurveysViewReport extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	public function display($tpl = null)
	{
		$app          = JFactory::getApplication();
		$user         = JFactory::getUser();
		$model        = $this->getModel();
		$this->item   = $this->get('Item');
		$this->state  = $this->get('State');
		$this->layout = $this->getLayout();
		$this->params = $this->state->get('params');
		
		if($user->guest || ($this->item->created_by != $user->id && !$user->authorise('core.manage', 'com_communitysurveys.survey.'.$this->item->id)))
		{
		    throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
		}
		
		switch ($this->layout)
		{
			case 'response':
				
				$rid = $app->input->getInt('rid', 0);
				JLoader::import('response', JPATH_ROOT.'/components/com_communitysurveys/models');
				$responseModel = JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
				$filename = @$responseModel->createPdfResponse($this->item->id, $rid);
				
				if(file_exists($filename))
				{
					$document = JFactory::getDocument();
					$document->setMimeEncoding('application/pdf');
					JFactory::getApplication()->setHeader(
							'Content-disposition', 'attachment; filename="'.basename($filename).'"; creation-date="' . JFactory::getDate()->toRFC822() . '"', true);
					readfile($filename);
				}
				
				break;
				
			case 'consolidated':
			default:
				
				$this->report = $this->get('consolidatedReport');
				break;
		}
	}
}
