<?php
/**
 * @package     corejoomla.administrator
 * @subpackage  com_communitysurveys
 *
 * @copyright   Copyright (C) 2009 - 2019 corejoomla.com. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();

class CommunitySurveysViewSurvey extends JViewLegacy
{
	public $item;
	public $params;
	public $print;
	public $state;
	public $user;

	public function display ($tpl = null)
	{
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		
		$this->item			= $this->get('Item');
		$this->print		= $app->input->getBool('print');
		$this->key			= $app->input->getCmd('key');
		$this->skey			= $app->input->getCmd('skey');
		$this->state		= $this->get('State');
		$this->user			= &$user;
		$this->asset		= 'com_communitysurveys.survey.'.$this->item->id;
		$this->api			= new CjLibApi();
		$this->pageId 		= 0;
		$this->pagination	= null;
		$this->response		= null;

		// Create a shortcut for $item.
		$item 				= $this->item;
		$item->offset		= $this->state->get('list.offset');
		$item->tagLayout	= new JLayoutFile('joomla.content.tags');
		
		// Add router helpers.
		$item->slug 		= $item->alias ? ($item->id . ':' . $item->alias) : $item->id;
		$item->catslug 		= $item->category_alias ? ($item->catid . ':' . $item->category_alias) : $item->catid;
		$item->parent_slug 	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;
		
		// Merge survey params. If this is single-survey view, menu params override survey params
		// Otherwise, survey params override menu item params
		$this->params 		= $item->params;
		$active 			= $app->getMenu()->getActive();
		$temp 				= clone ($this->params);
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
		    throw new Exception(implode('\n', $errors), 500);
		}
				
		// No link for ROOT category
		if ($item->parent_alias == 'root')
		{
			$item->parent_slug = null;
		}
		
		// TODO: Change based on shownoauth
		$key = $app->input->getCmd('key');
		$skey = $app->input->getCmd('skey');
		$this->surveyUri = CommunitySurveysHelperRoute::getSurveyRoute($item->slug, $item->catslug);
		
		if($key) 
		{
		    $this->surveyUri = $this->surveyUri . '&key='.$key;
		}
		else if($skey)
		{
		    $this->surveyUri = $this->surveyUri . '&skey='.$skey;
		}
		
		$item->readmore_link = JRoute::_($this->surveyUri);
		
		// Check to see which parameters should take priority
		if ($active)
		{
			$currentLink = $active->link;
			
			// If the current view is the active item and an survey view for
			// this survey, then the menu item params take priority
			if (strpos($currentLink, 'view=survey') && (strpos($currentLink, '&id=' . (string) $item->id)))
			{
				// Load layout from active query (in case it is an alternative menu item)
				if (isset($active->query['layout']))
				{
					$this->setLayout($active->query['layout']);
				}
				// Check for alternative layout of survey
				elseif ($layout = $item->params->get('survey_layout'))
				{
					$this->setLayout($layout);
				}
				
				// $item->params are the survey params, $temp are the menu item params
				// Merge so that the menu item params take priority
				$item->params->merge($temp);
			}
			else
			{
				// Current view is not a single survey, so the survey params take priority here
				// Merge the menu item params with the survey params so that the survey params take priority
				$temp->merge($item->params);
				$item->params = $temp;
				
				// Check for alternative layouts (since we are not in a single-survey menu item)
				// Single-survey menu item layout takes priority over alt layout for an survey
				if ($layout = $item->params->get('survey_layout'))
				{
					$this->setLayout($layout);
				}
			}
		}
		else
		{
			// Merge so that survey params take priority
			$temp->merge($item->params);
			$item->params = $temp;
			
			// Check for alternative layouts (since we are not in a single-survey menu item)
			// Single-survey menu item layout takes priority over alt layout for an survey
			if ($layout = $item->params->get('survey_layout'))
			{
				$this->setLayout($layout);
			}
		}
		
		if( !$user->authorise('core.respond', 'com_communitysurveys.survey.' . $item->id) )
		{
			if($user->guest)
			{
			    $redirectUrl = base64_encode($this->surveyUri);
				$loginUrl = JRoute::_('index.php?option=com_users&view=login&return='.$redirectUrl, false);
// 				$app->enqueueMessage(JText::_('COM_COMMUNITYSURVEYS_ERROR_LOGIN_TO_EXECUTE'));
				$app->redirect($loginUrl);
				return;
			}
			else 
			{
				throw new Exception(JText::_('JERROR_ALERTNOAUTHOR'), 403);
			}
		}
		
		if( ! $item->params->get('show_intro') )
		{
			try
			{
				$responseModel	= JModelLegacy::getInstance( 'response', 'CommunitySurveysModel' );
				$responseModel->getState(); // access the state first so that it can be modified
				$response = $responseModel->createOrUpdateResponse($item->id, true, true); // skip create and find response
				$responseModel->setState('filter.page_id', $response->curr_page);
				$pagination = $responseModel->getPagination();
				$pageId = $pagination->getCurrPageId();
				
				if( !$pageId )
				{
					// start page, create or update response
					$app->setUserState('com_communitysurveys.response.'.$response->response_id, $response);
					$pageId = $pagination->getNextPageId();
					
					$pagination = new SurveyPagination($item->id, $pageId);
				}
		
				$questionsModel	= JModelLegacy::getInstance( 'questions', 'CommunitySurveysModel' );
				$questionsModel->getState(); // access the state first so that it can be modified
		
				$questionsModel->setState('filter.survey_id', $item->id);
				$questionsModel->setState('filter.response_id', $response->response_id);
				$questionsModel->setState('filter.category_id', 0);
				$questionsModel->setState('filter.page_id', $pageId);
				$questionsModel->setState('filter.question_id', null);
				$questionsModel->setState('list.ordering', 'a.sort_order');
				$questionsModel->setState('list.direction', 'asc');
				$questionsModel->setState('list.limit', 0);
				$questions = $questionsModel->getItems();
				
				$this->questions = &$questions;
				$this->response = &$response;
				$this->pagination = &$pagination;
				$this->pageId = $pageId;
			}
			catch (Exception $e)
			{
				$app->redirect(JRoute::_(CommunitySurveysHelperRoute::getSurveysRoute()), $e->getMessage());
			}
		}
		
		$item->tags = new JHelperTags();
		$item->tags->getItemTags('com_communitysurveys.survey', $item->id);
		
		// Process the content plugins for survey description
		JPluginHelper::importPlugin('content');
		$item->text = $item->description;
		$app->triggerEvent('onContentPrepare', array('com_communitysurveys.survey',	&$item,	&$this->params,	$item->offset));
		$item->description = $item->text;

		$item->event = new stdClass();
		$results = $app->triggerEvent('onContentAfterTitle', array('com_communitysurveys.survey', &$item, &$this->params, $item->offset));
		$item->event->afterDisplayTitle = trim(implode("\n", $results));
		
		$results = $app->triggerEvent('onContentBeforeDisplay', array('com_communitysurveys.survey', &$item, &$this->params, $item->offset));
		$item->event->beforeDisplayContent = trim(implode("\n", $results));
		
		$results = $app->triggerEvent('onContentAfterDisplay', array('com_communitysurveys.survey', &$item, &$this->params, $item->offset));
		$item->event->afterDisplayContent = trim(implode("\n", $results));

		// Increment the hit counter of the survey.
		$cookie = (int) $app->input->cookie->get('survey_id_last_visited');
		if($cookie != $item->id)
		{
			$app->input->cookie->set('survey_id_last_visited', $item->id, 0, '/');
		}
		
		// Escape strings for HTML output
		$this->pageclass_sfx = htmlspecialchars($item->params->get('pageclass_sfx'));
		$this->_prepareDocument();
		
		$appParams = JComponentHelper::getParams('com_communitysurveys');
		if ($this->hideTemplate($appParams->get('hide_template', 0), $item->params->get('show_template', 1))) 
		{
		    $app->input->set('tmpl', 'component');
		    $app->input->set('format', 'raw');
		    $this->hide_template = 1;
		} 
		else 
		{
		    $this->hide_template = 0;
		}
		
		parent::display($tpl);
	}

	function hideTemplate($config_value, $user_value)
	{
	    if($config_value == '1') // force hide
	    { 
	        return true;
	    } 
	    else if($config_value == '2') // force show
	    {
	        return false;
	    } 
	    else if($user_value == 0) //user selectible
	    {
	        return true; // hide template as survey show_template value is not set
	    } 
	    else 
	    {
	        return false;
	    }
	}
	
	/**
	 * Prepares the document
	 */
	protected function _prepareDocument ()
	{
		$app = JFactory::getApplication();
		$menus = $app->getMenu();
		$pathway = $app->getPathway();
		$title = null;
		
		// Because the application sets a default page title, we need to get it from the menu item itself
		$menu = $menus->getActive();
		
		if ($menu)
		{
			$this->params->def('page_heading', $this->params->get('page_title', $menu->title));
		}
		else
		{
			$this->params->def('page_heading', JText::_('COM_COMMUNITYSURVEYS_QUESTIONS'));
		}
		
		$title = $this->params->get('page_title', '');
		
		$id = (int) @$menu->query['id'];
		
		// if the menu item does not concern this survey
		if (!$menu || $menu->query['option'] != 'com_communitysurveys' || $menu->query['view'] != 'survey' || $id != $this->item->id)
		{
			// If this is not a single survey menu item, set the page title to the survey title
			if ($this->item->title)
			{
				$title = $this->item->title;
			}
			
			$path = array(array('title' => $this->item->title, 'link' => ''));
			$category = JCategories::getInstance('CommunitySurveys')->get($this->item->catid);
			
			while ($category && (!$menu || $menu->query['option'] != 'com_communitysurveys' || $menu->query['view'] == 'survey' || $id != $category->id) && $category->id > 1)
			{
				$path[] = array('title' => $category->title, 'link' => CommunitySurveysHelperRoute::getCategoryRoute($category->id));
				$category = $category->getParent();
			}
			$path = array_reverse($path);
			
			foreach ($path as $item)
			{
				$pathway->addItem($item['title'], $item['link']);
			}
		}
		
		// Check for empty title and add site name if param is set
		if (empty($title))
		{
			$title = $app->getCfg('sitename');
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 1)
		{
			$title = JText::sprintf('JPAGETITLE', $app->getCfg('sitename'), $title);
		}
		elseif ($app->getCfg('sitename_pagetitles', 0) == 2)
		{
			$title = JText::sprintf('JPAGETITLE', $title, $app->getCfg('sitename'));
		}
		
		if (empty($title))
		{
			$title = $this->item->title;
		}
		$this->document->setTitle($title);
		
		if ($this->item->metadesc)
		{
			$this->document->setDescription($this->item->metadesc);
		}
		elseif (! $this->item->metadesc && $this->params->get('menu-meta_description'))
		{
			$this->document->setDescription($this->params->get('menu-meta_description'));
		}
		
		if ($this->item->metakey)
		{
			$this->document->setMetadata('keywords', $this->item->metakey);
		}
		elseif (! $this->item->metakey && $this->params->get('menu-meta_keywords'))
		{
			$this->document->setMetadata('keywords', $this->params->get('menu-meta_keywords'));
		}
		
		if ($this->params->get('robots'))
		{
			$this->document->setMetadata('robots', $this->params->get('robots'));
		}
		
		if ($app->getCfg('MetaAuthor') == '1')
		{
			$this->document->setMetaData('author', $this->item->author);
		}
		
		$mdata = $this->item->metadata->toArray();
		
		foreach ($mdata as $k => $v)
		{
			if ($v)
			{
				$this->document->setMetadata($k, $v);
			}
		}
		
		// If there is a pagebreak heading or title, add it to the page title
		if (! empty($this->item->page_title))
		{
			$this->item->title = $this->item->title . ' - ' . $this->item->page_title;
			$this->document->setTitle($this->item->page_title . ' - ' . JText::sprintf('PLG_CONTENT_PAGEBREAK_PAGE_NUM', $this->state->get('list.offset') + 1));
		}
		
		if ($this->print)
		{
			$this->document->setMetaData('robots', 'noindex, nofollow');
		}
	}
}