<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_template_args = get_query_var( 'vapester_template_args' );
if ( is_array( $vapester_template_args ) ) {
	$vapester_columns    = empty( $vapester_template_args['columns'] ) ? 1 : max( 1, min( 3, $vapester_template_args['columns'] ) );
	$vapester_blog_style = array( $vapester_template_args['type'], $vapester_columns );
} else {
	$vapester_blog_style = explode( '_', vapester_get_theme_option( 'blog_style' ) );
	$vapester_columns    = empty( $vapester_blog_style[1] ) ? 1 : max( 1, min( 3, $vapester_blog_style[1] ) );
}
$vapester_expanded    = ! vapester_sidebar_present() && vapester_is_on( vapester_get_theme_option( 'expand_content' ) );
$vapester_post_format = get_post_format();
$vapester_post_format = empty( $vapester_post_format ) ? 'standard' : str_replace( 'post-format-', '', $vapester_post_format );
$vapester_animation   = vapester_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
									<?php
									post_class(
										'post_item'
										. ' post_layout_chess'
										. ' post_layout_chess_' . esc_attr( $vapester_columns )
										. ' post_format_' . esc_attr( $vapester_post_format )
										. ( ! empty( $vapester_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
									);
									echo ( ! vapester_is_off( $vapester_animation ) && empty( $vapester_template_args['slider'] ) ? ' data-animation="' . esc_attr( vapester_get_animation_classes( $vapester_animation ) ) . '"' : '' );
									?>
	>

	<?php
	// Add anchor
	if ( 1 == $vapester_columns && ! is_array( $vapester_template_args ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode( '[trx_sc_anchor id="post_' . esc_attr( get_the_ID() ) . '" title="' . esc_attr( get_the_title() ) . '" icon="' . esc_attr( vapester_get_post_icon() ) . '"]' );
	}

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$vapester_hover = ! empty( $vapester_template_args['hover'] ) && ! vapester_is_inherit( $vapester_template_args['hover'] )
						? $vapester_template_args['hover']
						: vapester_get_theme_option( 'image_hover' );
	vapester_show_post_featured(
		array(
			'class'         => 1 == $vapester_columns && ! is_array( $vapester_template_args ) ? 'vapester-full-height' : '',
			'singular'      => false,
			'hover'         => $vapester_hover,
			'no_links'      => ! empty( $vapester_template_args['no_links'] ),
			'show_no_image' => true,
			'thumb_ratio'   => '1:1',
			'thumb_bg'      => true,
			'thumb_size'    => vapester_get_thumb_size(
				strpos( vapester_get_theme_option( 'body_style' ), 'full' ) !== false
										? ( 1 < $vapester_columns ? 'huge' : 'original' )
										: ( 2 < $vapester_columns ? 'big' : 'huge' )
			),
		)
	);

	?>
	<div class="post_inner"><div class="post_inner_content"><div class="post_header entry-header">
		<?php
			do_action( 'vapester_action_before_post_title' );

			// Post title
		$tag = ( isset($vapester_columns) && $vapester_columns > 1 ) ? 'h6' : 'h4';
		if ( empty( $vapester_template_args['no_links'] ) ) {
			the_title( sprintf( '<' . $tag . ' class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></' . $tag . '>' );
		} else {
			the_title( '<' . $tag . ' class="post_title entry-title">', '</' . $tag . '>' );
		}

			do_action( 'vapester_action_before_post_meta' );

			// Post meta
			$vapester_components = vapester_array_get_keys_by_value( vapester_get_theme_option( 'meta_parts' ) );
			$vapester_counters   = vapester_array_get_keys_by_value( vapester_get_theme_option( 'counters' ) );
			$vapester_post_meta  = empty( $vapester_components ) || in_array( $vapester_hover, array( 'border', 'pull', 'slide', 'fade' ) )
										? ''
										: vapester_show_post_meta(
											apply_filters(
												'vapester_filter_post_meta_args', array(
													'components' => $vapester_components,
													'counters' => $vapester_counters,
													'seo'  => false,
													'echo' => false,
												), $vapester_blog_style[0], $vapester_columns
											)
										);
			vapester_show_layout( $vapester_post_meta );
			?>
		</div><!-- .entry-header -->

		<div class="post_content entry-content">
		<?php
		if ( empty( $vapester_template_args['hide_excerpt'] ) && ( isset($vapester_columns) && $vapester_columns < 2 )) {
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
					the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
					the_content( '' );
				} elseif ( in_array( $vapester_post_format, array( 'link', 'aside', 'status' ) ) ) {
					the_content();
				} elseif ( 'quote' == $vapester_post_format ) {
					$quote = vapester_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {
						vapester_show_layout( wpautop( $quote ) );
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
		}
			// Post meta
		if ( in_array( $vapester_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			vapester_show_layout( $vapester_post_meta );
		}
			// More button
		if ( empty( $vapester_template_args['no_links'] ) && ! in_array( $vapester_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
			?>
				<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'vapester' ); ?></a></p>
				<?php
		}
		?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
