<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.50
 */

$vapester_template_args = get_query_var( 'vapester_template_args' );
if ( is_array( $vapester_template_args ) ) {
	$vapester_columns    = empty( $vapester_template_args['columns'] ) ? 2 : max( 1, $vapester_template_args['columns'] );
	$vapester_blog_style = array( $vapester_template_args['type'], $vapester_columns );
} else {
	$vapester_blog_style = explode( '_', vapester_get_theme_option( 'blog_style' ) );
	$vapester_columns    = empty( $vapester_blog_style[1] ) ? 2 : max( 1, $vapester_blog_style[1] );
}
$vapester_blog_id       = vapester_get_custom_blog_id( join( '_', $vapester_blog_style ) );
$vapester_blog_style[0] = str_replace( 'blog-custom-', '', $vapester_blog_style[0] );
$vapester_expanded      = ! vapester_sidebar_present() && vapester_is_on( vapester_get_theme_option( 'expand_content' ) );
$vapester_animation     = vapester_get_theme_option( 'blog_animation' );
$vapester_components    = vapester_array_get_keys_by_value( vapester_get_theme_option( 'meta_parts' ) );
$vapester_counters      = vapester_array_get_keys_by_value( vapester_get_theme_option( 'counters' ) );

$vapester_post_format   = get_post_format();
$vapester_post_format   = empty( $vapester_post_format ) ? 'standard' : str_replace( 'post-format-', '', $vapester_post_format );

$vapester_blog_meta     = vapester_get_custom_layout_meta( $vapester_blog_id );
$vapester_custom_style  = ! empty( $vapester_blog_meta['scripts_required'] ) ? $vapester_blog_meta['scripts_required'] : 'none';

if ( ! empty( $vapester_template_args['slider'] ) || $vapester_columns > 1 || ! vapester_is_off( $vapester_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $vapester_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo ( vapester_is_off( $vapester_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $vapester_custom_style ) ) . '-1_' . esc_attr( $vapester_columns );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" 
<?php
	post_class(
			'post_item post_format_' . esc_attr( $vapester_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $vapester_columns )
					. ' post_layout_' . esc_attr( $vapester_blog_style[0] )
					. ' post_layout_' . esc_attr( $vapester_blog_style[0] ) . '_' . esc_attr( $vapester_columns )
					. ( ! vapester_is_off( $vapester_custom_style )
						? ' post_layout_' . esc_attr( $vapester_custom_style )
							. ' post_layout_' . esc_attr( $vapester_custom_style ) . '_' . esc_attr( $vapester_columns )
						: ''
						)
		);
	echo ( ! vapester_is_off( $vapester_animation ) && empty( $vapester_template_args['slider'] ) ? ' data-animation="' . esc_attr( vapester_get_animation_classes( $vapester_animation ) ) . '"' : '' );
?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom header's layout
	do_action( 'vapester_action_show_layout', $vapester_blog_id );
	?>
</article><?php
if ( ! empty( $vapester_template_args['slider'] ) || $vapester_columns > 1 || ! vapester_is_off( $vapester_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
