<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_template_args = get_query_var( 'vapester_template_args' );
if ( is_array( $vapester_template_args ) ) {
	$vapester_columns    = empty( $vapester_template_args['columns'] ) ? 2 : max( 1, $vapester_template_args['columns'] );
	$vapester_blog_style = array( $vapester_template_args['type'], $vapester_columns );
	if ( ! empty( $vapester_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $vapester_columns > 1 ) {
		?>
		<div class="column-1_<?php echo esc_attr( $vapester_columns ); ?>">
		<?php
	}
}
$vapester_expanded    = ! vapester_sidebar_present() && vapester_is_on( vapester_get_theme_option( 'expand_content' ) );
$vapester_post_format = get_post_format();
$vapester_post_format = empty( $vapester_post_format ) ? 'standard' : str_replace( 'post-format-', '', $vapester_post_format );
$vapester_animation   = vapester_get_theme_option( 'blog_animation' );
$vapester_components = vapester_array_get_keys_by_value( vapester_get_theme_option( 'meta_parts' ) );
$vapester_counters   = vapester_array_get_keys_by_value( vapester_get_theme_option( 'counters' ) );
?>
<article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_' . esc_attr( $vapester_post_format ) ); ?>
	<?php echo ( ! vapester_is_off( $vapester_animation ) && empty( $vapester_template_args['slider'] ) ? ' data-animation="' . esc_attr( vapester_get_animation_classes( $vapester_animation ) ) . '"' : '' ); ?>
	>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$vapester_hover = ! empty( $vapester_template_args['hover'] ) && ! vapester_is_inherit( $vapester_template_args['hover'] )
						? $vapester_template_args['hover']
						: vapester_get_theme_option( 'image_hover' );
	vapester_show_post_featured(
		array(
			'singular'   => false,
			'no_links'   => ! empty( $vapester_template_args['no_links'] ),
			'hover'      => $vapester_hover,
			'thumb_size' => vapester_get_thumb_size( strpos( vapester_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : ( $vapester_expanded ? 'huge' : 'big' ) ),
		)
	);

	// Title and post meta
	if ( get_the_title() != '' && $vapester_post_format != 'quote' ) {
		?>
		<div class="post_header entry-header">
			<?php
			do_action( 'vapester_action_before_post_title' );

			// Post title
			if ( 'audio' != $vapester_post_format ) {
				if ( empty( $vapester_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
			}

			do_action( 'vapester_action_before_post_meta' );

			// Post meta
			if ( ! empty( $vapester_components ) && ! in_array( $vapester_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
				vapester_show_post_meta(
					apply_filters(
						'vapester_filter_post_meta_args', array(
							'components' => $vapester_components,
							'counters'   => $vapester_counters,
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( empty( $vapester_template_args['hide_excerpt'] ) ) {

		?>
		<div class="post_content entry-content">
		<?php
		if ( vapester_get_theme_option( 'blog_content' ) == 'fullpost' ) {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				the_content( '' );
				?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'vapester' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'vapester' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
		} else {
			// Post content area
			?>
				<div class="post_content_inner">
				<?php
				if ( has_excerpt() ) {
						the_excerpt();
				} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
						the_content( '' );
				} elseif ( in_array( $vapester_post_format, array( 'link', 'aside', 'status' ) ) ) {
						the_content();
				} elseif ( 'quote' == $vapester_post_format ) {
					$quote = vapester_get_tag( get_the_content(), '<blockquote>', '</blockquote>' );
					if ( ! empty( $quote ) ) {?>
		
							<?php vapester_show_layout( wpautop( $quote ) )?>
				
						<?php if ( ! empty( $vapester_components ) && ! in_array( $vapester_hover, array( 'border', 'pull', 'slide', 'fade' ) ) ) {
							vapester_show_post_meta(
								apply_filters(
									'vapester_filter_post_meta_args', array(
										'components' => $vapester_components,
										'counters'   => $vapester_counters,
										'seo'        => false,
									), 'excerpt', 1
								)
							);
						}
					} else {
						the_excerpt();
					}
				} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' && $vapester_post_format != 'audio' ) {
					the_excerpt();
				}
				?>
				</div>
				<?php
				// More button
				if ( empty( $vapester_template_args['no_links'] ) && ! in_array( $vapester_post_format, array( 'link', 'aside', 'status',  'audio' ) ) ) {
					?>
					<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'Read more', 'vapester' ); ?></a></p>
					<?php
				}
		}
		?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
	</article>
<?php

if ( is_array( $vapester_template_args ) ) {
	if ( ! empty( $vapester_template_args['slider'] ) || $vapester_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
