<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_template_args = get_query_var( 'vapester_template_args' );
if ( is_array( $vapester_template_args ) ) {
	$vapester_columns    = empty( $vapester_template_args['columns'] ) ? 2 : max( 1, $vapester_template_args['columns'] );
	$vapester_blog_style = array( $vapester_template_args['type'], $vapester_columns );
} else {
	$vapester_blog_style = explode( '_', vapester_get_theme_option( 'blog_style' ) );
	$vapester_columns    = empty( $vapester_blog_style[1] ) ? 2 : max( 1, $vapester_blog_style[1] );
}
$vapester_post_format = get_post_format();
$vapester_post_format = empty( $vapester_post_format ) ? 'standard' : str_replace( 'post-format-', '', $vapester_post_format );
$vapester_animation   = vapester_get_theme_option( 'blog_animation' );
$vapester_image       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item'
		. ' post_layout_portfolio'
		. ' post_layout_gallery'
		. ' post_layout_gallery_' . esc_attr( $vapester_columns )
		. ' post_format_' . esc_attr( $vapester_post_format )
		. ( ! empty( $vapester_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
	);
	echo ( ! vapester_is_off( $vapester_animation ) && empty( $vapester_template_args['slider'] ) ? ' data-animation="' . esc_attr( vapester_get_animation_classes( $vapester_animation ) ) . '"' : '' );
	?>
	data-size="
		<?php
		if ( ! empty( $vapester_image[1] ) && ! empty( $vapester_image[2] ) ) {
			echo intval( $vapester_image[1] ) . 'x' . intval( $vapester_image[2] );}
		?>
	"
	data-src="
		<?php
		if ( ! empty( $vapester_image[0] ) ) {
			echo esc_url( $vapester_image[0] );}
		?>
	"
>
<?php

	// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	// Featured image
	$vapester_image_hover = 'icon';
if ( in_array( $vapester_image_hover, array( 'icons', 'zoom' ) ) ) {
	$vapester_image_hover = 'dots';
}
$vapester_components = vapester_array_get_keys_by_value( vapester_get_theme_option( 'meta_parts' ) );
$vapester_counters   = vapester_array_get_keys_by_value( vapester_get_theme_option( 'counters' ) );
vapester_show_post_featured(
	array(
		'hover'         => $vapester_image_hover,
		'singular'      => false,
		'no_links'      => ! empty( $vapester_template_args['no_links'] ),
		'thumb_size'    => vapester_get_thumb_size( strpos( vapester_get_theme_option( 'body_style' ), 'full' ) !== false || $vapester_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only'    => true,
		'show_no_image' => true,
		'post_info'     => '<div class="post_details">'
						. '<h2 class="post_title">'
							. ( empty( $vapester_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '">' . esc_html( get_the_title() ) . '</a>'
								: esc_html( get_the_title() )
								)
						. '</h2>'
						. '<div class="post_description">'
							. ( ! empty( $vapester_components )
								? vapester_show_post_meta(
									apply_filters(
										'vapester_filter_post_meta_args', array(
											'components' => $vapester_components,
											'counters' => $vapester_counters,
											'seo'      => false,
											'echo'     => false,
										), $vapester_blog_style[0], $vapester_columns
									)
								)
								: ''
								)
							. ( empty( $vapester_template_args['hide_excerpt'] )
								? '<div class="post_description_content">' . get_the_excerpt() . '</div>'
								: ''
								)
							. ( empty( $vapester_template_args['no_links'] )
								? '<a href="' . esc_url( get_permalink() ) . '" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__( 'Learn more', 'vapester' ) . '</span></a>'
								: ''
								)
						. '</div>'
					. '</div>',
	)
);
?>
</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!
