<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_template_args = get_query_var( 'vapester_template_args' );
if ( is_array( $vapester_template_args ) ) {
	$vapester_columns    = empty( $vapester_template_args['columns'] ) ? 2 : max( 1, $vapester_template_args['columns'] );
	$vapester_blog_style = array( $vapester_template_args['type'], $vapester_columns );
} else {
	$vapester_blog_style = explode( '_', vapester_get_theme_option( 'blog_style' ) );
	$vapester_columns    = empty( $vapester_blog_style[1] ) ? 2 : max( 1, $vapester_blog_style[1] );
}
$vapester_post_format = get_post_format();
$vapester_post_format = empty( $vapester_post_format ) ? 'standard' : str_replace( 'post-format-', '', $vapester_post_format );
$vapester_animation   = vapester_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item'
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $vapester_columns )
		. ' post_format_' . esc_attr( $vapester_post_format )
		. ( is_sticky() && ! is_paged() ? ' sticky' : '' )
		. ( ! empty( $vapester_template_args['slider'] ) ? ' slider-slide swiper-slide' : '' )
	);
	echo ( ! vapester_is_off( $vapester_animation ) && empty( $vapester_template_args['slider'] ) ? ' data-animation="' . esc_attr( vapester_get_animation_classes( $vapester_animation ) ) . '"' : '' );
	?>
>
<?php

// Sticky label
if ( is_sticky() && ! is_paged() ) {
	?>
		<span class="post_label label_sticky"></span>
		<?php
}

	$vapester_image_hover = ! empty( $vapester_template_args['hover'] ) && ! vapester_is_inherit( $vapester_template_args['hover'] )
								? $vapester_template_args['hover']
								: vapester_get_theme_option( 'image_hover' );
	// Featured image
	vapester_show_post_featured(
		array(
			'singular'      => false,
			'hover'         => $vapester_image_hover,
			'no_links'      => ! empty( $vapester_template_args['no_links'] ),
			'thumb_size'    => vapester_get_thumb_size(
				strpos( vapester_get_theme_option( 'body_style' ), 'full' ) !== false || $vapester_columns < 3
								? 'masonry-big'
				: 'masonry'
			),
			'show_no_image' => true,
			'class'         => 'dots' == $vapester_image_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $vapester_image_hover ? '<div class="post_info">' . esc_html( get_the_title() ) . '</div>' : '',
		)
	);
	?>
</article><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!