<div class="front_page_section front_page_section_team<?php
	$vapester_scheme = vapester_get_theme_option( 'front_page_team_scheme' );
	if ( ! vapester_is_inherit( $vapester_scheme ) ) {
		echo ' scheme_' . esc_attr( $vapester_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( vapester_get_theme_option( 'front_page_team_paddings' ) );
?>"
		<?php
		$vapester_css      = '';
		$vapester_bg_image = vapester_get_theme_option( 'front_page_team_bg_image' );
		if ( ! empty( $vapester_bg_image ) ) {
			$vapester_css .= 'background-image: url(' . esc_url( vapester_get_attachment_url( $vapester_bg_image ) ) . ');';
		}
		if ( ! empty( $vapester_css ) ) {
			echo ' style="' . esc_attr( $vapester_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$vapester_anchor_icon = vapester_get_theme_option( 'front_page_team_anchor_icon' );
	$vapester_anchor_text = vapester_get_theme_option( 'front_page_team_anchor_text' );
if ( ( ! empty( $vapester_anchor_icon ) || ! empty( $vapester_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_team"'
									. ( ! empty( $vapester_anchor_icon ) ? ' icon="' . esc_attr( $vapester_anchor_icon ) . '"' : '' )
									. ( ! empty( $vapester_anchor_text ) ? ' title="' . esc_attr( $vapester_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_team_inner
	<?php
	if ( vapester_get_theme_option( 'front_page_team_fullheight' ) ) {
		echo ' vapester-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$vapester_css      = '';
			$vapester_bg_mask  = vapester_get_theme_option( 'front_page_team_bg_mask' );
			$vapester_bg_color_type = vapester_get_theme_option( 'front_page_team_bg_color_type' );
			if ( 'custom' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_theme_option( 'front_page_team_bg_color' );
			} elseif ( 'scheme_bg_color' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_scheme_color( 'bg_color', $vapester_scheme );
			} else {
				$vapester_bg_color = '';
			}
			if ( ! empty( $vapester_bg_color ) && $vapester_bg_mask > 0 ) {
				$vapester_css .= 'background-color: ' . esc_attr(
					1 == $vapester_bg_mask ? $vapester_bg_color : vapester_hex2rgba( $vapester_bg_color, $vapester_bg_mask )
				) . ';';
			}
			if ( ! empty( $vapester_css ) ) {
				echo ' style="' . esc_attr( $vapester_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_team_content_wrap content_wrap">
			<?php
			// Caption
			$vapester_caption = vapester_get_theme_option( 'front_page_team_caption' );
			if ( ! empty( $vapester_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_team_caption front_page_block_<?php echo ! empty( $vapester_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( $vapester_caption ); ?></h2>
				<?php
			}

			// Description (text)
			$vapester_description = vapester_get_theme_option( 'front_page_team_description' );
			if ( ! empty( $vapester_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_team_description front_page_block_<?php echo ! empty( $vapester_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( wpautop( $vapester_description ) ); ?></div>
				<?php
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_team_output">
			<?php
			if ( is_active_sidebar( 'front_page_team_widgets' ) ) {
				dynamic_sidebar( 'front_page_team_widgets' );
			} elseif ( current_user_can( 'edit_theme_options' ) ) {
				if ( ! vapester_exists_trx_addons() ) {
					vapester_customizer_need_trx_addons_message();
				} else {
					vapester_customizer_need_widgets_message( 'front_page_team_caption', 'ThemeREX Addons - Team' );
				}
			}
			?>
			</div>
		</div>
	</div>
</div>
