<?php
$vapester_slider_sc = vapester_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $vapester_slider_sc ) && strpos( $vapester_slider_sc, '[' ) !== false && strpos( $vapester_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider">
	<?php
		// Add anchor
		$vapester_anchor_icon = vapester_get_theme_option( 'front_page_title_anchor_icon' );
		$vapester_anchor_text = vapester_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $vapester_anchor_icon ) || ! empty( $vapester_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $vapester_anchor_icon ) ? ' icon="' . esc_attr( $vapester_anchor_icon ) . '"' : '' )
									. ( ! empty( $vapester_anchor_text ) ? ' title="' . esc_attr( $vapester_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $vapester_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$vapester_scheme = vapester_get_theme_option( 'front_page_title_scheme' );
		if ( ! vapester_is_inherit( $vapester_scheme ) ) {
			echo ' scheme_' . esc_attr( $vapester_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( vapester_get_theme_option( 'front_page_title_paddings' ) );
		?>
		"
		<?php
		$vapester_css      = '';
		$vapester_bg_image = vapester_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $vapester_bg_image ) ) {
			$vapester_css .= 'background-image: url(' . esc_url( vapester_get_attachment_url( $vapester_bg_image ) ) . ');';
		}
		if ( ! empty( $vapester_css ) ) {
			echo ' style="' . esc_attr( $vapester_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$vapester_anchor_icon = vapester_get_theme_option( 'front_page_title_anchor_icon' );
		$vapester_anchor_text = vapester_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $vapester_anchor_icon ) || ! empty( $vapester_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $vapester_anchor_icon ) ? ' icon="' . esc_attr( $vapester_anchor_icon ) . '"' : '' )
									. ( ! empty( $vapester_anchor_text ) ? ' title="' . esc_attr( $vapester_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( vapester_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' vapester-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$vapester_css      = '';
			$vapester_bg_mask  = vapester_get_theme_option( 'front_page_title_bg_mask' );
			$vapester_bg_color_type = vapester_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_scheme_color( 'bg_color', $vapester_scheme );
			} else {
				$vapester_bg_color = '';
			}
			if ( ! empty( $vapester_bg_color ) && $vapester_bg_mask > 0 ) {
				$vapester_css .= 'background-color: ' . esc_attr(
					1 == $vapester_bg_mask ? $vapester_bg_color : vapester_hex2rgba( $vapester_bg_color, $vapester_bg_mask )
				) . ';';
			}
			if ( ! empty( $vapester_css ) ) {
				echo ' style="' . esc_attr( $vapester_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$vapester_caption = vapester_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $vapester_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $vapester_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( $vapester_caption ); ?></h1>
					<?php
				}

				// Description (text)
				$vapester_description = vapester_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $vapester_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $vapester_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses_post( wpautop( $vapester_description ) ); ?></div>
					<?php
				}

				// Buttons
				if ( vapester_get_theme_option( 'front_page_title_button1_link' ) != '' || vapester_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						vapester_show_layout( vapester_customizer_partial_refresh_front_page_title_button1_link() );
						vapester_show_layout( vapester_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
