<div class="front_page_section front_page_section_woocommerce<?php
	$vapester_scheme = vapester_get_theme_option( 'front_page_woocommerce_scheme' );
	if ( ! vapester_is_inherit( $vapester_scheme ) ) {
		echo ' scheme_' . esc_attr( $vapester_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( vapester_get_theme_option( 'front_page_woocommerce_paddings' ) );
?>"
		<?php
		$vapester_css      = '';
		$vapester_bg_image = vapester_get_theme_option( 'front_page_woocommerce_bg_image' );
		if ( ! empty( $vapester_bg_image ) ) {
			$vapester_css .= 'background-image: url(' . esc_url( vapester_get_attachment_url( $vapester_bg_image ) ) . ');';
		}
		if ( ! empty( $vapester_css ) ) {
			echo ' style="' . esc_attr( $vapester_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$vapester_anchor_icon = vapester_get_theme_option( 'front_page_woocommerce_anchor_icon' );
	$vapester_anchor_text = vapester_get_theme_option( 'front_page_woocommerce_anchor_text' );
if ( ( ! empty( $vapester_anchor_icon ) || ! empty( $vapester_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_woocommerce"'
									. ( ! empty( $vapester_anchor_icon ) ? ' icon="' . esc_attr( $vapester_anchor_icon ) . '"' : '' )
									. ( ! empty( $vapester_anchor_text ) ? ' title="' . esc_attr( $vapester_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_woocommerce_inner
	<?php
	if ( vapester_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
		echo ' vapester-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$vapester_css      = '';
			$vapester_bg_mask  = vapester_get_theme_option( 'front_page_woocommerce_bg_mask' );
			$vapester_bg_color_type = vapester_get_theme_option( 'front_page_woocommerce_bg_color_type' );
			if ( 'custom' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_theme_option( 'front_page_woocommerce_bg_color' );
			} elseif ( 'scheme_bg_color' == $vapester_bg_color_type ) {
				$vapester_bg_color = vapester_get_scheme_color( 'bg_color', $vapester_scheme );
			} else {
				$vapester_bg_color = '';
			}
			if ( ! empty( $vapester_bg_color ) && $vapester_bg_mask > 0 ) {
				$vapester_css .= 'background-color: ' . esc_attr(
					1 == $vapester_bg_mask ? $vapester_bg_color : vapester_hex2rgba( $vapester_bg_color, $vapester_bg_mask )
				) . ';';
			}
			if ( ! empty( $vapester_css ) ) {
				echo ' style="' . esc_attr( $vapester_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
			<?php
			// Content wrap with title and description
			$vapester_caption     = vapester_get_theme_option( 'front_page_woocommerce_caption' );
			$vapester_description = vapester_get_theme_option( 'front_page_woocommerce_description' );
			if ( ! empty( $vapester_caption ) || ! empty( $vapester_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $vapester_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $vapester_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses_post( $vapester_caption );
					?>
					</h2>
					<?php
				}

				// Description (text)
				if ( ! empty( $vapester_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $vapester_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses_post( wpautop( $vapester_description ) );
					?>
					</div>
					<?php
				}
			}

			// Content (widgets)
			?>
			<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
			<?php
				$vapester_woocommerce_sc = vapester_get_theme_option( 'front_page_woocommerce_products' );
			if ( 'products' == $vapester_woocommerce_sc ) {
				$vapester_woocommerce_sc_ids      = vapester_get_theme_option( 'front_page_woocommerce_products_per_page' );
				$vapester_woocommerce_sc_per_page = count( explode( ',', $vapester_woocommerce_sc_ids ) );
			} else {
				$vapester_woocommerce_sc_per_page = max( 1, (int) vapester_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
			}
				$vapester_woocommerce_sc_columns = max( 1, min( $vapester_woocommerce_sc_per_page, (int) vapester_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
				echo do_shortcode(
					"[{$vapester_woocommerce_sc}"
									. ( 'products' == $vapester_woocommerce_sc
											? ' ids="' . esc_attr( $vapester_woocommerce_sc_ids ) . '"'
											: '' )
									. ( 'product_category' == $vapester_woocommerce_sc
											? ' category="' . esc_attr( vapester_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
											: '' )
									. ( 'best_selling_products' != $vapester_woocommerce_sc
											? ' orderby="' . esc_attr( vapester_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
												. ' order="' . esc_attr( vapester_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
											: '' )
									. ' per_page="' . esc_attr( $vapester_woocommerce_sc_per_page ) . '"'
									. ' columns="' . esc_attr( $vapester_woocommerce_sc_columns ) . '"'
					. ']'
				);
				?>
			</div>
		</div>
	</div>
</div>
