<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'vapester_storage_get' ) ) {
	function vapester_storage_get( $var_name, $default = '' ) {
		global $VAPESTER_STORAGE;
		return isset( $VAPESTER_STORAGE[ $var_name ] ) ? $VAPESTER_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'vapester_storage_set' ) ) {
	function vapester_storage_set( $var_name, $value ) {
		global $VAPESTER_STORAGE;
		$VAPESTER_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'vapester_storage_empty' ) ) {
	function vapester_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $VAPESTER_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $VAPESTER_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $VAPESTER_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $VAPESTER_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'vapester_storage_isset' ) ) {
	function vapester_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $VAPESTER_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $VAPESTER_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $VAPESTER_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $VAPESTER_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'vapester_storage_inc' ) ) {
	function vapester_storage_inc( $var_name, $value = 1 ) {
		global $VAPESTER_STORAGE;
		if ( empty( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = 0;
		}
		$VAPESTER_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'vapester_storage_concat' ) ) {
	function vapester_storage_concat( $var_name, $value ) {
		global $VAPESTER_STORAGE;
		if ( empty( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = '';
		}
		$VAPESTER_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'vapester_storage_get_array' ) ) {
	function vapester_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $VAPESTER_STORAGE;
		if ( empty( $key2 ) ) {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $VAPESTER_STORAGE[ $var_name ][ $key ] ) ? $VAPESTER_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && ! empty( $key ) && isset( $VAPESTER_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $VAPESTER_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}
}

// Set array element
if ( ! function_exists( 'vapester_storage_set_array' ) ) {
	function vapester_storage_set_array( $var_name, $key, $value ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$VAPESTER_STORAGE[ $var_name ][] = $value;
		} else {
			$VAPESTER_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'vapester_storage_set_array2' ) ) {
	function vapester_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ][ $key ] ) ) {
			$VAPESTER_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$VAPESTER_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$VAPESTER_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'vapester_storage_merge_array' ) ) {
	function vapester_storage_merge_array( $var_name, $key, $value ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$VAPESTER_STORAGE[ $var_name ] = array_merge( $VAPESTER_STORAGE[ $var_name ], $value );
		} else {
			$VAPESTER_STORAGE[ $var_name ][ $key ] = array_merge( $VAPESTER_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'vapester_storage_set_array_after' ) ) {
	function vapester_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			vapester_array_insert_after( $VAPESTER_STORAGE[ $var_name ], $after, $key );
		} else {
			vapester_array_insert_after( $VAPESTER_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'vapester_storage_set_array_before' ) ) {
	function vapester_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			vapester_array_insert_before( $VAPESTER_STORAGE[ $var_name ], $before, $key );
		} else {
			vapester_array_insert_before( $VAPESTER_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'vapester_storage_push_array' ) ) {
	function vapester_storage_push_array( $var_name, $key, $value ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $VAPESTER_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $VAPESTER_STORAGE[ $var_name ][ $key ] ) ) {
				$VAPESTER_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $VAPESTER_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'vapester_storage_pop_array' ) ) {
	function vapester_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $VAPESTER_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $VAPESTER_STORAGE[ $var_name ] ) && is_array( $VAPESTER_STORAGE[ $var_name ] ) && count( $VAPESTER_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $VAPESTER_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $VAPESTER_STORAGE[ $var_name ][ $key ] ) && is_array( $VAPESTER_STORAGE[ $var_name ][ $key ] ) && count( $VAPESTER_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $VAPESTER_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'vapester_storage_inc_array' ) ) {
	function vapester_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( empty( $VAPESTER_STORAGE[ $var_name ][ $key ] ) ) {
			$VAPESTER_STORAGE[ $var_name ][ $key ] = 0;
		}
		$VAPESTER_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'vapester_storage_concat_array' ) ) {
	function vapester_storage_concat_array( $var_name, $key, $value ) {
		global $VAPESTER_STORAGE;
		if ( ! isset( $VAPESTER_STORAGE[ $var_name ] ) ) {
			$VAPESTER_STORAGE[ $var_name ] = array();
		}
		if ( empty( $VAPESTER_STORAGE[ $var_name ][ $key ] ) ) {
			$VAPESTER_STORAGE[ $var_name ][ $key ] = '';
		}
		$VAPESTER_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'vapester_storage_call_obj_method' ) ) {
	function vapester_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $VAPESTER_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $VAPESTER_STORAGE[ $var_name ] ) ? $VAPESTER_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $VAPESTER_STORAGE[ $var_name ] ) ? $VAPESTER_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'vapester_storage_get_obj_property' ) ) {
	function vapester_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $VAPESTER_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $VAPESTER_STORAGE[ $var_name ]->$prop ) ? $VAPESTER_STORAGE[ $var_name ]->$prop : $default;
	}
}
