<?php
/**
 * The template for homepage posts with "Classic" style
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

vapester_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	vapester_blog_archive_start();

	$vapester_classes    = 'posts_container '
						. ( substr( vapester_get_theme_option( 'blog_style' ), 0, 7 ) == 'classic'
							? 'columns_wrap columns_padding_bottom'
							: 'masonry_wrap'
							);
	$vapester_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$vapester_sticky_out = vapester_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $vapester_stickies ) && count( $vapester_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $vapester_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $vapester_sticky_out ) {
		if ( vapester_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( vapester_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}

		?>
		<div class="<?php echo esc_attr( $vapester_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $vapester_sticky_out && ! is_sticky() ) {
			$vapester_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $vapester_classes ); ?>">
			<?php
		}
		$vapester_part = $vapester_sticky_out && is_sticky() ? 'sticky' : 'classic';
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', $vapester_part ), $vapester_part );
	}

	?>
	</div>
	<?php

	vapester_show_pagination();

	vapester_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
