<?php
/**
 * The template for homepage posts with custom style
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.50
 */

vapester_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	$vapester_blog_style = vapester_get_theme_option( 'blog_style' );
	$vapester_parts      = explode( '_', $vapester_blog_style );
	$vapester_columns    = ! empty( $vapester_parts[1] ) ? max( 1, min( 6, (int) $vapester_parts[1] ) ) : 1;
	$vapester_blog_id    = vapester_get_custom_blog_id( $vapester_blog_style );
	$vapester_blog_meta  = vapester_get_custom_layout_meta( $vapester_blog_id );
	if ( ! empty( $vapester_blog_meta['margin'] ) ) {
		vapester_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( vapester_prepare_css_value( $vapester_blog_meta['margin'] ) ) ) );
	}
	$vapester_custom_style = ! empty( $vapester_blog_meta['scripts_required'] ) ? $vapester_blog_meta['scripts_required'] : 'none';

	vapester_blog_archive_start();

	$vapester_classes    = 'posts_container blog_custom_wrap' 
							. ( ! vapester_is_off( $vapester_custom_style )
								? sprintf( ' %s_wrap', $vapester_custom_style )
								: ( $vapester_columns > 1 
									? ' columns_wrap columns_padding_bottom' 
									: ''
									)
								);
	$vapester_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$vapester_sticky_out = vapester_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $vapester_stickies ) && count( $vapester_stickies ) > 0 && get_query_var( 'paged' ) < 1;
	if ( $vapester_sticky_out ) {
		?>
		<div class="sticky_wrap columns_wrap">
		<?php
	}
	if ( ! $vapester_sticky_out ) {
		if ( vapester_get_theme_option( 'first_post_large' ) && ! is_paged() && ! in_array( vapester_get_theme_option( 'body_style' ), array( 'fullwide', 'fullscreen' ) ) ) {
			the_post();
			get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'excerpt' ), 'excerpt' );
		}
		?>
		<div class="<?php echo esc_attr( $vapester_classes ); ?>">
		<?php
	}
	while ( have_posts() ) {
		the_post();
		if ( $vapester_sticky_out && ! is_sticky() ) {
			$vapester_sticky_out = false;
			?>
			</div><div class="<?php echo esc_attr( $vapester_classes ); ?>">
			<?php
		}
		$vapester_part = $vapester_sticky_out && is_sticky() ? 'sticky' : 'custom';
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', $vapester_part ), $vapester_part );
	}
	?>
	</div>
	<?php

	vapester_show_pagination();

	vapester_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
