<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

vapester_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	vapester_blog_archive_start();

	?><div class="posts_container">
		<?php

		$vapester_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
		$vapester_sticky_out = vapester_get_theme_option( 'sticky_style' ) == 'columns'
								&& is_array( $vapester_stickies ) && count( $vapester_stickies ) > 0 && get_query_var( 'paged' ) < 1;
		if ( $vapester_sticky_out ) {
			?>
			<div class="sticky_wrap columns_wrap">
			<?php
		}
		while ( have_posts() ) {
			the_post();
			if ( $vapester_sticky_out && ! is_sticky() ) {
				$vapester_sticky_out = false;
				?>
				</div>
				<?php
			}
			$vapester_part = $vapester_sticky_out && is_sticky() ? 'sticky' : 'excerpt';
			get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', $vapester_part ), $vapester_part );
		}
		if ( $vapester_sticky_out ) {
			$vapester_sticky_out = false;
			?>
			</div>
			<?php
		}

		?>
	</div>
	<?php

	vapester_show_pagination();

	vapester_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
