<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

vapester_storage_set( 'blog_archive', true );

get_header();

if ( have_posts() ) {

	vapester_blog_archive_start();

	$vapester_stickies   = is_home() ? get_option( 'sticky_posts' ) : false;
	$vapester_sticky_out = vapester_get_theme_option( 'sticky_style' ) == 'columns'
							&& is_array( $vapester_stickies ) && count( $vapester_stickies ) > 0 && get_query_var( 'paged' ) < 1;

	// Show filters
	$vapester_cat          = vapester_get_theme_option( 'parent_cat' );
	$vapester_post_type    = vapester_get_theme_option( 'post_type' );
	$vapester_taxonomy     = vapester_get_post_type_taxonomy( $vapester_post_type );
	$vapester_show_filters = vapester_get_theme_option( 'show_filters' );
	$vapester_tabs         = array();
	if ( ! vapester_is_off( $vapester_show_filters ) ) {
		$vapester_args           = array(
			'type'         => $vapester_post_type,
			'child_of'     => $vapester_cat,
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 1,
			'hierarchical' => 0,
			'taxonomy'     => $vapester_taxonomy,
			'pad_counts'   => false,
		);
		$vapester_portfolio_list = get_terms( $vapester_args );
		if ( is_array( $vapester_portfolio_list ) && count( $vapester_portfolio_list ) > 0 ) {
			$vapester_tabs[ $vapester_cat ] = esc_html__( 'All', 'vapester' );
			foreach ( $vapester_portfolio_list as $vapester_term ) {
				if ( isset( $vapester_term->term_id ) ) {
					$vapester_tabs[ $vapester_term->term_id ] = $vapester_term->name;
				}
			}
		}
	}
	if ( count( $vapester_tabs ) > 0 ) {
		$vapester_portfolio_filters_ajax   = true;
		$vapester_portfolio_filters_active = $vapester_cat;
		$vapester_portfolio_filters_id     = 'portfolio_filters';
		?>
		<div class="portfolio_filters vapester_tabs vapester_tabs_ajax">
			<ul class="portfolio_titles vapester_tabs_titles">
				<?php
				foreach ( $vapester_tabs as $vapester_id => $vapester_title ) {
					?>
					<li><a href="<?php echo esc_url( vapester_get_hash_link( sprintf( '#%s_%s_content', $vapester_portfolio_filters_id, $vapester_id ) ) ); ?>" data-tab="<?php echo esc_attr( $vapester_id ); ?>"><?php echo esc_html( $vapester_title ); ?></a></li>
					<?php
				}
				?>
			</ul>
			<?php
			$vapester_ppp = vapester_get_theme_option( 'posts_per_page' );
			if ( vapester_is_inherit( $vapester_ppp ) ) {
				$vapester_ppp = '';
			}
			foreach ( $vapester_tabs as $vapester_id => $vapester_title ) {
				$vapester_portfolio_need_content = $vapester_id == $vapester_portfolio_filters_active || ! $vapester_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr( sprintf( '%s_%s_content', $vapester_portfolio_filters_id, $vapester_id ) ); ?>"
					class="portfolio_content vapester_tabs_content"
					data-blog-template="<?php echo esc_attr( vapester_storage_get( 'blog_template' ) ); ?>"
					data-blog-style="<?php echo esc_attr( vapester_get_theme_option( 'blog_style' ) ); ?>"
					data-posts-per-page="<?php echo esc_attr( $vapester_ppp ); ?>"
					data-post-type="<?php echo esc_attr( $vapester_post_type ); ?>"
					data-taxonomy="<?php echo esc_attr( $vapester_taxonomy ); ?>"
					data-cat="<?php echo esc_attr( $vapester_id ); ?>"
					data-parent-cat="<?php echo esc_attr( $vapester_cat ); ?>"
					data-need-content="<?php echo ( false === $vapester_portfolio_need_content ? 'true' : 'false' ); ?>"
				>
					<?php
					if ( $vapester_portfolio_need_content ) {
						vapester_show_portfolio_posts(
							array(
								'cat'        => $vapester_id,
								'parent_cat' => $vapester_cat,
								'taxonomy'   => $vapester_taxonomy,
								'post_type'  => $vapester_post_type,
								'page'       => 1,
								'sticky'     => $vapester_sticky_out,
							)
						);
					}
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		vapester_show_portfolio_posts(
			array(
				'cat'        => $vapester_cat,
				'parent_cat' => $vapester_cat,
				'taxonomy'   => $vapester_taxonomy,
				'post_type'  => $vapester_post_type,
				'page'       => 1,
				'sticky'     => $vapester_sticky_out,
			)
		);
	}

	vapester_blog_archive_end();

} else {

	if ( is_search() ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-search' ), 'none-search' );
	} else {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'content', 'none-archive' ), 'none-archive' );
	}
}

get_footer();
