<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'vapester_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'vapester_cf7_theme_setup9', 9 );
	function vapester_cf7_theme_setup9() {

		add_filter( 'vapester_filter_merge_scripts', 'vapester_cf7_merge_scripts' );
		add_filter( 'vapester_filter_merge_styles', 'vapester_cf7_merge_styles' );

		if ( vapester_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'vapester_cf7_frontend_scripts', 1100 );
		}

		if ( is_admin() ) {
			add_filter( 'vapester_filter_tgmpa_required_plugins', 'vapester_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'vapester_cf7_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('vapester_filter_tgmpa_required_plugins',	'vapester_cf7_tgmpa_required_plugins');
	function vapester_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( vapester_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => vapester_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'vapester_exists_cf7' ) ) {
	function vapester_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'vapester_cf7_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'vapester_cf7_frontend_scripts', 1100 );
	function vapester_cf7_frontend_scripts() {
		if ( vapester_exists_cf7() ) {
			if ( vapester_is_on( vapester_get_theme_option( 'debug_mode' ) ) ) {
				$vapester_url = vapester_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
				if ( '' != $vapester_url ) {
					wp_enqueue_script( 'vapester-cf7', $vapester_url, array( 'jquery' ), null, true );
				}
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'vapester_cf7_merge_scripts' ) ) {
	//Handler of the add_filter('vapester_filter_merge_scripts', 'vapester_cf7_merge_scripts');
	function vapester_cf7_merge_scripts( $list ) {
		if ( vapester_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'vapester_cf7_merge_styles' ) ) {
	//Handler of the add_filter('vapester_filter_merge_styles', 'vapester_cf7_merge_styles');
	function vapester_cf7_merge_styles( $list ) {
		if ( vapester_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

