<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'vapester_mailchimp_get_css' ) ) {
	add_filter( 'vapester_filter_get_css', 'vapester_mailchimp_get_css', 10, 2 );
	function vapester_mailchimp_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
form.mc4wp-form .mc4wp-form-fields input[type="email"] {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
.wp-widget-mc4wp_form_widget .widget_title {
	{$fonts['h1_font-family']}
}
CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars = $args['vars'];

			$css['vars'] .= <<<CSS

form.mc4wp-form .mc4wp-form-fields input[type="email"],
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

form.mc4wp-form .mc4wp-alert {
	background-color: {$colors['text_link']};
	border-color: {$colors['text_hover']};
	color: {$colors['inverse_text']};
}
form.mc4wp-form .mc4wp-alert a {
	color: {$colors['inverse_dark']} !important;	
}
form.mc4wp-form .mc4wp-alert a:hover {
	color: {$colors['extra_hover3']} !important;	
}
.wp-widget-mc4wp_form_widget .widget_title {
	color: {$colors['alter_dark']};
}
.wp-widget-mc4wp_form_widget .widget_title:before {
	background-color: {$colors['text_link']};
}
.wp-widget-mc4wp_form_widget form.mc4wp-form input[type="email"] {
	background-color: {$colors['alter_dark']};
	color: {$colors['text_dark']};
}
.wp-widget-mc4wp_form_widget form.mc4wp-form input[type="email"]:focus {
	background-color: {$colors['alter_link']};
}
.wp-widget-mc4wp_form_widget form.mc4wp-form input[type="email"]::placeholder {
    color: {$colors['text_dark']};
    opacity: 1;
}
.wp-widget-mc4wp_form_widget form.mc4wp-form input[type="email"]:-ms-input-placeholder {
    color: {$colors['text_dark']};
}
.wp-widget-mc4wp_form_widget form.mc4wp-form input[type="email"]::-ms-input-placeholder {
    color: {$colors['text_dark']};
}
CSS;
		}

		return $css;
	}
}

