<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'vapester_ubermenu_get_css' ) ) {
	add_filter( 'vapester_filter_get_css', 'vapester_ubermenu_get_css', 10, 2 );
	function vapester_ubermenu_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS
form.mc4wp-form .mc4wp-form-fields input[type="email"] {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
.wp-widget-mc4wp_form_widget .widget_title{
	{$fonts['h1_font-family']}
}
.ubermenu-responsive-toggle {
	{$fonts['h5_font-family']}
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS

	
.ubermenu .ubermenu-item .ubermenu-submenu-drop > ul {
	background-color: {$colors['alter_dark']};
}
.ubermenu .ubermenu-item .ubermenu-submenu-drop a {
	color: {$colors['text_dark']};
}
.ubermenu .ubermenu-item .ubermenu-submenu-drop a:hover {
	color: {$colors['text_link']};
}
.ubermenu .image_wrap:before {
	background-color: {$colors['alter_link_06']};
}
.ubermenu .ubermenu-active > a,
.top_panel .scheme_self .ubermenu .ubermenu-active > a {
	color: {$colors['text_link']};
}
.ubermenu.mobile-uber a:hover,
.ubermenu.mobile-uber .ubermenu-active > a {
	color: {$colors['text_link']};
}
.ubermenu-sub-indicators .ubermenu-has-submenu-drop > .ubermenu-target:after {
    border-bottom-color: {$colors['alter_dark']};
}
.ubermenu-responsive-toggle,
.scheme_self.elementor-element .ubermenu-responsive-toggle {
	color: {$colors['text_dark']};
}
.ubermenu-responsive-toggle:hover,
.scheme_self.elementor-element .ubermenu-responsive-toggle:hover {
	color: {$colors['text_link']};
}

.ubermenu-responsive-toggle-open:hover,
.scheme_self.elementor-element .ubermenu-responsive-toggle-open:hover {
	color: {$colors['text_link']};
}
.ubermenu-responsive-toggle-open:after {
	color: {$colors['text_dark']};
}
.ubermenu-responsive-toggle-open:hover:after {
	color: {$colors['text_link']};
}
.ubermenu-responsive-default.ubermenu-responsive.mobile-uber {
	background-color: {$colors['bg_color_095']}
}
CSS;
		}

		return $css;
	}
}

