<?php
/* Ubermenu support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'vapester_ubermenu_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'vapester_ubermenu_theme_setup9', 9 );
	function vapester_ubermenu_theme_setup9() {

		add_filter( 'vapester_filter_merge_styles', 'vapester_ubermenu_merge_styles' );
		add_filter( 'vapester_filter_merge_styles_responsive', 'vapester_ubermenu_merge_styles_responsive' );

		if ( vapester_exists_ubermenu() ) {
			add_action( 'customize_register', 'vapester_ubermenu_customizer_register_controls', 100 );
			if ( ! is_admin() ) {
				add_filter( 'vapester_filter_header_parts', 'vapester_ubermenu_header_parts', 10, 2 );
				add_filter( 'vapester_filter_menu_mobile_layout', 'vapester_ubermenu_menu_mobile_layout' );
				add_filter( 'body_class', 'vapester_ubermenu_add_body_classes' );
			}
		}
		
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'vapester_ubermenu_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('vapester_filter_tgmpa_required_plugins',	'vapester_ubermenu_tgmpa_required_plugins');
	function vapester_ubermenu_tgmpa_required_plugins( $list = array() ) {
		if ( vapester_storage_isset( 'required_plugins', 'ubermenu' ) && vapester_is_theme_activated() ) {
			$path = vapester_get_plugin_source_path( 'plugins/ubermenu/ubermenu.zip' );
			if ( ! empty( $path ) || vapester_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => vapester_storage_get_array( 'required_plugins', 'ubermenu' ),
					'slug'     => 'ubermenu',
					'source'   => ! empty( $path ) ? $path : 'upload://ubermenu.zip',
					'version'  => '3.3.1.1',
					'required' => false,
				);
			}
		}
		return $list;
	}
}


// Check if plugin installed and activated
if ( ! function_exists( 'vapester_exists_ubermenu' ) ) {
	function vapester_exists_ubermenu() {
		return class_exists( 'UberMenu' );
	}
}

// Merge custom styles
if ( ! function_exists( 'vapester_ubermenu_merge_styles' ) ) {
	//Handler of the add_filter('vapester_filter_merge_styles', 'vapester_ubermenu_merge_styles');
	function vapester_ubermenu_merge_styles( $list ) {
		if ( vapester_exists_ubermenu() ) {
			$list[] = 'plugins/ubermenu/_ubermenu.scss';
		}
		return $list;
	}
}

// Merge responsive styles
if ( ! function_exists( 'vapester_ubermenu_merge_styles_responsive' ) ) {
	//Handler of the add_filter('vapester_filter_merge_styles_responsive', 'vapester_ubermenu_merge_styles_responsive');
	function vapester_ubermenu_merge_styles_responsive( $list ) {
		if ( vapester_exists_ubermenu() ) {
			$list[] = 'plugins/ubermenu/_ubermenu-responsive.scss';
		}
		return $list;
	}
}

// Disable Logo and Search in the header if the UberMenu active in the 'menu_main' theme location
if ( ! function_exists( 'vapester_ubermenu_header_parts' ) ) {
	//Handler of the add_filter( 'vapester_filter_header_parts', 'vapester_ubermenu_header_parts', 10, 2 );
	function vapester_ubermenu_header_parts( $parts, $loc ) {
		if ( vapester_ubermenu_check_location( $loc ) ) {
			$parts['logo']   = false;
			$parts['search'] = false;
		}
		return $parts;
	}
}

// Return true if theme location assigned to UberMenu
if ( ! function_exists( 'vapester_ubermenu_check_location' ) ) {
	function vapester_ubermenu_check_location( $loc ) {
		$rez = false;
		if ( vapester_exists_ubermenu() ) {
			$theme_loc = ubermenu_op( 'auto_theme_location', 'main' );
			$rez       = ! empty( $theme_loc[ $loc ] );
		}
		return $rez;
	}
}

// Add plugin specific classes to the body
if ( ! function_exists( 'vapester_ubermenu_add_body_classes' ) ) {
	//Handler of the add_filter( 'body_class', 'vapester_ubermenu_add_body_classes' );
	function vapester_ubermenu_add_body_classes( $classes ) {
		if ( vapester_exists_ubermenu() ) {
			$auto_theme_locations = ubermenu_op( 'auto_theme_location', 'main' );
			if ( is_array( $auto_theme_locations ) ) {
				foreach ( $auto_theme_locations as $loc ) {
					$classes[] = 'ubermenu_' . esc_attr( $loc );
				}
			}
			$classes[] = 'ubermenu_responsive_' . esc_attr( ubermenu_op( 'responsive', 'main' ) );
		}
		return $classes;
	}
}

// Add plugin specific classes to the mobile menu layout
if ( ! function_exists( 'vapester_ubermenu_menu_mobile_layout' ) ) {
	//Handler of the add_filter( 'vapester_filter_menu_mobile_layout', 'vapester_ubermenu_menu_mobile_layout' );
	function vapester_ubermenu_menu_mobile_layout( $layout ) {
		if ( vapester_exists_ubermenu() ) {
			$layout = str_replace(
				array( 'class="ubermenu ', 'ubermenu-nav', 'ubermenu-item-has-children', 'ubermenu' ),
				array( 'class="menu_mobile_nav_area ', 'menu_mobile_nav', 'menu-item-has-children', 'menu_mobile' ),
				$layout
			);
		}
		return $layout;
	}
}

// Move UserMenu panel down in the Customizer
if ( ! function_exists( 'vapester_ubermenu_customizer_register_controls' ) ) {
	//Handler of the add_action( 'customize_register', 'vapester_ubermenu_customizer_register_controls', 100);
	function vapester_ubermenu_customizer_register_controls( $wp_customize ) {
		$sec = $wp_customize->get_panel( 'ubermenu_instance_main' );
		if ( is_object( $sec ) ) {
			$sec->priority = 1000;
		}
	}
}

// Add plugin-specific colors and fonts to the custom CSS
if ( vapester_exists_ubermenu() ) {
	require_once VAPESTER_THEME_DIR . 'plugins/ubermenu/ubermenu-styles.php'; }