<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'vapester_woocommerce_get_css' ) ) {
	add_filter( 'vapester_filter_get_css', 'vapester_woocommerce_get_css', 10, 2 );
	function vapester_woocommerce_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

.woocommerce .checkout table.shop_table .product-name .variation,
.woocommerce .shop_table.order_details td.product-name .variation {
	{$fonts['p_font-family']}
}

.woocommerce-checkout h3 {
	{$fonts['h6_font-family']}
	{$fonts['h6_font-size']}
	{$fonts['h6_font-weight']}
	{$fonts['h6_font-style']}
	{$fonts['h6_line-height']}
	{$fonts['h6_text-decoration']}
	{$fonts['h6_text-transform']}
	{$fonts['h6_letter-spacing']}
}

.woocommerce ul#shipping_method .amount,
.woocommerce-checkout-review-order-table .product-total,
.woocommerce-checkout-review-order-table .order-total .amount,
.woocommerce-checkout-review-order-table .cart-subtotal .amount,
.woocommerce .cart_totals .shop_table .cart-subtotal,
.woocommerce .cart_totals .shop_table .order-total,
.woocommerce .product-price,
.woocommerce .product-subtotal,
.woocommerce-grouped-product-list-item__price,
.sc_layouts_cart_widget a,
.woocommerce .sc_layouts_cart_widget .widget_shopping_cart .total,
.sc_layouts_cart_widget .woocommerce.widget_shopping_cart .total,
.woocommerce .sc_layouts_cart_widget .widget_shopping_cart .quantity,
.product_list_widget div.product p.price, 
.product_list_widget div.product span.price,
.product_list_widget span.amount,
.woocommerce div.product form.cart .variations label,
.woocommerce .products .product .woocommerce-loop-category__title,
.woocommerce .products .product .woocommerce-loop-product__title,
.woocommerce .products .product h3,
.woocommerce ul.products li.product .woocommerce-loop-category__title,
.woocommerce ul.products li.product .woocommerce-loop-product__title,
.woocommerce ul.products li.product h3,
.woocommerce .woocommerce-result-count,
.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
.woocommerce ul.products li.product .post_header, .woocommerce-page ul.products li.product .post_header,
.single-product div.product .woocommerce-tabs .wc-tabs li a,
.woocommerce .shop_table th,
.woocommerce span.onsale,
.woocommerce div.product p.price, .woocommerce div.product span.price,
.woocommerce div.product .summary .stock,
.woocommerce #reviews #comments ol.commentlist li .comment-text p.meta strong,
.woocommerce-page #reviews #comments ol.commentlist li .comment-text p.meta strong,
.woocommerce table.cart td.product-name a, .woocommerce-page table.cart td.product-name a, 
.woocommerce #content table.cart td.product-name a, .woocommerce-page #content table.cart td.product-name a,
.woocommerce .checkout table.shop_table .product-name,
.woocommerce .shop_table.order_details td.product-name,
.woocommerce .order_details li strong,
.woocommerce-MyAccount-navigation,
.woocommerce-MyAccount-content .woocommerce-Address-title a {
	{$fonts['h5_font-family']}
}
.widget .woocommerce-mini-cart__empty-message {
	{$fonts['p_font-family']}
}
.woocommerce #review_form #respond #reply-title,
.single-product .related h2 {
	{$fonts['h4_font-family']}
	{$fonts['h4_font-size']}
	{$fonts['h4_font-weight']}
	{$fonts['h4_font-style']}
	{$fonts['h4_line-height']}
	{$fonts['h4_text-decoration']}
	{$fonts['h4_text-transform']}
	{$fonts['h4_letter-spacing']}
}
.woocommerce div.product .woocommerce-tabs h2,
.woocommerce #content div.product .woocommerce-tabs h2,
.woocommerce-page div.product .woocommerce-tabs h2,
.woocommerce-page #content div.product .woocommerce-tabs h2 {
	{$fonts['h6_font-family']}
	{$fonts['h6_font-size']}
	{$fonts['h6_font-weight']}
	{$fonts['h6_font-style']}
	{$fonts['h6_line-height']}
	{$fonts['h6_text-decoration']}
	{$fonts['h6_text-transform']}
	{$fonts['h6_letter-spacing']}
}
.woocommerce ul.products li.product .button, .woocommerce div.product form.cart .button,
.woocommerce .woocommerce-message .button,
.woocommerce #review_form #respond p.form-submit input[type="submit"],
.woocommerce-page #review_form #respond p.form-submit input[type="submit"],
.woocommerce table.my_account_orders .order-actions .button,
.woocommerce .button, .woocommerce-page .button,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button
.woocommerce #respond input#submit,
.woocommerce input[type="button"], .woocommerce-page input[type="button"],
.woocommerce input[type="submit"], .woocommerce-page input[type="submit"] {
	{$fonts['button_font-family']}
	{$fonts['button_font-size']}
	{$fonts['button_font-weight']}
	{$fonts['button_font-style']}
	{$fonts['button_line-height']}
	{$fonts['button_text-decoration']}
	{$fonts['button_text-transform']}
	{$fonts['button_letter-spacing']}
}
.woocommerce table.cart td.actions .coupon .input-text,
.woocommerce #content table.cart td.actions .coupon .input-text,
.woocommerce-page table.cart td.actions .coupon .input-text,
.woocommerce-page #content table.cart td.actions .coupon .input-text {
	{$fonts['input_font-family']}
	{$fonts['input_font-size']}
	{$fonts['input_font-weight']}
	{$fonts['input_font-style']}
	{$fonts['input_line-height']}
	{$fonts['input_text-decoration']}
	{$fonts['input_text-transform']}
	{$fonts['input_letter-spacing']}
}
.woocommerce ul.products li.product .post_header .post_tags,
.woocommerce div.product form.cart .reset_variations,
.woocommerce #reviews #comments ol.commentlist li .comment-text p.meta time, .woocommerce-page #reviews #comments ol.commentlist li .comment-text p.meta time {
	{$fonts['info_font-family']}
}

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars         = $args['vars'];
			$css['vars'] .= <<<CSS

.woocommerce .button, .woocommerce-page .button,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button
.woocommerce #respond input#submit,
.woocommerce input[type="button"], .woocommerce-page input[type="button"],
.woocommerce input[type="submit"], .woocommerce-page input[type="submit"],
.woocommerce .woocommerce-message .button,
.woocommerce ul.products li.product .button,
.woocommerce div.product form.cart .button,
.woocommerce #review_form #respond p.form-submit input[type="submit"],
.woocommerce-page #review_form #respond p.form-submit input[type="submit"],
.woocommerce table.my_account_orders .order-actions .button,
.yith-woocompare-widget a.clear-all,
.single-product div.product .woocommerce-tabs .wc-tabs li a,
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container-single .chosen-single {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}
.woocommerce div.product form.cart div.quantity span.q_inc, .woocommerce-page div.product form.cart div.quantity span.q_inc,
.woocommerce .shop_table.cart div.quantity span.q_inc, .woocommerce-page .shop_table.cart div.quantity span.q_inc {
	-webkit-border-radius: 0 {$vars['rad']} 0 0;
	    -ms-border-radius: 0 {$vars['rad']} 0 0;
			border-radius: 0 {$vars['rad']} 0 0;
}
.woocommerce div.product form.cart div.quantity span.q_dec, .woocommerce-page div.product form.cart div.quantity span.q_dec,
.woocommerce .shop_table.cart div.quantity span.q_dec, .woocommerce-page .shop_table.cart div.quantity span.q_dec {
	-webkit-border-radius: 0 0 {$vars['rad']} 0;
	    -ms-border-radius: 0 0 {$vars['rad']} 0;
			border-radius: 0 0 {$vars['rad']} 0;
}
CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS


.woocommerce #respond input#submit.alt.disabled,
.woocommerce #respond input#submit.alt.disabled:hover,
.woocommerce #respond input#submit.alt:disabled,
.woocommerce #respond input#submit.alt:disabled:hover,
.woocommerce #respond input#submit.alt:disabled[disabled],
.woocommerce #respond input#submit.alt:disabled[disabled]:hover,
.woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover,
.woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover,
.woocommerce a.button.alt:disabled[disabled], .woocommerce a.button.alt:disabled[disabled]:hover,
.woocommerce button.button.alt.disabled,
.woocommerce button.button.alt.disabled:hover,
.woocommerce button.button.alt:disabled,
.woocommerce button.button.alt:disabled:hover,
.woocommerce button.button.alt:disabled[disabled],
.woocommerce button.button.alt:disabled[disabled]:hover,
.woocommerce input.button.alt.disabled,
.woocommerce input.button.alt.disabled:hover,
.woocommerce input.button.alt:disabled,
.woocommerce input.button.alt:disabled:hover,
.woocommerce input.button.alt:disabled[disabled],
.woocommerce input.button.alt:disabled[disabled]:hover {
	color: {$colors['text_dark']} !important;
}
.woocommerce-checkout-review-order .wpgdprc-checkbox label:before,
.woocommerce .checkout .col-2 h3#ship-to-different-address label:before,
.woocommerce-page .checkout .col-2 h3#ship-to-different-address label:before {
	color: {$colors['text_dark']};
	border-color: {$colors['input_bg_color']};
}
.woocommerce ul.products li.product .outofstock_label{
	background-color: {$colors['text_link']};
}
/* Page header */
.woocommerce .woocommerce-breadcrumb {
	color: {$colors['text']};
}
.woocommerce .woocommerce-breadcrumb a {
	color: {$colors['text_link']};
}
.woocommerce .woocommerce-breadcrumb a:hover {
	color: {$colors['text_hover']};
}
.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
	background-color: {$colors['text_link']};
}
/* List and Single product */
.woocommerce .woocommerce-ordering select {
	border-color: {$colors['bd_color']};
}
.woocommerce span.onsale {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}

.woocommerce ul.products li.product .post_featured {
	border-color: {$colors['bd_color']};
}
.woocommerce ul.products li.product .post_header a {
	color: {$colors['text_dark']};
}
.woocommerce ul.products li.product .post_header a:hover {
	color: {$colors['text_link']};
}
.woocommerce ul.products li.product .post_header .post_tags,
.woocommerce ul.products li.product .post_header .post_tags a {
	color: {$colors['alter_link']};
}
.woocommerce ul.products li.product .post_header .post_tags a:hover {
	color: {$colors['alter_hover']};
}
.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
.woocommerce ul.products li.product .price ins, .woocommerce-page ul.products li.product .price ins {
	color: {$colors['text_link']};
}
.woocommerce ul.products li.product .price del,
.woocommerce-page ul.products li.product .price del {
	color: {$colors['extra_light']};
}
.woocommerce ul.products li.product .price del:before,
.woocommerce-page ul.products li.product .price del:before {
	background-color: {$colors['extra_light']};
}
.woocommerce table.cart td.product-name,
.woocommerce table.cart td.product-name a {
	color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-notices-wrapper .woocommerce-message .button {
	color: {$colors['alter_link']}!important;
}
.woocommerce table.cart td.product-name:hover,
.woocommerce table.cart td.product-name a:hover {
	color: {$colors['alter_link']};
}
.woocommerce .cart_totals table th,
.woocommerce-page .cart_totals table th,
.woocommerce .cart_totals table td,
.woocommerce-page .cart_totals table td,
.woocommerce .cart_totals table.shop_table_responsive tr:nth-child(2n) td,
.woocommerce-page .cart_totals table.shop_table_responsive tr:nth-child(2n) td
.woocommerce .cart_totals table > tbody > tr:nth-child(2n+1) > td,
.woocommerce-page .cart_totals table > tbody > tr:nth-child(2n+1) > td {
	background-color: transparent;
}
.woocommerce .cart_totals table th,
.woocommerce-page .cart_totals table th,
.woocommerce-page .cart_totals .order-total td,
.woocommerce-page .cart_totals a,
.woocommerce-page .cart_totals strong {
	color: {$colors['text_dark']};
}
.woocommerce-page .cart_totals table.shop_table span.woocommerce-Price-amount {
	color: {$colors['text_dark']}!important;
}	
.woocommerce-page .cart_totals a:hover {
	color: {$colors['text_link']};
}
.woocommerce .cart_totals table td,
.woocommerce-page .cart_totals table td {
	color: {$colors['text']};
}
.woocommerce-page .cart_totals table .cart-subtotal td .amount,
.woocommerce-page .cart_totals table .cart-subtotal td .amount .woocommerce-Price-currencySymbol {
	color: {$colors['text_link']}!important;
}
.product_list_widget div.product p.price, 
.product_list_widget div.product span.price,
.product_list_widget span.amount, 
.woocommerce div.product p.price, 
.woocommerce div.product span.price,
.woocommerce span.amount, 
.woocommerce-page span.amount {
	color: {$colors['text_link']};
}
.woocommerce table.shop_table td span.amount {
	color: {$colors['text_dark']};
}
.woocommerce-error li,
.woocommerce-info li,
.woocommerce-message li {
	color: {$colors['text']};	
}
.woocommerce-error li strong,
.woocommerce-info li strong,
.woocommerce-message li strong {
	color: {$colors['alter_link']};
}
.woocommerce table.shop_table tfoot th,
.woocommerce-page table.shop_table tfoot th,
.woocommerce table.shop_table td span.amount,
.woocommerce table.shop_table .cart-subtotal .amount,
.woocommerce table.shop_table .cart-subtotal .woocommerce-Price-currencySymbol,
.woocommerce-page table.shop_table .cart-subtotal .woocommerce-Price-currencySymbol,
.woocommerce-page table.shop_table .cart-subtotal .amount,
.woocommerce table.shop_table .shipping td,
.woocommerce-page table.shop_table .shipping td
.woocommerce table.shop_table td span.amount {
	color: {$colors['text']};
}
.woocommerce-checkout h3 {
	color: {$colors['text_dark']};
}
.showcoupon,
.shipping-calculator-button {
	color: {$colors['alter_link']};
}
.showcoupon:hover,
.shipping-calculator-button:hover {
	color: {$colors['text_link']};
}
/*kupon**/
.woocommerce table.cart td.actions .coupon .input-text, .woocommerce #content table.cart td.actions .coupon .input-text, .woocommerce-page table.cart td.actions .coupon .input-text, .woocommerce-page #content table.cart td.actions .coupon .input-text {
	padding: .778em 1.3472em;
}
aside.woocommerce del,
.woocommerce del, .woocommerce del > span.amount, 
.woocommerce-page del, .woocommerce-page del > span.amount {
	color: {$colors['extra_light']} !important;
}
.woocommerce .price del:before {
	background-color: {$colors['extra_light']};
}
.woocommerce div.product form.cart div.quantity span, .woocommerce-page div.product form.cart div.quantity span,
.woocommerce .shop_table.cart div.quantity span, .woocommerce-page .shop_table.cart div.quantity span {
	color: {$colors['alter_dark']};
	background-color: {$colors['input_bg_color']};
}
.woocommerce div.product form.cart div.quantity span:hover, .woocommerce-page div.product form.cart div.quantity span:hover,
.woocommerce .shop_table.cart div.quantity span:hover, .woocommerce-page .shop_table.cart div.quantity span:hover {
	background-color: {$colors['text_link']};
}
.woocommerce div.product form.cart div.quantity input[type="number"], .woocommerce-page div.product form.cart div.quantity input[type="number"],
.woocommerce .shop_table.cart input[type="number"], .woocommerce-page .shop_table.cart div.quantity input[type="number"] {
	border-color: {$colors['text_link']};
}
.woocommerce div.product .product_meta span > a,
.woocommerce div.product .product_meta span > span {
	color: {$colors['text']};
}
.woocommerce div.product .product_meta a:hover {
	color: {$colors['text_link']};
}

.woocommerce div.product div.images .flex-viewport,
.woocommerce div.product div.images img {
	border-color: {$colors['bd_color']};
}
.woocommerce div.product div.images a:hover img {
	border-color: {$colors['text_link']};
}

.single-product div.product .trx-stretch-width .woocommerce-tabs,
.woocommerce div.product .woocommerce-tabs .panel, .woocommerce #content div.product .woocommerce-tabs .panel, .woocommerce-page div.product .woocommerce-tabs .panel, .woocommerce-page #content div.product .woocommerce-tabs .panel {
	border-color: {$colors['bd_color']};
}
.single-product div.product .woocommerce-tabs .wc-tabs li a {
	color: {$colors['extra_dark']};
	background-color: {$colors['extra_bg_color']};
}
.single-product div.product .woocommerce-tabs .wc-tabs li.active a {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
.single-product div.product .woocommerce-tabs .wc-tabs li:not(.active) a:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['extra_hover']};
}
.single-product div.product .woocommerce-tabs .panel {
	color: {$colors['text']};
}
.woocommerce table.shop_attributes tr:nth-child(2n+1) > * {
	background-color: {$colors['alter_bg_color_04']};
}
.woocommerce table.shop_attributes tr:nth-child(2n) > *,
.woocommerce table.shop_attributes tr.alt > * {
	background-color: {$colors['alter_bg_color_02']};
}
.woocommerce table.shop_attributes th {
	color: {$colors['text_dark']};
}
.button.sc_button_hover_style_hover.single_add_to_cart_button:hover {
	color: {$colors['alter_dark']}!important;
}

/* Related Products */
.single-product .related {
	border-color: {$colors['bd_color']};
}
.single-product ul.products li.product .post_data {
	color: {$colors['extra_text']};
}
.single-product ul.products li.product .post_data .price span.amount {
	color: {$colors['text_link']};
}
.single-product ul.products li.product .post_data .post_header .post_tags,
.single-product ul.products li.product .post_data .post_header .post_tags a,
.single-product ul.products li.product .post_data a {
	color: {$colors['text_dark']};
}
.single-product ul.products li.product .post_data .post_header .post_tags a:hover,
.single-product ul.products li.product .post_data a:hover {
	color: {$colors['text_link']};
}
.single-product ul.products li.product .post_data .button {
	color: {$colors['inverse_link']};
	background-color: {$colors['extra_link']};
}
.single-product ul.products li.product .post_data .button:hover {
	color: {$colors['inverse_hover']} !important;
	background-color: {$colors['extra_hover']};
}

/* Rating */
.woocommerce #review_form #respond .stars a:hover,
.star-rating:before,
.star-rating span:before {
	color: {$colors['alter_link']};
}
#review_form #respond p.form-submit input[type="submit"] {
	color: {$colors['inverse_link']};
	background-color: {$colors['text_link']};
}
#review_form #respond p.form-submit input[type="submit"]:hover,
#review_form #respond p.form-submit input[type="submit"]:focus {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}

/* Shop mode selector */
.vapester_shop_mode_buttons a {
	color: {$colors['text_link']};
}
.vapester_shop_mode_buttons a:hover {
	color: {$colors['alter_dark']};
	background-color: {$colors['text_link']};
}
.woocommerce .products .product .post_featured a,
.woocommerce ul.products li.product .post_featured a {
	border-color: {$colors['bd_color']};
}
.woocommerce .products .product .post_featured a:hover,
.woocommerce ul.products li.product .post_featured a:hover {
	border-color: {$colors['text_dark']};
}
.shop_mode_thumbs .vapester_shop_mode_buttons a.woocommerce_list:hover,
.shop_mode_list .vapester_shop_mode_buttons a.woocommerce_thumbs:hover,
.shop_mode_thumbs .vapester_shop_mode_buttons a.woocommerce_thumbs,
.shop_mode_list .vapester_shop_mode_buttons a.woocommerce_list {
	color: {$colors['alter_dark']};
	background-color: {$colors['input_bg_color']};
}
.shop_mode_list .vapester_shop_mode_buttons a.woocommerce_thumbs,
.shop_mode_thumbs .vapester_shop_mode_buttons a.woocommerce_list {
	color: {$colors['text_dark']};
	background-color: {$colors['bd_color']};
}
/* Messages */
.woocommerce .woocommerce-message,
.woocommerce .woocommerce-info {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_color']};
	border-top-color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-error {
	background-color: {$colors['alter_bg_color']};
	border-top-color: {$colors['alter_link']};
}
.woocommerce .woocommerce-message:before,
.woocommerce .woocommerce-info:before {
	color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-error:before {
	color: {$colors['alter_link']};
}


/* Cart */
.woocommerce table.shop_table td {
	border-color: {$colors['alter_bd_color']} !important;
}
.woocommerce table.shop_table th {
	border-color: {$colors['alter_bd_color_02']} !important;
}
.woocommerce table.shop_table tfoot th, 
.woocommerce table.shop_table tfoot .cart-subtotal .woocommerce-Price-currencySymbol, 
.woocommerce-page table.shop_table tfoot .shipping td, 
.woocommerce table.shop_table tfoot td span.amount,
.woocommerce table.shop_table tfoot .cart-subtotal .amount, 
.woocommerce-page table.shop_table tfoot th{
	color: {$colors['text_dark']} !important;
	border-color: transparent !important;
	background-color: transparent;
}
.woocommerce .quantity input.qty, .woocommerce #content .quantity input.qty, .woocommerce-page .quantity input.qty, .woocommerce-page #content .quantity input.qty {
	color: {$colors['input_dark']};
}
.woocommerce .cart-collaterals .cart_totals table select,
.woocommerce-page .cart-collaterals .cart_totals table select {
	color: {$colors['input_text']};
	background-color: {$colors['input_bg_color']};
}
.woocommerce .cart-collaterals .cart_totals table select:focus, .woocommerce-page .cart-collaterals .cart_totals table select:focus {
	color: {$colors['input_dark']};
	background-color: {$colors['input_bg_hover']};
}
.woocommerce .cart-collaterals .shipping_calculator .shipping-calculator-button:after,
.woocommerce-page .cart-collaterals .shipping_calculator .shipping-calculator-button:after {
	color: {$colors['text_dark']};
}
.woocommerce table.shop_table .cart-subtotal .amount, .woocommerce-page table.shop_table .cart-subtotal .amount,
.woocommerce table.shop_table .shipping td, .woocommerce-page table.shop_table .shipping td {
	color: {$colors['text_dark']};
}
.woocommerce table.cart td+td a, .woocommerce #content table.cart td+td a, .woocommerce-page table.cart td+td a, .woocommerce-page #content table.cart td+td a,
.woocommerce table.cart td+td span, .woocommerce #content table.cart td+td span, .woocommerce-page table.cart td+td span, .woocommerce-page #content table.cart td+td span {
	color: {$colors['text']};
}
.woocommerce table.cart td+td a:hover, .woocommerce #content table.cart td+td a:hover, .woocommerce-page table.cart td+td a:hover, .woocommerce-page #content table.cart td+td a:hover {
	color: {$colors['text_link']};
}
#add_payment_method table.cart td.actions .coupon .input-text, .woocommerce-cart table.cart td.actions .coupon .input-text, .woocommerce-checkout table.cart td.actions .coupon .input-text {
	border-color: {$colors['input_bd_color']};
}


/* Checkout */
#add_payment_method #payment ul.payment_methods, .woocommerce-cart #payment ul.payment_methods, .woocommerce-checkout #payment ul.payment_methods {
	border-color:{$colors['bd_color']};
}
#add_payment_method #payment div.payment_box, .woocommerce-cart #payment div.payment_box, .woocommerce-checkout #payment div.payment_box {
	color:{$colors['alter_link2']};
	background-color:{$colors['input_bg_hover']};
}
#add_payment_method #payment div.payment_box:before, .woocommerce-cart #payment div.payment_box:before, .woocommerce-checkout #payment div.payment_box:before {
	border-color: transparent transparent {$colors['input_bg_hover']};
}
.woocommerce .order_details li strong, .woocommerce-page .order_details li strong {
	color: {$colors['text_dark']};
}
.woocommerce .order_details.woocommerce-thankyou-order-details {
	color:{$colors['alter_text']};
	background-color:{$colors['alter_bg_color']};
}
.woocommerce .order_details.woocommerce-thankyou-order-details strong {
	color:{$colors['alter_dark']};
}
.woocommerce div.product form.cart .variations label {
	color: {$colors['text_dark']};
}
/* My Account */
.woocommerce-account .woocommerce-MyAccount-navigation,
.woocommerce-MyAccount-navigation ul li,
.woocommerce-MyAccount-navigation li+li {
	border-color: {$colors['bd_color']};
}
.woocommerce-MyAccount-navigation li.is-active a {
	color: {$colors['text_link']};
}
.woocommerce-MyAccount-content .woocommerce-orders-table a,
.woocommerce-MyAccount-content .my_account_orders .button {
	color: {$colors['inverse_hover']};
}
.woocommerce-MyAccount-content .woocommerce-orders-table a:hover,
.woocommerce-MyAccount-content .my_account_orders .button:hover {
	color: {$colors['inverse_link']};
}

/* Widgets */
.widget_product_search form:after {
	color: {$colors['input_light']};
}

.widget_shopping_cart .total {
	color: {$colors['text_dark']};
	border-color: {$colors['bd_color']};
}
.sidebar .woocommerce ul.product_list_widget li {
	color: {$colors['alter_text']};
}
.woocommerce ul.cart_list li dl,
.woocommerce-page ul.cart_list li dl,
.woocommerce ul.product_list_widget li dl,
.woocommerce-page ul.product_list_widget li dl {
	border-color: {$colors['bd_color']};
}
.widget_layered_nav ul li.chosen a {
	color: {$colors['text_dark']};
}
.widget_price_filter .price_slider_wrapper .ui-widget-content { 
	background: {$colors['text_light']};
}
.widget_price_filter .price_label span {
	color: {$colors['text_dark']};
}


/* WooCommerce Search widget */
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field input[type="text"],
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field .trx_addons_woocommerce_search_form_field_label {
	border-color: {$colors['text_link']};
	color: {$colors['text_link']};
}
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field input[type="text"]:focus,
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field .trx_addons_woocommerce_search_form_field_label:hover {
	border-color: {$colors['text_hover']};
	color: {$colors['text_hover']};
}
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field_list {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_color']};
	background-color: {$colors['alter_bg_color']};
}
.trx_addons_woocommerce_search_type_inline .trx_addons_woocommerce_search_form_field_list li:hover {
	color: {$colors['alter_dark']};
	background-color: {$colors['alter_bg_hover']};
}



/* Third-party plugins
---------------------------------------------- */
.yith_magnifier_zoom_wrap .yith_magnifier_zoom_magnifier {
	border-color: {$colors['bd_color']};
}

.yith-woocompare-widget a.clear-all {
	color: {$colors['inverse_link']};
	background-color: {$colors['alter_link']};
}
.yith-woocompare-widget a.clear-all:hover {
	color: {$colors['inverse_hover']};
	background-color: {$colors['alter_hover']};
}

.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container-single .chosen-single {
	color: {$colors['input_text']};
	background: {$colors['input_bg_color']};
}
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container-single .chosen-single:hover {
	color: {$colors['input_dark']};
	background: {$colors['input_bg_hover']};
}
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container .chosen-drop {
	color: {$colors['input_dark']};
	background: {$colors['input_bg_hover']};
	border-color: {$colors['input_bd_hover']};
}
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container .chosen-results li {
	color: {$colors['input_dark']};
}
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container .chosen-results li:hover,
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container .chosen-results li.highlighted,
.widget.WOOCS_SELECTOR .woocommerce-currency-switcher-form .chosen-container .chosen-results li.result-selected {
	color: {$colors['alter_link']} !important;
}

.woocommerce .woocommerce-result-count {
	color: {$colors['text_dark']};
}
.woocommerce .post_featured.hover_shop .icons a {
	background-color: {$colors['text_link']};
}
.woocommerce .post_featured.hover_shop .icons a:hover {
	color: {$colors['alter_dark']};
	background-color: {$colors['text_dark']};
	border-color: {$colors['text_dark']} !important;
}
.woocommerce a.remove {
	color: {$colors['alter_dark']} !important;
	background-color: {$colors['input_dark']} !important;
}
.sc_layouts_cart a.remove {
	color: {$colors['text_dark']} !important;
}
.woocommerce a.remove:hover {
	background-color: {$colors['text_link']} !important;
	color: {$colors['alter_dark']} !important;
}
.sc_layouts_cart a.remove:hover {
	color: {$colors['text_dark']} !important;
	background-color: {$colors['alter_link']} !important;
}
.sc_layouts_cart .quantity,
.sc_layouts_cart_widget span.amount {
	color: {$colors['text']};
}
.sidebar .woocommerce span.amount, 
.scheme_default .woocommerce-page span.amount {
	color: {$colors['alter_text']};
}
.sidebar .woocommerce .widget_shopping_cart .total strong,
.sidebar .woocommerce.widget_shopping_cart .total strong {
	color: {$colors['alter_dark']};
}
.sidebar .woocommerce.widget_shopping_cart .total .amount,
.sidebar .woocommerce .widget_shopping_cart .total .amount,
.sidebar .woocommerce-page.widget_shopping_cart .total .amount,
.sidebar .woocommerce-page .widget_shopping_cart .total .amount {
	color: {$colors['alter_link']};	
}
.woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content {
	background-color: {$colors['extra_bg_hover']};
}
.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
	background-color: {$colors['alter_link']};
}
.widget_price_filter .price_label,
.widget_price_filter .price_label span {
	color: {$colors['alter_dark']};
}
.woocommerce div.product form.cart div.quantity input[type="number"],
.woocommerce-page div.product form.cart div.quantity input[type="number"],
.woocommerce .shop_table.cart div.quantity input[type="number"],
.woocommerce-page .shop_table.cart div.quantity input[type="number"] {
	background-color: {$colors['input_bg_color']};
	color: {$colors['alter_dark']};
}
.product_list_widget {
	color: {$colors['text_link']};
}
.product_list_widget del,
.product_list_widget del .amount {
	color: {$colors['extra_light']};
}
.content .product_list_widget li:hover > a,
.woocommerce .products .product:hover .post_featured,
.woocommerce ul.products li.product:hover .post_featured {
	border-color: {$colors['extra_bd_color']};
}
.woocommerce table.shop_table_responsive tr:nth-child(2n) td, 
.woocommerce-page table.shop_table_responsive tr:nth-child(2n) td {
	background-color: {$colors['text_dark']};
}
.woocommerce #review_form .comment-form {
	background-color: {$colors['text_dark']};
}
.comments_i_agree_privacy_policy label a:hover{
	color: {$colors['text']};
}
/* Cart */
.sc_layouts_cart_items_short {
	background-color: {$colors['text_dark']};
	color: {$colors['bg_color']};
}
.sc_layouts_cart_widget {
	border-color: {$colors['input_dark']};
	background-color: {$colors['input_dark']};
	color: {$colors['text_dark']};
}
.sc_layouts_cart_widget .total
.sc_layouts_cart_widget a,
.sc_layouts_cart_widget strong {
	color: {$colors['text_dark']};
}
.sc_layouts_cart .total span.amount {
	color: {$colors['alter_hover']};
}
.sc_layouts_cart_widget:after {
	border-color: {$colors['input_dark']};
	background-color: {$colors['input_dark']};
}
.sc_layouts_cart_widget .sc_layouts_cart_widget_close {
	color: {$colors['text_light']};
}
.sc_layouts_cart_widget .sc_layouts_cart_widget_close:hover {
	color: {$colors['text_dark']};
}

.woocommerce #respond input#submit.disabled, .woocommerce #respond input#submit:disabled, 
.woocommerce #respond input#submit:disabled[disabled], .woocommerce a.button.disabled, 
.woocommerce a.button:disabled, .woocommerce a.button:disabled[disabled], 
.woocommerce button.button.disabled, .woocommerce button.button:disabled, 
.woocommerce button.button:disabled[disabled], .woocommerce input.button.disabled, 
.woocommerce input.button:disabled, .woocommerce input.button:disabled[disabled] {
	background-color: {$colors['bd_color']} !important;
	color: {$colors['text_dark']}!important;
}

CSS;
		}

		return $css;
	}
}

