<?php
// Add plugin-specific colors and fonts to the custom CSS
if ( ! function_exists( 'vapester_wp_live_chat_support_get_css' ) ) {
	add_filter( 'vapester_filter_get_css', 'vapester_wp_live_chat_support_get_css', 10, 2 );
	function vapester_wp_live_chat_support_get_css( $css, $args ) {

		if ( isset( $css['fonts'] ) && isset( $args['fonts'] ) ) {
			$fonts         = $args['fonts'];
			$css['fonts'] .= <<<CSS

CSS;
		}

		if ( isset( $css['vars'] ) && isset( $args['vars'] ) ) {
			$vars = $args['vars'];

			$css['vars'] .= <<<CSS

form.mc4wp-form .mc4wp-form-fields input[type="email"],
form.mc4wp-form .mc4wp-form-fields input[type="submit"] {
	-webkit-border-radius: {$vars['rad']};
	    -ms-border-radius: {$vars['rad']};
			border-radius: {$vars['rad']};
}

CSS;
		}

		if ( isset( $css['colors'] ) && isset( $args['colors'] ) ) {
			$colors         = $args['colors'];
			$css['colors'] .= <<<CSS
#wplc_user_message_div,
#wp-live-chat input,
#wp-live-chat textarea {
	background-color: {$colors['input_bg_color']}!important;
	color: {$colors['alter_dark']}!important;
}
.wplc-color-bg-1 {
	background: {$colors['text_link']}!important;
	color: {$colors['bg_color']}!important;
}
button.wplc-color-bg-1:hover,
button.wplc-color-bg-1.active {
	background: {$colors['text_dark']}!important;	
}
#wp-live-chat-1 #wplc_first_message strong {
	color: {$colors['alter_dark']};	
}
#wp-live-chat-4 {
	background-color: {$colors['text_dark']};
}
.wplc-color-border-1 {
	background-color: {$colors['alter_link']}!important;
	border-color: {$colors['alter_link']}!important;
	color: {$colors['text_dark']}!important;
}
.wplc-color-border-4 {
	background-color: {$colors['bd_color']}!important;
	border-color: {$colors['bd_color']}!important;
	color: {$colors['text']}!important;
}
.wplc-admin-message:before {
	border-color: transparent {$colors['bd_color']}!important;
}
.wplc-user-message:before {
	border-color: transparent {$colors['alter_link']}!important;
}
#wp-live-chat-header:hover,
#wp-live-chat-header.active {
	background-color: {$colors['text_dark']}!important;
}
.wplc-user-message.wplc-color-2 {
	color: {$colors['text_dark']}!important;
}
CSS;
		}

		return $css;
	}
}