<?php
/* WP Live Chat Support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'vapester_wp_live_chat_support_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'vapester_wp_live_chat_support_theme_setup9', 9 );
	function vapester_wp_live_chat_support_theme_setup9() {

		add_filter( 'vapester_filter_merge_styles', 'vapester_wp_live_chat_support_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'vapester_filter_tgmpa_required_plugins', 'vapester_wp_live_chat_support_tgmpa_required_plugins' );

		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'vapester_wp_live_chat_support_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('vapester_filter_tgmpa_required_plugins',	'vapester_wp_live_chat_support_tgmpa_required_plugins');
	function vapester_wp_live_chat_support_tgmpa_required_plugins( $list = array() ) {
		if ( vapester_storage_isset( 'required_plugins', 'wp-live-chat-support' ) ) {
			$list[] = array(
				'name'     => vapester_storage_get_array( 'required_plugins', 'wp-live-chat-support' ),
				'slug'     => 'wp-live-chat-support',
				'required' => false,
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'vapester_exists_wp_live_chat_support' ) ) {
	function vapester_exists_wp_live_chat_support() {
		return function_exists( 'wplc_init' );
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Merge custom styles
if ( ! function_exists( 'vapester_wp_live_chat_support_merge_styles' ) ) {
	//Handler of the add_filter( 'vapester_filter_merge_styles', 'vapester_wp_live_chat_support_merge_styles');
	function vapester_wp_live_chat_support_merge_styles( $list ) {
		if ( vapester_exists_wp_live_chat_support() ) {
			$list[] = 'plugins/wp-live-chat-support/_wp-live-chat-support.scss';
		}
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( vapester_exists_wp_live_chat_support() ) {
	require_once VAPESTER_THEME_DIR . 'plugins/wp-live-chat-support/wp-live-chat-support-styles.php'; }


// Export posts
if ( !function_exists( 'vapester_wp_live_chat_support_importer_export' ) ) {
    if (is_admin()) add_action( 'trx_addons_action_importer_export',    'vapester_wp_live_chat_support_importer_export', 10, 1 );
    function vapester_wp_live_chat_support_importer_export($importer) {
        if ( vapester_exists_wp_live_chat_support() && in_array('wp-live-chat-support', $importer->options['required_plugins']) ) {
            trx_addons_fpc($importer->export_file_dir('wp-live-chat-support.txt'), serialize( array(
					'wplc_chat_msgs'			=> $importer->export_dump('wplc_chat_msgs'),
					'wplc_chat_sessions'		=> $importer->export_dump('wplc_chat_sessions'),
					'wplc_offline_messages'		=> $importer->export_dump('wplc_offline_messages'),
					'wplc_webhooks'				=> $importer->export_dump('wplc_webhooks'),
                ) )
            );
        }
    }
}


// Display exported data in the fields
if ( !function_exists( 'vapester_wp_live_chat_support_importer_export_fields' ) ) {
    if (is_admin()) add_action( 'trx_addons_action_importer_export_fields',    'vapester_wp_live_chat_support_importer_export_fields', 10, 1 );
    function vapester_wp_live_chat_support_importer_export_fields($importer) {
        if ( vapester_exists_wp_live_chat_support() && in_array('wp-live-chat-support', $importer->options['required_plugins']) ) {
            $importer->show_exporter_fields(array(
                'slug'    => 'wp-live-chat-support',
                'title' => esc_html__('WP Live Chat Support', 'vapester')
                )
            );
        }
    }
}

// Check plugin in the required plugins
if ( !function_exists( 'vapester_wp_live_chat_support_importer_required_plugins' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_required_plugins', 'vapester_wp_live_chat_support_importer_required_plugins', 10, 2 );
    function vapester_wp_live_chat_support_importer_required_plugins($not_installed='', $list='') {
        if (strpos($list, 'wp-live-chat-support')!==false && !vapester_exists_wp_live_chat_support() )
            $not_installed .= '<br>' . esc_html__('WP Live Chat Support', 'vapester');
        return $not_installed;
    }
}


// Add checkbox to the one-click importer
if ( !function_exists( 'vapester_wp_live_chat_support_importer_show_params' ) ) {
    if (is_admin()) add_action( 'trx_addons_action_importer_params',    'vapester_wp_live_chat_support_importer_show_params', 10, 1 );
    function vapester_wp_live_chat_support_importer_show_params($importer) {
        if ( vapester_exists_wp_live_chat_support() && in_array('wp-live-chat-support', $importer->options['required_plugins']) ) {
            $importer->show_importer_params(array(
                'slug' => 'wp-live-chat-support',
                'title' => esc_html__('Import WP Live Chat Support', 'vapester'),
                'part' => 1
            ));
        }
    }
}


// Import posts
if ( !function_exists( 'vapester_wp_live_chat_support_importer_import' ) ) {
    if (is_admin()) add_action( 'trx_addons_action_importer_import',    'vapester_wp_live_chat_support_importer_import', 10, 2 );
    function vapester_wp_live_chat_support_importer_import($importer, $action) {
        if ( vapester_exists_wp_live_chat_support() && in_array('wp-live-chat-support', $importer->options['required_plugins']) ) {
            if ( $action == 'import_wp_live_chat_support' ) {
                $importer->response['start_from_id'] = 0;
                $importer->import_dump('wp-live-chat-support', esc_html__('WP Live Chat Support', 'vapester'));
            }
        }
    }
}

// Set plugin's specific importer options
if ( !function_exists( 'vapester_wp_live_chat_support_importer_set_options' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_options',    'vapester_wp_live_chat_support_importer_set_options' );
    function vapester_wp_live_chat_support_importer_set_options($options=array()) {
        if ( vapester_exists_wp_live_chat_support() && in_array('wp-live-chat-support', $options['required_plugins']) ) {

        	$options['additional_options'][]    = 'WPLC_SETTINGS';
			$options['additional_options'][]    = 'WPLC_ET_SETTINGS';
			$options['additional_options'][]    = 'wplc_stats';

            if (is_array($options['files']) && count($options['files']) > 0) {
                foreach ($options['files'] as $k => $v) {
                    $options['files'][$k]['file_with_wp_live_chat_support'] = str_replace('name.ext', 'wp-live-chat-support.txt', $v['file_with_']);
                }
            }
        }
        return $options;
    }
}