<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

if ( vapester_sidebar_present() ) {
	ob_start();
	$vapester_sidebar_name = vapester_get_theme_option( 'sidebar_widgets' );
	vapester_storage_set( 'current_sidebar', 'sidebar' );
	if ( is_active_sidebar( $vapester_sidebar_name ) ) {
		dynamic_sidebar( $vapester_sidebar_name );
	}
	$vapester_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $vapester_out ) ) {
		$vapester_sidebar_position = vapester_get_theme_option( 'sidebar_position' );
		?>
		<div class="sidebar widget_area
			<?php
			echo esc_attr( $vapester_sidebar_position );
			if ( ! vapester_is_inherit( vapester_get_theme_option( 'sidebar_scheme' ) ) ) {
				echo ' scheme_' . esc_attr( vapester_get_theme_option( 'sidebar_scheme' ) );
			}
			?>
		" role="complementary">
		<?php
			// Single posts banner before sidebar
			vapester_show_post_banner( 'sidebar' ); ?>
			<div class="sidebar_inner">
				<?php
				do_action( 'vapester_action_before_sidebar' );
				vapester_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $vapester_out ) );
				do_action( 'vapester_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<div class="clearfix"></div>
		<?php
	}
}
