<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.1
 */

$vapester_theme_obj = wp_get_theme();
?>
<div class="vapester_admin_notice vapester_welcome_notice update-nag">
	<?php
	// Theme image
	$vapester_theme_img = vapester_get_file_url( 'screenshot.jpg' );
	if ( '' != $vapester_theme_img ) {
		?>
		<div class="vapester_notice_image"><img src="<?php echo esc_url( $vapester_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'vapester' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="vapester_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'vapester' ),
				$vapester_theme_obj->name . ( VAPESTER_THEME_FREE ? ' ' . esc_html__( 'Free', 'vapester' ) : '' ),
				$vapester_theme_obj->version
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="vapester_notice_text">
		<p class="vapester_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $vapester_theme_obj->description ) );
			?>
		</p>
		<p class="vapester_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'vapester' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="vapester_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=vapester_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'vapester' );
			?>
		</a>
		<?php		
		// Dismiss this notice
		?>
		<a href="#" class="vapester_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="vapester_hide_notice_text"><?php esc_html_e( 'Dismiss', 'vapester' ); ?></span></a>
	</div>
</div>
