<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.1
 */

$vapester_theme_obj = wp_get_theme();

?>
<div class="vapester_admin_notice vapester_rate_notice update-nag">
	<?php
	// Theme image
	$vapester_theme_img = vapester_get_file_url( 'screenshot.jpg' );
	if ( '' != $vapester_theme_img ) {
		?>
		<div class="vapester_notice_image"><img src="<?php echo esc_url( $vapester_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'vapester' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="vapester_notice_title"><a href="<?php echo esc_url( vapester_storage_get( 'theme_download_url' ) ); ?>" target="_blank">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Rate our theme "%s", please', 'vapester' ),
				$vapester_theme_obj->name . ( VAPESTER_THEME_FREE ? ' ' . esc_html__( 'Free', 'vapester' ) : '' )
			)
		);
		?>
	</a></h3>
	<?php

	// Description
	?>
	<div class="vapester_notice_text">
		<p><?php echo wp_kses_data( __( 'We are glad you chose our WP theme for your website. You’ve done well customizing your website and we hope that you’ve enjoyed working with our theme.', 'vapester' ) ); ?></p>
		<p><?php echo wp_kses_data( __( 'It would be just awesome if you spend just a minute of your time to rate our theme or the customer service you’ve received from us.', 'vapester' ) ); ?></p>
		<p class="vapester_notice_text_info"><?php echo wp_kses_data( __( '* We love receiving 5-star ratings, because our CEO Henry Rise gives $5 to homeless dog shelter for every 5-star rating we get! Save the planet with us!', 'vapester' ) ); ?></p>
	</div>
	<?php

	// Buttons
	?>
	<div class="vapester_notice_buttons">
		<?php
		// Link to the theme download page
		?>
		<a href="<?php echo esc_url( vapester_storage_get( 'theme_download_url' ) ); ?>" class="button button-primary" target="_blank"><i class="dashicons dashicons-star-filled"></i> 
			<?php
			// Translators: Add theme name
			echo esc_html( sprintf( __( 'Rate theme %s', 'vapester' ), $vapester_theme_obj->name ) );
			?>
		</a>
		<?php
		// Link to the theme support
		?>
		<a href="<?php echo esc_url( vapester_storage_get( 'theme_support_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-sos"></i> 
			<?php
			esc_html_e( 'Support', 'vapester' );
			?>
		</a>
		<?php
		// Link to the theme documentation
		?>
		<a href="<?php echo esc_url( vapester_storage_get( 'theme_doc_url' ) ); ?>" class="button" target="_blank"><i class="dashicons dashicons-book"></i> 
			<?php
			esc_html_e( 'Documentation', 'vapester' );
			?>
		</a>
		<?php
		// Dismiss
		?>
		<a href="#" class="vapester_hide_notice"><i class="dashicons dashicons-dismiss"></i> <span class="vapester_hide_notice_text"><?php esc_html_e( 'Dismiss', 'vapester' ); ?></span></a>
	</div>
</div>
