<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! vapester_is_inherit( vapester_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( vapester_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$vapester_copyright = vapester_get_theme_option( 'copyright' );
			if ( ! empty( $vapester_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$vapester_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $vapester_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$vapester_copyright = vapester_prepare_macros( $vapester_copyright );
				// Display copyright
				echo wp_kses_post( nl2br( $vapester_copyright ) );
			}
			?>
			</div>
		</div>
	</div>
</div>
