<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.10
 */

$vapester_footer_id = vapester_get_custom_footer_id();
$vapester_footer_meta = get_post_meta( $vapester_footer_id, 'trx_addons_options', true );
if ( ! empty( $vapester_footer_meta['margin'] ) ) {
	vapester_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( vapester_prepare_css_value( $vapester_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $vapester_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $vapester_footer_id ) ) ); ?>
						<?php
						if ( ! vapester_is_inherit( vapester_get_theme_option( 'footer_scheme' ) ) ) {
							echo ' scheme_' . esc_attr( vapester_get_theme_option( 'footer_scheme' ) );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'vapester_action_show_layout', $vapester_footer_id );
	?>
</footer><!-- /.footer_wrap -->
