<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.10
 */

// Logo
if ( vapester_is_on( vapester_get_theme_option( 'logo_in_footer' ) ) ) {
	$vapester_logo_image = vapester_get_logo_image( 'footer' );
	$vapester_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $vapester_logo_image ) || ! empty( $vapester_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $vapester_logo_image ) ) {
					$vapester_attr = vapester_getimagesize( $vapester_logo_image );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $vapester_logo_image ) . '"'
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'vapester' ) . '"'
								. ( ! empty( $vapester_attr[3] ) ? ' ' . wp_kses_data( $vapester_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $vapester_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $vapester_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
