<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.10
 */

// Footer sidebar
$vapester_footer_name    = vapester_get_theme_option( 'footer_widgets' );
$vapester_footer_present = ! vapester_is_off( $vapester_footer_name ) && is_active_sidebar( $vapester_footer_name );
if ( $vapester_footer_present ) {
	vapester_storage_set( 'current_sidebar', 'footer' );
	$vapester_footer_wide = vapester_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $vapester_footer_name ) ) {
		dynamic_sidebar( $vapester_footer_name );
	}
	$vapester_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $vapester_out ) ) {
		$vapester_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $vapester_out );
		$vapester_need_columns = true; 
		if ( $vapester_need_columns ) {
			$vapester_columns = max( 0, (int) vapester_get_theme_option( 'footer_columns' ) );
			if ( 0 == $vapester_columns ) {
				$vapester_columns = min( 4, max( 1, substr_count( $vapester_out, '<aside ' ) ) );
			}
			if ( $vapester_columns > 1 ) {
				$vapester_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $vapester_columns ) . ' widget', $vapester_out );
			} else {
				$vapester_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $vapester_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $vapester_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $vapester_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'vapester_action_before_sidebar' );
				vapester_show_layout( $vapester_out );
				do_action( 'vapester_action_after_sidebar' );
				if ( $vapester_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $vapester_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
