<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.06
 */

$vapester_header_css   = '';
$vapester_header_image = get_header_image();
$vapester_header_video = vapester_get_header_video();
if ( ! empty( $vapester_header_image ) && vapester_trx_addons_featured_image_override( is_singular() || vapester_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$vapester_header_image = vapester_get_current_mode_image( $vapester_header_image );
}

$vapester_header_id = vapester_get_custom_header_id();
$vapester_header_meta = get_post_meta( $vapester_header_id, 'trx_addons_options', true );
if ( ! empty( $vapester_header_meta['margin'] ) ) {
	vapester_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( vapester_prepare_css_value( $vapester_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $vapester_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $vapester_header_id ) ) ); ?>
				<?php
				echo ! empty( $vapester_header_image ) || ! empty( $vapester_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $vapester_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $vapester_header_image ) {
					echo ' ' . esc_attr( vapester_add_inline_css_class( 'background-image: url(' . esc_url( $vapester_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( vapester_is_on( vapester_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight vapester-full-height';
				}
				if ( ! vapester_is_inherit( vapester_get_theme_option( 'header_scheme' ) ) ) {
					echo ' scheme_' . esc_attr( vapester_get_theme_option( 'header_scheme' ) );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $vapester_header_video ) ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'vapester_action_show_layout', $vapester_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
