<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_header_css   = '';
$vapester_header_image = get_header_image();
$vapester_header_video = vapester_get_header_video();
if ( ! empty( $vapester_header_image ) && vapester_trx_addons_featured_image_override( is_singular() || vapester_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$vapester_header_image = vapester_get_current_mode_image( $vapester_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $vapester_header_image ) || ! empty( $vapester_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $vapester_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $vapester_header_image ) {
		echo ' ' . esc_attr( vapester_add_inline_css_class( 'background-image: url(' . esc_url( $vapester_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( vapester_is_on( vapester_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight vapester-full-height';
	}
	if ( ! vapester_is_inherit( vapester_get_theme_option( 'header_scheme' ) ) ) {
		echo ' scheme_' . esc_attr( vapester_get_theme_option( 'header_scheme' ) );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $vapester_header_video ) ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	if ( vapester_get_theme_option( 'menu_style' ) == 'top' ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-navi' ) );
	}

	// Mobile header
	if ( vapester_is_on( vapester_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-title' ) );

	// Header widgets area
	get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-widgets' ) );

	// Display featured image in the header on the single posts
	// Comment next line to prevent show featured image in the header area
	// and display it in the post's content
	get_template_part( apply_filters( 'vapester_filter_get_template_part', 'templates/header-single' ) );

	?>
</header>
