<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

$vapester_args = get_query_var( 'vapester_logo_args' );

// Site logo
$vapester_logo_type   = isset( $vapester_args['type'] ) ? $vapester_args['type'] : '';
$vapester_logo_image  = vapester_get_logo_image( $vapester_logo_type );
$vapester_logo_text   = vapester_is_on( vapester_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$vapester_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $vapester_logo_image ) || ! empty( $vapester_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $vapester_logo_image ) ) {
			if ( empty( $vapester_logo_type ) && function_exists( 'the_custom_logo' ) && (int) $vapester_logo_image > 0 ) {
				the_custom_logo();
			} else {
				$vapester_attr = vapester_getimagesize( $vapester_logo_image );
				echo '<img src="' . esc_url( $vapester_logo_image ) . '" alt="' . esc_attr( $vapester_logo_text ) . '"' . ( ! empty( $vapester_attr[3] ) ? ' ' . wp_kses_data( $vapester_attr[3] ) : '' ) . '>';
			}
		} else {
			vapester_show_layout( vapester_prepare_macros( $vapester_logo_text ), '<span class="logo_text">', '</span>' );
			vapester_show_layout( vapester_prepare_macros( $vapester_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
