<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

// Page (category, tag, archive, author) title

if ( vapester_need_page_title() ) {
	vapester_sc_layouts_showed( 'title', true );
	vapester_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								vapester_show_post_meta(
									apply_filters(
										'vapester_filter_post_meta_args', array(
											'components' => vapester_array_get_keys_by_value( vapester_get_theme_option( 'meta_parts' ) ),
											'counters'   => vapester_array_get_keys_by_value( vapester_get_theme_option( 'counters' ) ),
											'seo'        => vapester_is_on( vapester_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$vapester_blog_title           = vapester_get_blog_title();
							$vapester_blog_title_text      = '';
							$vapester_blog_title_class     = '';
							$vapester_blog_title_link      = '';
							$vapester_blog_title_link_text = '';
							if ( is_array( $vapester_blog_title ) ) {
								$vapester_blog_title_text      = $vapester_blog_title['text'];
								$vapester_blog_title_class     = ! empty( $vapester_blog_title['class'] ) ? ' ' . $vapester_blog_title['class'] : '';
								$vapester_blog_title_link      = ! empty( $vapester_blog_title['link'] ) ? $vapester_blog_title['link'] : '';
								$vapester_blog_title_link_text = ! empty( $vapester_blog_title['link_text'] ) ? $vapester_blog_title['link_text'] : '';
							} else {
								$vapester_blog_title_text = $vapester_blog_title;
							}
							?>
							<?php
								if ( ! empty( $vapester_blog_title_text ) ){
							 ?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $vapester_blog_title_class ); ?>">
								<?php
								$vapester_top_icon = vapester_get_category_icon();
								if ( ! empty( $vapester_top_icon ) ) {
									$vapester_attr = vapester_getimagesize( $vapester_top_icon );
									?>
									<img src="<?php echo esc_url( $vapester_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'vapester' ); ?>"
										<?php
										if ( ! empty( $vapester_attr[3] ) ) {
											vapester_show_layout( $vapester_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_post( $vapester_blog_title_text );
								?>
							</h1>
							<?php
							}
							if ( ! empty( $vapester_blog_title_link ) && ! empty( $vapester_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $vapester_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $vapester_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						?>
						<div class="sc_layouts_title_breadcrumbs">
							<?php
							do_action( 'vapester_action_breadcrumbs' );
							?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
