<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.14
 */
$vapester_header_video = vapester_get_header_video();
$vapester_embed_video  = '';
if ( ! empty( $vapester_header_video ) && ! vapester_is_from_uploads( $vapester_header_video ) ) {
	if ( vapester_is_youtube_url( $vapester_header_video ) && preg_match( '/[=\/]([^=\/]*)$/', $vapester_header_video, $matches ) && ! empty( $matches[1] ) ) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr( $matches[1] ); ?>"></div>
		<?php
	} else {
		global $wp_embed;
		if ( false && is_object( $wp_embed ) ) {
			$vapester_embed_video = do_shortcode( $wp_embed->run_shortcode( '[embed]' . trim( $vapester_header_video ) . '[/embed]' ) );
			$vapester_embed_video = vapester_make_video_autoplay( $vapester_embed_video );
		} else {
			$vapester_header_video = str_replace( '/watch?v=', '/embed/', $vapester_header_video );
			$vapester_header_video = vapester_add_to_url(
				$vapester_header_video, array(
					'feature'        => 'oembed',
					'controls'       => 0,
					'autoplay'       => 1,
					'showinfo'       => 0,
					'modestbranding' => 1,
					'wmode'          => 'transparent',
					'enablejsapi'    => 1,
					'origin'         => home_url(),
					'widgetid'       => 1,
				)
			);
			$vapester_embed_video  = '<iframe src="' . esc_url( $vapester_header_video ) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?>
		<div id="background_video"><?php vapester_show_layout( $vapester_embed_video ); ?></div>
		<?php
	}
}
