<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0
 */

// Header sidebar
$vapester_header_name    = vapester_get_theme_option( 'header_widgets' );
$vapester_header_present = ! vapester_is_off( $vapester_header_name ) && is_active_sidebar( $vapester_header_name );
if ( $vapester_header_present ) {
	vapester_storage_set( 'current_sidebar', 'header' );
	$vapester_header_wide = vapester_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $vapester_header_name ) ) {
		dynamic_sidebar( $vapester_header_name );
	}
	$vapester_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $vapester_widgets_output ) ) {
		$vapester_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $vapester_widgets_output );
		$vapester_need_columns   = strpos( $vapester_widgets_output, 'columns_wrap' ) === false;
		if ( $vapester_need_columns ) {
			$vapester_columns = max( 0, (int) vapester_get_theme_option( 'header_columns' ) );
			if ( 0 == $vapester_columns ) {
				$vapester_columns = min( 6, max( 1, substr_count( $vapester_widgets_output, '<aside ' ) ) );
			}
			if ( $vapester_columns > 1 ) {
				$vapester_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $vapester_columns ) . ' widget', $vapester_widgets_output );
			} else {
				$vapester_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $vapester_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $vapester_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $vapester_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'vapester_action_before_sidebar' );
				vapester_show_layout( $vapester_widgets_output );
				do_action( 'vapester_action_after_sidebar' );
				if ( $vapester_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $vapester_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
