<?php
/** 	Template Name: Theme Canvas
  *		Template Post Type: cpt_layouts
 **/
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php wp_head(); ?>
	<?php
	// Keep the following line after `wp_head()` call, to ensure it's not overridden by another templates.
	?>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover" />
</head>
<body <?php body_class(); ?>>
	<?php $type = get_post_meta( get_the_ID(),'trx_addons_layout_type', true ) ?>
	<?php if ( 'header' == $type ) { ?>
		<header class="top_panel top_panel_custom<?php echo ' scheme_' . esc_attr( vapester_get_theme_option( 'header_scheme' ) ); ?>">
	<?php } elseif ( 'footer' == $type ) { ?>
		<footer class="footer_wrap footer_custom<?php echo ' scheme_' . esc_attr( vapester_get_theme_option( 'footer_scheme' ) ); ?>">
	<?php }

	/**
	 * Before canvas page template content.
	 *
	 * Fires before the content of Elementor canvas page template.
	 *
	 * @since 1.0.0
	 */
	do_action( 'elementor/page_templates/canvas/before_content' );

	\Elementor\Plugin::$instance->modules_manager->get_modules( 'page-templates' )->print_content();

	/**
	 * After canvas page template content.
	 *
	 * Fires after the content of Elementor canvas page template.
	 *
	 * @since 1.0.0
	 */
	do_action( 'elementor/page_templates/canvas/after_content' );
	if ( 'header' == $type ) { ?>
		</header>
	<?php } elseif ( 'footer' == $type ) { ?>
		</footer>
	<?php }
	wp_footer();
	?>
	</body>
</html>