<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage VAPESTER
 * @since VAPESTER 1.0.22
 */

// If this theme is a free version of premium theme
if ( ! defined( 'VAPESTER_THEME_FREE' ) ) {
	define( 'VAPESTER_THEME_FREE', false );
}
if ( ! defined( 'VAPESTER_THEME_FREE_WP' ) ) {
	define( 'VAPESTER_THEME_FREE_WP', false );
}

// If this theme uses multiple skins
if ( ! defined( 'VAPESTER_ALLOW_SKINS' ) ) {
	define( 'VAPESTER_ALLOW_SKINS', false );
}
if ( ! defined( 'VAPESTER_DEFAULT_SKIN' ) ) {
	define( 'VAPESTER_DEFAULT_SKIN', 'default' );
}

// Theme storage
// Attention! Must be in the global namespace to compatibility with WP CLI
$GLOBALS['VAPESTER_STORAGE'] = array(

	// Theme required plugin's slugs
	'required_plugins'   => array_merge(

		// List of plugins for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			// Required plugins
			// DON'T COMMENT OR REMOVE NEXT LINES!
			'trx_addons'         => esc_html__( 'ThemeREX Addons', 'vapester' ),
			// If plugin not need - comment (or remove) it
			'elementor'          => esc_html__( 'Elementor', 'vapester' ),
			'contact-form-7'     => esc_html__( 'Contact Form 7', 'vapester' ),
			'instagram-feed'     => esc_html__( 'Instagram Feed', 'vapester' ),
			'mailchimp-for-wp'   => esc_html__( 'MailChimp for WP', 'vapester' ),
			'woocommerce'        => esc_html__( 'WooCommerce', 'vapester' ),
			'wp-live-chat-support' => esc_html__( 'WP Live Chat Support', 'vapester' ),
		),
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		VAPESTER_THEME_FREE
			? array(
				// Recommended (supported) plugins for the FREE (lite) version
				'siteorigin-panels' => esc_html__( 'SiteOrigin Panels', 'vapester' ),
			)

		// List of plugins for the PREMIUM version only
		//-----------------------------------------------------
			: array(
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it
				'essential-grid'             => esc_html__( 'Essential Grid', 'vapester' ),
				'ubermenu'                   => esc_html__( 'UberMenu', 'vapester' ),
				'revslider'                  => esc_html__( 'Revolution Slider', 'vapester' ),
			)
	),

	// Theme-specific blog layouts
	'blog_styles'        => array_merge(
		// Layouts for both - FREE and PREMIUM versions
		//-----------------------------------------------------
		array(
			'excerpt' => array(
				'title'   => esc_html__( 'Standard', 'vapester' ),
				'archive' => 'index-excerpt',
				'item'    => 'content-excerpt',
				'styles'  => 'excerpt',
			),
			'classic' => array(
				'title'   => esc_html__( 'Classic', 'vapester' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'classic',
			),
		),
		// Layouts for the FREE version only
		//-----------------------------------------------------
		VAPESTER_THEME_FREE
		? array()

		// Layouts for the PREMIUM version only
		//-----------------------------------------------------
		: array(
			'masonry'   => array(
				'title'   => esc_html__( 'Masonry', 'vapester' ),
				'archive' => 'index-classic',
				'item'    => 'content-classic',
				'columns' => array( 2, 3 ),
				'styles'  => 'masonry',
			),
			'portfolio' => array(
				'title'   => esc_html__( 'Portfolio', 'vapester' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio',
				'columns' => array( 2, 3, 4 ),
				'styles'  => 'portfolio',
			),
			'gallery'   => array(
				'title'   => esc_html__( 'Gallery', 'vapester' ),
				'archive' => 'index-portfolio',
				'item'    => 'content-portfolio-gallery',
				'columns' => array( 2, 3, 4 ),
				'styles'  => array( 'portfolio', 'gallery' ),
			),
			'chess'     => array(
				'title'   => esc_html__( 'Chess', 'vapester' ),
				'archive' => 'index-chess',
				'item'    => 'content-chess',
				'columns' => array( 1, 2, 3 ),
				'styles'  => 'chess',
			),
		)
	),

	// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
	'theme_pro_key'      => 'env-themerex',

	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'     => 'http://vapester.themerex.net',
	'theme_doc_url'      => 'http://vapester.themerex.net/doc/',
	'theme_download_url'  => '//themeforest.net/item/vapester-creative-vape-shop-woocommerce-theme/24040931',            // ThemeREX

	'theme_support_url'   => '//themerex.net/support/',                              // ThemeREX

	'theme_video_url'     => '//www.youtube.com/channel/UCnFisBimrK2aIE-hnY70kCA',   // ThemeREX

	// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
	// (i.e. 'children,kindergarten')
	'theme_categories'   => '',

	// Responsive resolutions
	// Parameters to create css media query: min, max
	'responsive'         => array(
		// By device
		'wide'     => array(
			'min' => 2160
		),
		'desktop'  => array(
			'min' => 1680,
			'max' => 2159,
		),
		'notebook' => array(
			'min' => 1280,
			'max' => 1679,
		),
		'tablet'   => array(
			'min' => 768,
			'max' => 1279,
		),
		'mobile'   => array( 'max' => 767 ),
		// By size
		'xxl'      => array( 'max' => 1679 ),
		'xl'       => array( 'max' => 1439 ),
		'lg'       => array( 'max' => 1279 ),
		'md'       => array( 'max' => 1023 ),
		'sm'       => array( 'max' => 767 ),
		'sm_wp'    => array( 'max' => 600 ),
		'xs'       => array( 'max' => 479 ),
	),
);

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( ! function_exists( 'vapester_customizer_theme_setup1' ) ) {
	add_action( 'after_setup_theme', 'vapester_customizer_theme_setup1', 1 );
	function vapester_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		vapester_storage_set(
			'settings', array(

				'duplicate_options'      => 'child',            // none  - use separate options for the main and the child-theme
																// child - duplicate theme options from the main theme to the child-theme only
																// both  - sinchronize changes in the theme options between main and child themes

				'customize_refresh'      => 'auto',             // Refresh method for preview area in the Appearance - Customize:
																// auto - refresh preview area on change each field with Theme Options
																// manual - refresh only obn press button 'Refresh' at the top of Customize frame

				'max_load_fonts'         => 5,                  // Max fonts number to load from Google fonts or from uploaded fonts

				'comment_after_name'     => true,               // Place 'comment' field after the 'name' and 'email'

				'icons_selector'         => 'internal',         // Icons selector in the shortcodes:
																// vc (default) - standard VC (very slow) or Elementor's icons selector (not support images and svg)
																// internal - internal popup with plugin's or theme's icons list (fast and support images and svg)

				'icons_type'             => 'icons',            // Type of icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present icons
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'socials_type'           => 'icons',            // Type of socials icons (if 'icons_selector' is 'internal'):
																// icons  - use font icons to present social networks
																// images - use images from theme's folder trx_addons/css/icons.png
																// svg    - use svg from theme's folder trx_addons/css/icons.svg

				'check_min_version'      => true,               // Check if exists a .min version of .css and .js and return path to it
																// instead the path to the original file
																// (if debug_mode is off and modification time of the original file < time of the .min file)

				'autoselect_menu'        => false,              // Show any menu if no menu selected in the location 'main_menu'
																// (for example, the theme is just activated)

				'disable_jquery_ui'      => false,              // Prevent loading custom jQuery UI libraries in the third-party plugins

				'use_mediaelements'      => true,               // Load script "Media Elements" to play video and audio

				'tgmpa_upload'           => false,              // Allow upload not pre-packaged plugins via TGMPA

				'allow_no_image'         => false,              // Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.

				'separate_schemes'       => true,               // Save color schemes to the separate files __color_xxx.css (true) or append its to the __custom.css (false)

				'allow_fullscreen'       => false,              // Allow cases 'fullscreen' and 'fullwide' for the body style in the Theme Options
																// In the Page Options this styles are present always
																// (can be removed if filter 'vapester_filter_allow_fullscreen' return false)

				'attachments_navigation' => false,              // Add arrows on the single attachment page to navigate to the prev/next attachment
				
				'gutenberg_safe_mode'    => array('elementor'), // vc,elementor - Prevent simultaneous editing of posts for Gutenberg and other PageBuilders (VC, Elementor)

				'allow_gutenberg_blocks' => false,              // Allow our shortcodes and widgets as blocks in the Gutenberg (not ready yet - in the development now)

				'subtitle_above_title'   => true,               // Put subtitle above the title in the shortcodes

				'add_hide_on_xxx' => 'replace',                 // Add our breakpoints to the Responsive section of each element
																// 'add' - add our breakpoints after Elementor's
																// 'replace' - add our breakpoints instead Elementor's
																// 'none' - don't add our breakpoints (using only Elementor's)
			)
		);

		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------

		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		vapester_storage_set(
			'load_fonts', array(
				// Google font
				array(
					'name'   => 'PT Sans',
					'family' => 'sans-serif',
					'styles' => '400,400i,700,700i',     // Parameter 'style' used only for the Google fonts
				),
				array(
					'name'   => 'Bungee',
					'family' => 'cursive',
					'styles' => '400',     // Parameter 'style' used only for the Google fonts
				),
				array(
					'name'   => 'Economica',
					'family' => 'sans-serif',
					'styles' => '400,400i,700,700i',     // Parameter 'style' used only for the Google fonts
				),
				// Font-face packed with theme
				array(
					'name'   => 'Montserrat',
					'family' => 'sans-serif',
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		vapester_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!

		vapester_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'vapester' ),
					'font-family'     => '"PT Sans",sans-serif',
					'font-size'       => '1.07143rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.6em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'vapester' ),
					'font-family'     => '"Bungee",cursive',
					'font-size'       => '6.6667em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '0.87em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.8em',
					'margin-bottom'   => '0.3em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'vapester' ),
					'font-family'     => '"Bungee",cursive',
					'font-size'       => '5.3333em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '0.875em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.93em',
					'margin-bottom'   => '0.4em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'vapester' ),
					'font-family'     => '"Bungee",cursive',
					'font-size'       => '4em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.1833em',
					'margin-bottom'   => '0.4em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'vapester' ),
					'font-family'     => '"Bungee",cursive',
					'font-size'       => '2.6667em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.1em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.63em',
					'margin-bottom'   => '0.625em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '3em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.2888em',
					'margin-bottom'   => '0.4667em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '2em',
					'font-weight'     => '600',
					'font-style'      => 'normal',
					'line-height'     => '1.1667em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.8125em',
					'margin-bottom'   => '0.5em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the text case of the logo', 'vapester' ),
					'font-family'     => '"Bungee",sans-serif',
					'font-size'       => '1.8em',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '1.2em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3333em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the input fields, dropdowns and textareas', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '1.2em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3333em', // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the post meta: date, counters, share, etc.', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '1em',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.33333em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the main menu items', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '1.2em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3333em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'vapester' ),
					'description'     => esc_html__( 'Font settings of the dropdown menu items', 'vapester' ),
					'font-family'     => '"Economica",sans-serif',
					'font-size'       => '1em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.3333em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
			)
		);

		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		vapester_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'vapester' ),
					'description' => esc_html__( 'Colors of the main content area', 'vapester' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'vapester' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'vapester' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'vapester' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'vapester' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'vapester' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'vapester' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'vapester' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'vapester' ),
				),
			)
		);
		vapester_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'vapester' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'vapester' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'vapester' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'vapester' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'vapester' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'vapester' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'vapester' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'vapester' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'vapester' ),
					'description' => esc_html__( 'Color of the plain text inside this block', 'vapester' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'vapester' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'vapester' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'vapester' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'vapester' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'vapester' ),
					'description' => esc_html__( 'Color of the links inside this block', 'vapester' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'vapester' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'vapester' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Link 2', 'vapester' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'vapester' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Link 2 hover', 'vapester' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'vapester' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Link 3', 'vapester' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'vapester' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Link 3 hover', 'vapester' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'vapester' ),
				),
			)
		);
		vapester_storage_set(
			'schemes', array(

				// Color scheme: 'default'
				'default' => array(
					'title'    => esc_html__( 'Default', 'vapester' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#ffffff',
						'bd_color'         => '#e6e6e6',

						// Text and links colors
						'text'             => '#a8a8a8',
						'text_dark'        => '#292929',
						'text_light'       => '#292929',
						'text_link'        => '#d22756',
						'text_hover'       => '#292929',
						'text_link2'       => '#f2d71f',
						'text_hover2'      => '#ffffff',
						'text_link3'       => '#af7ffc',
						'text_hover3'      => '#ffffff',

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#292929',
						'alter_bg_hover'   => '#ebeff3',
						'alter_bd_color'   => '#e1e1e1',
						'alter_bd_hover'   => '#ffffff',
						'alter_text'       => '#939393',
						'alter_dark'       => '#ffffff',
						'alter_light'      => '#939393',
						'alter_link'       => '#f2d71f',
						'alter_hover'      => '#d22756',
						'alter_link2'      => '#ffffff',
						'alter_hover2'     => '#ffffff',
						'alter_link3'      => '#ffffff',
						'alter_hover3'     => '#ffffff',

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#292929',
						'extra_bg_hover'   => '#393939',
						'extra_bd_color'   => '#343434',
						'extra_bd_hover'   => '#ffffff',
						'extra_text'       => '#939393',
						'extra_dark'       => '#ffffff',
						'extra_light'      => '#afafaf',
						'extra_link'       => '#f2d71f',
						'extra_hover'      => '#d22756',
						'extra_link2'      => '#ffffff',
						'extra_hover2'     => '#ffffff',
						'extra_link3'      => '#ffffff',
						'extra_hover3'     => '#ffffff',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#393939',
						'input_bg_hover'   => '#393939',
						'input_bd_color'   => '#393939',
						'input_bd_hover'   => '#dddfe2',
						'input_text'       => '#ffffff',
						'input_dark'       => '#393939',
						'input_light'      => '#ffffff',

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#ffffff',
						'inverse_bd_hover' => '#ffffff',
						'inverse_text'     => '#1d1d1d',
						'inverse_dark'     => '#1d1d1d',
						'inverse_light'    => '#f2d71f',
						'inverse_link'     => '#ffffff',
						'inverse_hover'    => '#d22756',
					),
				),

				// Color scheme: 'dark'
				'dark'    => array(
					'title'    => esc_html__( 'Dark', 'vapester' ),
					'internal' => true,
					'colors'   => array(

						// Whole block border and background
						'bg_color'         => '#0e0d12',
						'bd_color'         => '#2e2d32',

						// Text and links colors
						'text'             => '#939393',
						'text_dark'        => '#ffffff',
						'text_light'       => '#ffffff',
						'text_link'        => '#f2d71f',
						'text_hover'       => '#d22756',
						'text_link2'       => '#ffffff',
						'text_hover2'      => '#ffffff',
						'text_link3'       => '#ffffff',
						'text_hover3'      => '#ffffff',

						// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
						'alter_bg_color'   => '#ffffff',
						'alter_bg_hover'   => '#e6e6e6',
						'alter_bd_color'   => '#0e0d12',
						'alter_bd_hover'   => '#ffffff',
						'alter_text'       => '#a6a6a6',
						'alter_dark'       => '#292929',
						'alter_light'      => '#a8a8a8',
						'alter_link'       => '#d22756',
						'alter_hover'      => '#f2d71f',
						'alter_link2'      => '#ffffff',
						'alter_hover2'     => '#ffffff',
						'alter_link3'      => '#ffffff',
						'alter_hover3'     => '#ffffff',

						// Extra blocks (submenu, tabs, color blocks, etc.)
						'extra_bg_color'   => '#ffffff',
						'extra_bg_hover'   => '#f3f5f7',
						'extra_bd_color'   => '#e5e5e5',
						'extra_bd_hover'   => '#ffffff',
						'extra_text'       => '#a6a6a6',
						'extra_dark'       => '#292929',
						'extra_light'      => '#b7b7b7',
						'extra_link'       => '#d22756',
						'extra_hover'      => '#f2d71f',
						'extra_link2'      => '#ffffff',
						'extra_hover2'     => '#ffffff',
						'extra_link3'      => '#ffffff',
						'extra_hover3'     => '#ffffff',

						// Input fields (form's fields and textarea)
						'input_bg_color'   => '#e6e6e6',
						'input_bg_hover'   => '#e6e6e6',
						'input_bd_color'   => '#ffffff',
						'input_bd_hover'   => '#3e3d41',
						'input_text'       => '#292929',
						'input_dark'       => '#393939',
						'input_light'      => '#ffffff',

						// Inverse blocks (text and links on the 'text_link' background)
						'inverse_bd_color' => '#ffffff',
						'inverse_bd_hover' => '#ffffff',
						'inverse_text'     => '#1d1d1d',
						'inverse_dark'     => '#1d1d1d',
						'inverse_light'    => '#d22756',
						'inverse_link'     => '#ffffff',
						'inverse_hover'    => '#292929',
					),
				),

			)
		);

		// Simple schemes substitution
		// Lists the colors and brightness factors that are used to generate other colors in the color scheme
		// Leave this array empty if your scheme does not have a color dependency
		vapester_storage_set(
			'schemes_simple', array(
				// Main color => List the slave elements and it's brightness factors
				'text_link'   => array(
					'alter_hover'      => 1,
					'extra_link'       => 1,
					'inverse_bd_color' => 0.85,
					'inverse_bd_hover' => 0.7,
				),
				'text_hover'  => array(
					'alter_link'  => 1,
					'extra_hover' => 1,
				),
				'text_link2'  => array(
					'alter_hover2' => 1,
					'extra_link2'  => 1,
				),
				'text_hover2' => array(
					'alter_link2'  => 1,
					'extra_hover2' => 1,
				),
				'text_link3'  => array(
					'alter_hover3' => 1,
					'extra_link3'  => 1,
				),
				'text_hover3' => array(
					'alter_link3'  => 1,
					'extra_hover3' => 1,
				),
			)
		);

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		vapester_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'bg_color_095' => array(
					'color' => 'bg_color',
					'alpha' => 0.95,
				),
				'bd_color_01' => array(
					'color' => 'bd_color',
					'alpha' => 0.1,
				),
				'bd_color_02' => array(
					'color' => 'bd_color',
					'alpha' => 0.2,
				),
				'alter_bg_color_095' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.95,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_06'     => array(
					'color' => 'alter_link',
					'alpha' => 0.6,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'bg_color_095'      => array(
					'color' => 'bg_color',
					'alpha' => 0.95,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_06'      => array(
					'color' => 'text_link',
					'alpha' => 0.6,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link3_06'      => array(
					'color' => 'text_link3',
					'alpha' => 0.6,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_08' => array(
					'color' => 'alter_link',
					'alpha' => 0.8,
				),
				'extra_bg_hover_015' => array(
					'color' => 'extra_bg_hover',
					'alpha' => 0.15,
				),
			)
		);

		// Parameters to set order of schemes in the css
		vapester_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		vapester_storage_set(
			'theme_thumbs', apply_filters(
				'vapester_filter_add_thumb_sizes', array(
					// Width of the image is equal to the content area width (without sidebar)
					// Height is fixed
					'vapester-thumb-huge'        => array(
						'size'  => array( 1370, 0, true ),
						'title' => esc_html__( 'Huge image', 'vapester' ),
						'subst' => 'trx_addons-thumb-huge',
					),
					// Width of the image is equal to the content area width (with sidebar)
					// Height is fixed
					'vapester-thumb-big'         => array(
						'size'  => array( 970, 628, true ),
						'title' => esc_html__( 'Large image', 'vapester' ),
						'subst' => 'trx_addons-thumb-big',
					),

					// Width of the image is equal to the 1/3 of the content area width (without sidebar)
					// Height is fixed
					'vapester-thumb-med'         => array(
						'size'  => array( 423, 510, true ),
						'title' => esc_html__( 'Medium image', 'vapester' ),
						'subst' => 'trx_addons-thumb-medium',
					),

					// Small square image (for avatars in comments, etc.)
					'vapester-thumb-tiny'        => array(
						'size'  => array( 90, 90, true ),
						'title' => esc_html__( 'Small square avatar', 'vapester' ),
						'subst' => 'trx_addons-thumb-tiny',
					),

					// Width of the image is equal to the content area width (with sidebar)
					// Height is proportional (only downscale, not crop)
					'vapester-thumb-masonry-big' => array(
						'size'  => array( 940, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry Large (scaled)', 'vapester' ),
						'subst' => 'trx_addons-thumb-masonry-big',
					),
					'vapester-thumb-related-posts' => array(
						'size'  => array( 445, 280, true ),     // Only downscale, not crop
						'title' => esc_html__( 'Related posts', 'vapester' ),
						'subst' => 'trx_addons-thumb-related',
					),
					// Width of the image is equal to the 1/3 of the full content area width (without sidebar)
					// Height is proportional (only downscale, not crop)
					'vapester-thumb-masonry'     => array(
						'size'  => array( 370, 0, false ),     // Only downscale, not crop
						'title' => esc_html__( 'Masonry (scaled)', 'vapester' ),
						'subst' => 'trx_addons-thumb-masonry',
					),

					'vapester-thumb-team'         => array(
						'size'  => array( 291, 428, true ),
						'title' => esc_html__( 'Tean image', 'vapester' ),
						'subst' => 'trx_addons-thumb-team',
					),

					'vapester-thumb-product'      => array(
						'size'  => array( 654, 690, true ),
						'title' => esc_html__( 'Tean image', 'vapester' ),
						'subst' => 'trx_addons-thumb-team',
					),
				)
			)
		);
	}
}




//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'vapester_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'vapester_importer_set_options', 9 );
	function vapester_importer_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Allow import/export functionality
			$options['allow_import'] = true;
			$options['allow_export'] = true;
			// Prepare demo data
			$options['demo_url'] = esc_url( vapester_get_protocol() . '://demofiles.themerex.net/vapester/' );
			// Required plugins
			$options['required_plugins'] = array_keys( vapester_storage_get( 'required_plugins' ) );
			// Set number of thumbnails (usually 3 - 5) to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 1;
			// Default demo
			$options['files']['default']['title']       = esc_html__( 'Vapester Demo', 'vapester' );
			$options['files']['default']['domain_dev']  = esc_url( vapester_get_protocol() . '://vapester.themerex.net' );       // Developers domain
			$options['files']['default']['domain_demo'] = esc_url( vapester_get_protocol() . '://vapester.themerex.net' );       // Demo-site domain
			// If theme need more demo - just copy 'default' and change required parameter

			// Banners
			$options['banners'] = array(
				array(
					'image'        => vapester_get_file_url( 'theme-specific/theme-about/images/frontpage.png' ),
					'title'        => esc_html__( 'Front Page Builder', 'vapester' ),
					'content'      => wp_kses_post( __( "Create your front page right in the WordPress Customizer. There's no need in any page builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'vapester' ) ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=VT0AUbMl_KA' ),
					'link_caption' => esc_html__( 'Watch Video Introduction', 'vapester' ),
					'duration'     => 20,
				),
				array(
					'image'        => vapester_get_file_url( 'theme-specific/theme-about/images/layouts.png' ),
					'title'        => esc_html__( 'Layouts Builder', 'vapester' ),
					'content'      => wp_kses_post( __( 'Use Layouts Builder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'vapester' ) ),
					'link_url'     => esc_url( '//www.youtube.com/watch?v=pYhdFVLd7y4' ),
					'link_caption' => esc_html__( 'Learn More', 'vapester' ),
					'duration'     => 20,
				),
				array(
					'image'        => vapester_get_file_url( 'theme-specific/theme-about/images/documentation.png' ),
					'title'        => esc_html__( 'Read Full Documentation', 'vapester' ),
					'content'      => wp_kses_post( __( 'Need more details? Please check our full online documentation for detailed information on how to use Vapester.', 'vapester' ) ),
					'link_url'     => esc_url( vapester_storage_get( 'theme_doc_url' ) ),
					'link_caption' => esc_html__( 'Online Documentation', 'vapester' ),
					'duration'     => 15,
				),
				array(
					'image'        => vapester_get_file_url( 'theme-specific/theme-about/images/video-tutorials.png' ),
					'title'        => esc_html__( 'Video Tutorials', 'vapester' ),
					'content'      => wp_kses_post( __( 'No time for reading documentation? Check out our video tutorials and learn how to customize Vapester in detail.', 'vapester' ) ),
					'link_url'     => esc_url( vapester_storage_get( 'theme_video_url' ) ),
					'link_caption' => esc_html__( 'Video Tutorials', 'vapester' ),
					'duration'     => 15,
				),
				array(
					'image'        => vapester_get_file_url( 'theme-specific/theme-about/images/studio.png' ),
					'title'        => esc_html__( 'Mockingbird Website Customization Studio', 'vapester' ),
					'content'      => wp_kses_post( __( "Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and much more.", 'vapester' ) ),
					'link_url'     => esc_url( '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall' ),
					'link_caption' => esc_html__( 'Contact Us', 'vapester' ),
					'duration'     => 25,
				),
			);
		}
		return $options;
	}
}


//------------------------------------------------------------------------
// OCDI support
//------------------------------------------------------------------------

// Set theme specific OCDI options
if ( ! function_exists( 'vapester_ocdi_set_options' ) ) {
	add_filter( 'trx_addons_filter_ocdi_options', 'vapester_ocdi_set_options', 9 );
	function vapester_ocdi_set_options( $options = array() ) {
		if ( is_array( $options ) ) {
			// Prepare demo data
			$options['demo_url'] = esc_url( vapester_get_protocol() . '://demofiles.themerex.net/vapester/' );
			// Required plugins
			$options['required_plugins'] = array_keys( vapester_storage_get( 'required_plugins' ) );
			// Demo-site domain
			$options['files']['ocdi']['title']       = esc_html__( 'Vapester OCDI Demo', 'vapester' );
			$options['files']['ocdi']['domain_demo'] = esc_url( vapester_get_protocol() . '://vapester.themerex.net' );
			// If theme need more demo - just copy 'default' and change required parameter
		}
		return $options;
	}
}


// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if ( ! function_exists( 'vapester_create_theme_options' ) ) {

	function vapester_create_theme_options() {

		// Message about options override.
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = esc_html__( 'Attention! Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages. If you changed such parameter and nothing happened on the page, this option may be overridden in the corresponding section or in the Page Options of this page. These options are marked with an asterisk (*) in the title.', 'vapester' );

		// Color schemes number: if < 2 - hide fields with selectors
		$hide_schemes = count( vapester_storage_get( 'schemes' ) ) < 2;

		vapester_storage_set(
			'options', array(

				// 'Logo & Site Identity'
				'title_tagline'                 => array(
					'title'    => esc_html__( 'Logo & Site Identity', 'vapester' ),
					'desc'     => '',
					'priority' => 10,
					'type'     => 'section',
				),
				'logo_info'                     => array(
					'title'    => esc_html__( 'Logo Settings', 'vapester' ),
					'desc'     => '',
					'priority' => 20,
					'qsetup'   => esc_html__( 'General', 'vapester' ),
					'type'     => 'info',
				),
				'logo_text'                     => array(
					'title'    => esc_html__( 'Use Site Name as Logo', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Use the site title and tagline as a text logo if no image is selected', 'vapester' ) ),
					'class'    => 'vapester_column-1_2 vapester_new_row',
					'priority' => 30,
					'std'      => 1,
					'qsetup'   => esc_html__( 'General', 'vapester' ),
					'type'     => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'logo_retina_enabled'           => array(
					'title'    => esc_html__( 'Allow retina display logo', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Show fields to select logo images for Retina display', 'vapester' ) ),
					'class'    => 'vapester_column-1_2',
					'priority' => 40,
					'refresh'  => false,
					'std'      => 0,
					'type'     => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
				'logo_retina'                   => array(
					'title'      => esc_html__( 'Logo for Retina', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'vapester' ) ),
					'class'      => 'vapester_column-1_2',
					'priority'   => 70,
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile_header'            => array(
					'title' => esc_html__( 'Logo for the mobile header', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'vapester' ) ),
					'class' => 'vapester_column-1_2 vapester_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_header_retina'     => array(
					'title'      => esc_html__( 'Logo for the mobile header on Retina', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'vapester' ) ),
					'class'      => 'vapester_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'image',
				),
				'logo_mobile'                   => array(
					'title' => esc_html__( 'Logo for the mobile menu', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select or upload site logo to display it in the mobile menu', 'vapester' ) ),
					'class' => 'vapester_column-1_2 vapester_new_row',
					'std'   => '',
					'type'  => 'image',
				),
				'logo_mobile_retina'            => array(
					'title'      => esc_html__( 'Logo mobile on Retina', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'vapester' ) ),
					'class'      => 'vapester_column-1_2',
					'dependency' => array(
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'image',
				),

				// 'General settings'
				'general'                       => array(
					'title'    => esc_html__( 'General Settings', 'vapester' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 20,
					'type'     => 'section',
				),

				'general_layout_info'           => array(
					'title'  => esc_html__( 'Layout', 'vapester' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'vapester' ),
					'type'   => 'info',
				),
				'body_style'                    => array(
					'title'    => esc_html__( 'Body style', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select width of the body content', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'qsetup'   => esc_html__( 'General', 'vapester' ),
					'refresh'  => false,
					'std'      => 'wide',
					'options'  => vapester_get_list_body_styles( false ),
					'type'     => 'select',
				),
				'page_width'                    => array(
					'title'      => esc_html__( 'Page width', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Total width of the site content and sidebar (in pixels). If empty - use default width', 'vapester' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed', 'wide' ),
					),
					'std'        => 1370,
					'min'        => 1000,
					'max'        => 1400,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'page',         // SASS variable's name to preview changes 'on fly'
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'slider',
				),
				'boxed_bg_image'                => array(
					'title'      => esc_html__( 'Boxed bg image', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload image, used as background in the boxed body', 'vapester' ) ),
					'dependency' => array(
						'body_style' => array( 'boxed' ),
					),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'std'        => '',
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					//'hidden'     => true,
					'type'       => 'image',
				),
				'remove_margins'                => array(
					'title'    => esc_html__( 'Remove margins', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Remove margins above and below the content area', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'refresh'  => false,
					'std'      => 0,
					'type'     => 'checkbox',
				),

				'general_sidebar_info'          => array(
					'title' => esc_html__( 'Sidebar', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position'              => array(
					'title'    => esc_html__( 'Sidebar position', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select position to show sidebar', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,post,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'vapester' ),
					),
					'std'      => 'right',
					'qsetup'   => esc_html__( 'General', 'vapester' ),
					'options'  => array(),
					'type'     => 'switch',
				),
				'sidebar_widgets'               => array(
					'title'      => esc_html__( 'Sidebar widgets', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Widgets', 'vapester' ),
					),
					'dependency' => array(
						'sidebar_position' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					'type'       => 'select',
				),
				'sidebar_width'                 => array(
					'title'      => esc_html__( 'Sidebar width', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Width of the sidebar (in pixels). If empty - use default width', 'vapester' ) ),
					'std'        => 350,
					'min'        => 150,
					'max'        => 500,
					'step'       => 10,
					'refresh'    => false,
					'customizer' => 'sidebar',      // SASS variable's name to preview changes 'on fly'
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'slider',
				),
				'sidebar_gap'                   => array(
					'title'      => esc_html__( 'Sidebar gap', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Gap between content and sidebar (in pixels). If empty - use default gap', 'vapester' ) ),
					'std'        => 80,
					'min'        => 0,
					'max'        => 100,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'gap',          // SASS variable's name to preview changes 'on fly'
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'slider',
				),
				'expand_content'                => array(
					'title'   => esc_html__( 'Expand content', 'vapester' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'vapester' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'general_effects_info'          => array(
					'title' => esc_html__( 'Design & Effects', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'border_radius'                 => array(
					'title'      => esc_html__( 'Border radius', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Specify the border radius of the form fields and buttons in pixels', 'vapester' ) ),
					'std'        => 0,
					'min'        => 0,
					'max'        => 20,
					'step'       => 1,
					'refresh'    => false,
					'customizer' => 'rad',      // SASS name to preview changes 'on fly'
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'slider',
				),

				'general_misc_info'             => array(
					'title' => esc_html__( 'Miscellaneous', 'vapester' ),
					'desc'  => '',
					'type'  => VAPESTER_THEME_FREE ? 'hidden' : 'info',
				),
				'privacy_text' => array(
					"title" => esc_html__("Text with Privacy Policy link", 'vapester'),
					"desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'vapester') ),
					"std"   => wp_kses_post( __( 'I agree that my submitted data is being collected and stored.', 'vapester') ),
					"type"  => "text"
				),

				'popup_info'             => array(
					'title'  => esc_html__( 'Popup settings', 'vapester' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'vapester' ),
					'type'   => 'info',
				),
				'popup_enable'      => array(
					'title'    => esc_html__( 'Enable popup', 'vapester' ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'popup_title' => array(
					"title" => esc_html__('Title', 'vapester'),
					"desc"  => wp_kses_data( __( 'To transfer to a new line of use "|"', 'vapester') ),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					"std"   => wp_kses_post( __( 'Are you of legal |smoking age', 'vapester') ),
					"type"  => "text"
				),
				'popup_description' => array(
					"title" => esc_html__( 'Description', 'vapester'),
					"desc"	=> wp_kses_post( __( 'To transfer to a new line of use "|"', 'vapester') ),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					"std"   => wp_kses_post( __( 'The products on this website are intended for adults only', 'vapester') ),
					"type"  => "text"
				),
				'popup_btn_accept_caption' => array(
					"title" => esc_html__("Accept Button", 'vapester'),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					"std"   => wp_kses_post( __( 'Yes, I’m of Legal Smoking Age', 'vapester') ),
					"type"  => "text"
				),
				'popup_btn_accept_style' => array(
					'title'      => esc_html__( 'Accept Button Style', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select button accept style', 'vapester') ),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					'std'        => 'default',
					'options'	 => ( vapester_exists_trx_addons() )
						? apply_filters('trx_addons_sc_type', trx_addons_components_get_allowed_layouts('sc', 'button'), 'trx_sc_button')
						: array( 'default' => esc_html__( 'Default', 'vapester' ) ),
					'type'       => 'select'
				),
				'popup_btn_reject_caption' => array(
					"title" => esc_html__("Reject Button", 'vapester'),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					"std"   => wp_kses_post( __( 'NO, I’m NOT of legal smoking age', 'vapester') ),
					"type"  => "text"
				),
				'popup_btn_reject_style' => array(
					'title'      => esc_html__( 'Reject Button Style', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select button reject style', 'vapester') ),
					'dependency' => array(
						'popup_enable' => array( '1' ),
					),
					'std'        => 'flat',
					'options'	 => ( vapester_exists_trx_addons() )
						? apply_filters('trx_addons_sc_type', trx_addons_components_get_allowed_layouts('sc', 'button'), 'trx_sc_button')
						: array( 'default' => esc_html__( 'Default', 'vapester' ) ),
					'type'       => 'select'
				),

				// 'Header'
				'header'                        => array(
					'title'    => esc_html__( 'Header', 'vapester' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 30,
					'type'     => 'section',
				),

				'header_style_info'             => array(
					'title' => esc_html__( 'Header style', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_type'                   => array(
					'title'    => esc_html__( 'Header style', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'std'      => 'default',
					'options'  => vapester_get_list_header_footer_types(),
					'type'     => VAPESTER_THEME_FREE || ! vapester_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'header_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'vapester' ),
					'desc'       => wp_kses_post( __( 'Select custom header from Layouts Builder', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'dependency' => array(
						'header_type' => array( 'custom' ),
					),
					'std'        => VAPESTER_THEME_FREE ? 'header-custom-elementor-header-default' : 'header-custom-header-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'header_position'               => array(
					'title'    => esc_html__( 'Header position', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select position to display the site header', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'type'     => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
				),
				
				'menu_info'                     => array(
					'title' => esc_html__( 'Main menu', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select main menu style, position and other parameters', 'vapester' ) ),
					'type'  => VAPESTER_THEME_FREE ? 'hidden' : 'info',
				),
				'menu_style'                    => array(
					'title'    => esc_html__( 'Menu position', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select position of the main menu', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'std'      => 'top',
					'options'  => array(
						'top'   => esc_html__( 'Top', 'vapester' ),
					),
					'type'     => 'hidden',
				),
				'menu_side_stretch'             => array(
					'title'      => esc_html__( 'Stretch sidemenu', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Stretch sidemenu to window height (if menu items number >= 5)', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 0,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_side_icons'               => array(
					'title'      => esc_html__( 'Iconed sidemenu', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'dependency' => array(
						'menu_style' => array( 'left', 'right' ),
					),
					'std'        => 1,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'menu_mobile_fullscreen'        => array(
					'title' => esc_html__( 'Mobile menu fullscreen', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'vapester' ) ),
					'std'   => 1,
					'type'  => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'header_mobile_info'            => array(
					'title'      => esc_html__( 'Mobile header', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Configure the mobile version of the header', 'vapester' ) ),
					'priority'   => 500,
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'info',
				),
				'header_mobile_enabled'         => array(
					'title'      => esc_html__( 'Enable the mobile header', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Use the mobile version of the header (if checked) or relayout the current header on mobile devices', 'vapester' ) ),
					'dependency' => array(
						'header_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_additional_info' => array(
					'title'      => esc_html__( 'Additional info', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Additional info to show at the top of the mobile header', 'vapester' ) ),
					'std'        => '',
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'refresh'    => false,
					'teeny'      => false,
					'rows'       => 20,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'text_editor',
				),
				'header_mobile_hide_info'       => array(
					'title'      => esc_html__( 'Hide additional info', 'vapester' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_logo'       => array(
					'title'      => esc_html__( 'Hide logo', 'vapester' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_login'      => array(
					'title'      => esc_html__( 'Hide login/logout', 'vapester' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_search'     => array(
					'title'      => esc_html__( 'Hide search', 'vapester' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'header_mobile_hide_cart'       => array(
					'title'      => esc_html__( 'Hide cart', 'vapester' ),
					'std'        => 0,
					'dependency' => array(
						'header_type'           => array( 'default' ),
						'header_mobile_enabled' => array( 1 ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),

				// 'Footer'
				'footer'                        => array(
					'title'    => esc_html__( 'Footer', 'vapester' ),
					'desc'     => wp_kses_data( $msg_override ),
					'priority' => 50,
					'type'     => 'section',
				),
				'footer_type'                   => array(
					'title'    => esc_html__( 'Footer style', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'vapester' ),
					),
					'std'      => 'default',
					'options'  => vapester_get_list_header_footer_types(),
					'type'     => VAPESTER_THEME_FREE || ! vapester_exists_trx_addons() ? 'hidden' : 'switch',
				),
				'footer_style'                  => array(
					'title'      => esc_html__( 'Select custom layout', 'vapester' ),
					'desc'       => wp_kses_post( __( 'Select custom footer from Layouts Builder', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'vapester' ),
					),
					'dependency' => array(
						'footer_type' => array( 'custom' ),
					),
					'std'        => VAPESTER_THEME_FREE ? 'footer-custom-elementor-footer-default' : 'footer-custom-footer-default',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_widgets'                => array(
					'title'      => esc_html__( 'Footer widgets', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'vapester' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 'footer_widgets',
					'options'    => array(),
					'type'       => 'select',
				),
				'footer_columns'                => array(
					'title'      => esc_html__( 'Footer columns', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'vapester' ),
					),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'footer_widgets' => array( '^hide' ),
					),
					'std'        => 0,
					'options'    => vapester_get_list_range( 0, 6 ),
					'type'       => 'select',
				),
				'footer_wide'                   => array(
					'title'      => esc_html__( 'Footer fullwidth', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Footer', 'vapester' ),
					),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_in_footer'                => array(
					'title'      => esc_html__( 'Show logo', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show logo in the footer', 'vapester' ) ),
					'refresh'    => false,
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'logo_footer'                   => array(
					'title'      => esc_html__( 'Logo for footer', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload site logo to display it in the footer', 'vapester' ) ),
					'dependency' => array(
						'footer_type'    => array( 'default' ),
						'logo_in_footer' => array( 1 ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'logo_footer_retina'            => array(
					'title'      => esc_html__( 'Logo for footer (Retina)', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'vapester' ) ),
					'dependency' => array(
						'footer_type'         => array( 'default' ),
						'logo_in_footer'      => array( 1 ),
						'logo_retina_enabled' => array( 1 ),
					),
					'std'        => '',
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'image',
				),
				'socials_in_footer'             => array(
					'title'      => esc_html__( 'Show social icons', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show social icons in the footer (under logo or footer widgets)', 'vapester' ) ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'std'        => 0,
					'type'       => ! vapester_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'copyright'                     => array(
					'title'      => esc_html__( 'Copyright', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'vapester' ) ),
					'translate'  => true,
					'std'        => esc_html__( 'Copyright &copy; {Y} by ThemeREX. All rights reserved.', 'vapester' ),
					'dependency' => array(
						'footer_type' => array( 'default' ),
					),
					'refresh'    => false,
					'type'       => 'textarea',
				),

				// 'Blog'
				'blog'                          => array(
					'title'    => esc_html__( 'Blog', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Options of the the blog archive', 'vapester' ) ),
					'priority' => 70,
					'type'     => 'panel',
				),

				// Blog - Posts page
				'blog_general'                  => array(
					'title' => esc_html__( 'Posts page', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Style and components of the blog archive', 'vapester' ) ),
					'type'  => 'section',
				),
				'blog_general_info'             => array(
					'title'  => esc_html__( 'Posts page settings', 'vapester' ),
					'desc'   => '',
					'qsetup' => esc_html__( 'General', 'vapester' ),
					'type'   => 'info',
				),
				'blog_style'                    => array(
					'title'      => esc_html__( 'Blog style', 'vapester' ),
					'desc'       => '',
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'std'        => 'excerpt',
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					'options'    => array(),
					'type'       => 'select',
				),
				'first_post_large'              => array(
					'title'      => esc_html__( 'First post large', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Make your first post stand out by making it bigger', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style'     => array( 'classic', 'masonry' ),
					),
					'std'        => 0,
					'type'       => 'checkbox',
				),
				'blog_content'                  => array(
					'title'      => esc_html__( 'Posts content', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Display either post excerpts or the full post content', 'vapester' ) ),
					'std'        => 'excerpt',
					'dependency' => array(
						'blog_style' => array( 'excerpt' ),
					),
					'options'    => array(
						'excerpt'  => esc_html__( 'Excerpt', 'vapester' ),
						'fullpost' => esc_html__( 'Full post', 'vapester' ),
					),
					'type'       => 'switch',
				),
				'excerpt_length'                => array(
					'title'      => esc_html__( 'Excerpt length', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged', 'vapester' ) ),
					'dependency' => array(
						'blog_style'   => array( 'excerpt' ),
						'blog_content' => array( 'excerpt' ),
					),
					'std'        => 60,
					'type'       => 'text',
				),
				'blog_columns'                  => array(
					'title'   => esc_html__( 'Blog columns', 'vapester' ),
					'desc'    => wp_kses_data( __( 'How many columns should be used in the blog archive (from 2 to 4)?', 'vapester' ) ),
					'std'     => 2,
					'options' => vapester_get_list_range( 2, 4 ),
					'type'    => 'hidden',      // This options is available and must be overriden only for some modes (for example, 'shop')
				),
				'post_type'                     => array(
					'title'      => esc_html__( 'Post type', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select post type to show in the blog archive', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'linked'     => 'parent_cat',
					'refresh'    => false,
					'hidden'     => true,
					'std'        => 'post',
					'options'    => array(),
					'type'       => 'select',
				),
				'parent_cat'                    => array(
					'title'      => esc_html__( 'Category to show', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select category to show in the blog archive', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'refresh'    => false,
					'hidden'     => true,
					'std'        => '0',
					'options'    => array(),
					'type'       => 'select',
				),
				'posts_per_page'                => array(
					'title'      => esc_html__( 'Posts per page', 'vapester' ),
					'desc'       => wp_kses_data( __( 'How many posts will be displayed on this page', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'hidden'     => true,
					'std'        => '',
					'type'       => 'text',
				),
				'blog_pagination'               => array(
					'title'      => esc_html__( 'Pagination style', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show Older/Newest posts or Page numbers below the posts list', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'std'        => 'pages',
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'options'    => array(
						'pages'    => esc_html__( 'Page numbers', 'vapester' ),
					),
					'type'       => 'hidden',
				),
				'blog_animation'                => array(
					'title'      => esc_html__( 'Animation for the posts', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'std'        => 'fadeIn',
					'options'    => array(),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'show_filters'                  => array(
					'title'      => esc_html__( 'Show filters', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show categories as tabs to filter posts', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style'     => array( 'portfolio', 'gallery' ),
					),
					'hidden'     => true,
					'std'        => 0,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),

				'blog_sidebar_info'             => array(
					'title' => esc_html__( 'Sidebar', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'sidebar_position_blog'         => array(
					'title'   => esc_html__( 'Sidebar position', 'vapester' ),
					'desc'    => wp_kses_data( __( 'Select position to show sidebar', 'vapester' ) ),
					'std'     => 'inherit',
					'options' => array(),
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					'type'    => 'switch',
				),
				'sidebar_widgets_blog'          => array(
					'title'      => esc_html__( 'Sidebar widgets', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select default widgets to show in the sidebar', 'vapester' ) ),
					'dependency' => array(
						'sidebar_position_blog' => array( 'left', 'right' ),
					),
					'std'        => 'sidebar_widgets',
					'options'    => array(),
					'qsetup'     => esc_html__( 'General', 'vapester' ),
					'type'       => 'select',
				),
				'expand_content_blog'           => array(
					'title'   => esc_html__( 'Expand content', 'vapester' ),
					'desc'    => wp_kses_data( __( 'Expand the content width if the sidebar is hidden', 'vapester' ) ),
					'refresh' => false,
					'std'     => 1,
					'type'    => 'checkbox',
				),

				'blog_advanced_info'            => array(
					'title' => esc_html__( 'Advanced settings', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'no_image'                      => array(
					'title' => esc_html__( 'Image placeholder', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select or upload an image used as placeholder for posts without a featured image', 'vapester' ) ),
					'std'   => '',
					'type'  => 'image',
				),
				'time_diff_before'              => array(
					'title' => esc_html__( 'Easy Readable Date Format', 'vapester' ),
					'desc'  => wp_kses_data( __( "For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'vapester' ) ),
					'std'   => 5,
					'type'  => 'text',
				),
				'sticky_style'                  => array(
					'title'   => esc_html__( 'Sticky posts style', 'vapester' ),
					'desc'    => wp_kses_data( __( 'Select style of the sticky posts output', 'vapester' ) ),
					'std'     => 'inherit',
					'options' => array(
						'inherit' => esc_html__( 'Decorated posts', 'vapester' ),
					),
					'type'    => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'meta_parts'                    => array(
					'title'      => esc_html__( 'Post meta', 'vapester' ),
					'desc'       => wp_kses_data( __( "If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Post counters and Share Links are available only if plugin ThemeREX Addons is active", 'vapester' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'date=1|author=1|categories=1|counters=1|share=0|edit=0',
					'options'    => vapester_get_list_meta_parts(),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters'                      => array(
					'title'      => esc_html__( 'Post counters', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if ThemeREX Addons is active', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'compare' => 'or',
						'#page_template' => array( 'blog.php' ),
						'.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|likes=1|views=0',
					'options'    => vapester_get_list_counters(),
					'type'       => VAPESTER_THEME_FREE || ! vapester_exists_trx_addons() ? 'hidden' : 'checklist',
				),

				// Blog - Single posts
				'blog_single'                   => array(
					'title' => esc_html__( 'Single posts', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Settings of the single post', 'vapester' ) ),
					'type'  => 'section',
				),
				'hide_featured_on_single'       => array(
					'title'    => esc_html__( 'Hide featured image on the single post', 'vapester' ),
					'desc'     => wp_kses_data( __( "Hide featured image on the single post's pages", 'vapester' ) ),
					'override' => array(
						'mode'    => 'page,post',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'std'      => 0,
					'type'     => 'checkbox',
				),
				'post_thumbnail_type'      => array(
					'title'      => esc_html__( 'Type of post thumbnail', 'vapester' ),
					'desc'       => wp_kses_data( __( "Select type of post thumbnail on the single post's pages", 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'        => 'default',
					'options'    => array(
						'fullwidth'   => esc_html__( 'Fullwidth', 'vapester' ),
						'boxed'       => esc_html__( 'Boxed', 'vapester' ),
						'default'     => esc_html__( 'Default', 'vapester' ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_position'          => array(
					'title'      => esc_html__( 'Post header position', 'vapester' ),
					'desc'       => wp_kses_data( __( "Select post header position on the single post's pages", 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'        => 'above',
					'options'    => array(
						'above'      => esc_html__( 'Above the post thumbnail', 'vapester' ),
						'under'      => esc_html__( 'Under the post thumbnail', 'vapester' ),
						'on_thumb'   => esc_html__( 'On the post thumbnail', 'vapester' ),
						'default'    => esc_html__( 'Default', 'vapester' ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'post_header_align'             => array(
					'title'      => esc_html__( 'Align of the post header', 'vapester' ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'post_header_position' => array( 'on_thumb' ),
					),
					'std'        => 'mc',
					'options'    => array(
						'ts' => esc_html__('Top Stick Out', 'vapester'),
						'tl' => esc_html__('Top Left', 'vapester'),
						'tc' => esc_html__('Top Center', 'vapester'),
						'tr' => esc_html__('Top Right', 'vapester'),
						'ml' => esc_html__('Middle Left', 'vapester'),
						'mc' => esc_html__('Middle Center', 'vapester'),
						'mr' => esc_html__('Middle Right', 'vapester'),
						'bl' => esc_html__('Bottom Left', 'vapester'),
						'bc' => esc_html__('Bottom Center', 'vapester'),
						'br' => esc_html__('Bottom Right', 'vapester'),
						'bs' => esc_html__('Bottom Stick Out', 'vapester'),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'hide_sidebar_on_single'        => array(
					'title' => esc_html__( 'Hide sidebar on the single post', 'vapester' ),
					'desc'  => wp_kses_data( __( "Hide sidebar on the single post's pages", 'vapester' ) ),
					'std'   => 0,
					'type'  => 'checkbox',
				),
				'show_post_excerpt'              => array(
					'title' => esc_html__( 'Show post excerpt', 'vapester' ),
					'desc'  => wp_kses_data( __( "Display post excerpt under post title.", 'vapester' ) ),
					'override' => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'dependency' => array(
						'hide_featured_on_single' => array( 0 ),
					),
					'std'   => 0,
					'type'  => 'checkbox',
				),
				'show_post_meta'                => array(
					'title' => esc_html__( 'Show post meta', 'vapester' ),
					'desc'  => wp_kses_data( __( "Display block with post's meta: date, categories, counters, etc.", 'vapester' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'meta_parts_post'               => array(
					'title'      => esc_html__( 'Post meta', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Meta parts for single posts. Post counters and Share Links are available only if plugin ThemeREX Addons is active', 'vapester' ) )
								. '<br>'
								. wp_kses_data( __( '<b>Tip:</b> Drag items to change their order.', 'vapester' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'date=1|author=1|categories=1|counters=1|share=0|edit=0',
					'options'    => vapester_get_list_meta_parts(),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checklist',
				),
				'counters_post'                 => array(
					'title'      => esc_html__( 'Post counters', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show only selected counters. Attention! Likes and Views are available only if plugin ThemeREX Addons is active', 'vapester' ) ),
					'dependency' => array(
						'show_post_meta' => array( 1 ),
					),
					'dir'        => 'vertical',
					'sortable'   => true,
					'std'        => 'comments=1|likes=1|views=0',
					'options'    => vapester_get_list_counters(),
					'type'       => VAPESTER_THEME_FREE || ! vapester_exists_trx_addons() ? 'hidden' : 'checklist',
				),
				'show_share_links'              => array(
					'title' => esc_html__( 'Show share links', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Display share links on the single post', 'vapester' ) ),
					'std'   => 1,
					'type'  => ! vapester_exists_trx_addons() ? 'hidden' : 'checkbox',
				),
				'show_author_info'              => array(
					'title' => esc_html__( 'Show author info', 'vapester' ),
					'desc'  => wp_kses_data( __( "Display block with information about post's author", 'vapester' ) ),
					'std'   => 1,
					'type'  => 'checkbox',
				),
				'blog_single_related_info'      => array(
					'title' => esc_html__( 'Related posts', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_related_posts'            => array(
					'title'    => esc_html__( 'Show related posts', 'vapester' ),
					'desc'     => wp_kses_data( __( "Show section 'Related posts' on the single post's pages", 'vapester' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Content', 'vapester' ),
					),
					'std'      => 1,
					'type'     => 'checkbox',
				),
				'related_posts'                 => array(
					'title'      => esc_html__( 'Related posts', 'vapester' ),
					'desc'       => wp_kses_data( __( 'How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => vapester_get_list_range( 1, 9 ),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'related_columns'               => array(
					'title'      => esc_html__( 'Related columns', 'vapester' ),
					'desc'       => wp_kses_data( __( 'How many columns should be used to output related posts in the single page (from 2 to 4)?', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => vapester_get_list_range( 1, 4 ),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_style'                 => array(
					'title'      => esc_html__( 'Related posts style', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select style of the related posts output', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 2,
					'options'    => vapester_get_list_styles( 1, 3 ),
					'type'       => 'hidden',
				),
				'related_slider'                => array(
					'title'      => esc_html__( 'Use slider layout', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Use slider layout in case related posts count is more than columns count', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 0,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'checkbox',
				),
				'related_slider_controls'       => array(
					'title'      => esc_html__( 'Slider controls', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show arrows in the slider', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'none',
					'options'    => array(
						'none'    => esc_html__('None', 'vapester'),
						'side'    => esc_html__('Side', 'vapester'),
						'outside' => esc_html__('Outside', 'vapester'),
						'top'     => esc_html__('Top', 'vapester'),
						'bottom'  => esc_html__('Bottom', 'vapester')
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
				),
				'related_slider_pagination'       => array(
					'title'      => esc_html__( 'Slider pagination', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Show bullets after the slider', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 'bottom',
					'options'    => array(
						'none'    => esc_html__('None', 'vapester'),
						'bottom'  => esc_html__('Bottom', 'vapester')
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
				),
				'related_slider_space'          => array(
					'title'      => esc_html__( 'Space', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Space between slides', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
						'related_slider' => array( 1 ),
					),
					'std'        => 30,
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'text',
				),
				'related_position'              => array(
					'title'      => esc_html__( 'Related posts position', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Select position to display the related posts', 'vapester' ) ),
					'dependency' => array(
						'show_related_posts' => array( 1 ),
					),
					'std'        => 'below_content',
					'options'    => array (
						'below_content' => esc_html__( 'After content', 'vapester' ),
						'below_page'    => esc_html__( 'After content & sidebar', 'vapester' ),
					),
					'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
				),
				'posts_navigation_info'      => array(
					'title' => esc_html__( 'Posts navigation', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'show_posts_navigation'		=> array(
					'title'    => esc_html__( 'Show posts navigation', 'vapester' ),
					'desc'     => wp_kses_data( __( "Show posts navigation on the single post's pages", 'vapester' ) ),
					'std'      => 0,
					'type'     => 'checkbox',
				),
			
				'posts_banners_info'      => array(
					'title' => esc_html__( 'Posts banners', 'vapester' ),
					'desc'  => '',
					'type'  => 'info',
				),
				'header_banner_link'     => array(
					'title' => esc_html__( 'Header banner link', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'   => '',
					'type'  => 'text',
				),
				'header_banner_img'     => array(
					'title' => esc_html__( 'Header banner image', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'header_banner_code'     => array(
					'title'      => esc_html__( 'Header banner code', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'textarea',
				),
				'footer_banner_link'     => array(
					'title' => esc_html__( 'Footer banner link', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'   => '',
					'type'  => 'text',
				),
				'footer_banner_img'     => array(
					'title' => esc_html__( 'Footer banner image', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'footer_banner_code'     => array(
					'title'      => esc_html__( 'Footer banner code', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'textarea',
				),
				'sidebar_banner_link'     => array(
					'title' => esc_html__( 'Sidebar banner link', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'   => '',
					'type'  => 'text',
				),
				'sidebar_banner_img'     => array(
					'title' => esc_html__( 'Sidebar banner image', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'sidebar_banner_code'     => array(
					'title'      => esc_html__( 'Sidebar banner code', 'vapester' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'textarea',
				),
				'background_banner_link'     => array(
					'title' => esc_html__( "Post's background banner link", 'vapester' ),
					'desc'  => wp_kses_data( __( 'Insert URL of the banner', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'   => '',
					'type'  => 'text',
				),
				'background_banner_img'     => array(
					'title' => esc_html__( "Post's background banner image", 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select image to display at the backgound', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'type'       => 'image',
				),
				'background_banner_code'     => array(
					'title'      => esc_html__( "Post's background banner code", 'vapester' ),
					'desc'       => wp_kses_data( __( 'Embed html code', 'vapester' ) ),
					'override'   => array(
						'mode'    => 'post',
						'section' => esc_html__( 'Banners', 'vapester' ),
					),
					'std'        => '',
					'allow_html' => true,
					'type'       => 'textarea',
				),
				'blog_end'                      => array(
					'type' => 'panel_end',
				),

				// 'Colors'
				'panel_colors'                  => array(
					'title'    => esc_html__( 'Colors', 'vapester' ),
					'desc'     => '',
					'priority' => 300,
					'type'     => 'section',
				),

				'color_schemes_info'            => array(
					'title'  => esc_html__( 'Color schemes', 'vapester' ),
					'desc'   => wp_kses_data( __( 'Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'vapester' ) ),
					'hidden' => $hide_schemes,
					'type'   => 'info',
				),
				'color_scheme'                  => array(
					'title'    => esc_html__( 'Site Color Scheme', 'vapester' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'vapester' ),
					),
					'std'      => 'default',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'header_scheme'                 => array(
					'title'    => esc_html__( 'Header Color Scheme', 'vapester' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'vapester' ),
					),
					'std'      => 'dark',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				
				'sidebar_scheme'                => array(
					'title'    => esc_html__( 'Sidebar Color Scheme', 'vapester' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'vapester' ),
					),
					'std'      => 'inherit',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),
				'footer_scheme'                 => array(
					'title'    => esc_html__( 'Footer Color Scheme', 'vapester' ),
					'desc'     => '',
					'override' => array(
						'mode'    => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
						'section' => esc_html__( 'Colors', 'vapester' ),
					),
					'std'      => 'dark',
					'options'  => array(),
					'refresh'  => false,
					'type'     => $hide_schemes ? 'hidden' : 'switch',
				),

				'color_scheme_editor_info'      => array(
					'title' => esc_html__( 'Color scheme editor', 'vapester' ),
					'desc'  => wp_kses_data( __( 'Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'vapester' ) ),
					'type'  => 'info',
				),
				'scheme_storage'                => array(
					'title'       => esc_html__( 'Color scheme editor', 'vapester' ),
					'desc'        => '',
					'std'         => '$vapester_get_scheme_storage',
					'refresh'     => false,
					'colorpicker' => 'tiny',
					'type'        => 'scheme_editor',
				),

				// Internal options.
				// Attention! Don't change any options in the section below!
				// Use huge priority to call render this elements after all options!
				'reset_options'                 => array(
					'title'    => '',
					'desc'     => '',
					'std'      => '0',
					'priority' => 10000,
					'type'     => 'hidden',
				),

				'last_option'                   => array(     // Need to manually call action to include Tiny MCE scripts
					'title' => '',
					'desc'  => '',
					'std'   => 1,
					'type'  => 'hidden',
				),

			)
		);

		// Prepare panel 'Fonts'
		// -------------------------------------------------------------
		$fonts = array(

			// 'Fonts'
			'fonts'             => array(
				'title'    => esc_html__( 'Typography', 'vapester' ),
				'desc'     => '',
				'priority' => 200,
				'type'     => 'panel',
			),

			// Fonts - Load_fonts
			'load_fonts'        => array(
				'title' => esc_html__( 'Load fonts', 'vapester' ),
				'desc'  => wp_kses_data( __( 'Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'vapester' ) )
						. '<br>'
						. wp_kses_data( __( 'Attention! Press "Refresh" button to reload preview area after the all fonts are changed', 'vapester' ) ),
				'type'  => 'section',
			),
			'load_fonts_subset' => array(
				'title'   => esc_html__( 'Google fonts subsets', 'vapester' ),
				'desc'    => wp_kses_data( __( 'Specify comma separated list of the subsets which will be load from Google fonts', 'vapester' ) )
						. '<br>'
						. wp_kses_data( __( 'Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'vapester' ) ),
				'class'   => 'vapester_column-1_3 vapester_new_row',
				'refresh' => false,
				'std'     => '$vapester_get_load_fonts_subset',
				'type'    => 'text',
			),
		);

		for ( $i = 1; $i <= vapester_get_theme_setting( 'max_load_fonts' ); $i++ ) {
			if ( vapester_get_value_gp( 'page' ) != 'theme_options' ) {
				$fonts[ "load_fonts-{$i}-info" ] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					'title' => esc_html( sprintf( __( 'Font %s', 'vapester' ), $i ) ),
					'desc'  => '',
					'type'  => 'info',
				);
			}
			$fonts[ "load_fonts-{$i}-name" ]   = array(
				'title'   => esc_html__( 'Font name', 'vapester' ),
				'desc'    => '',
				'class'   => 'vapester_column-1_3 vapester_new_row',
				'refresh' => false,
				'std'     => '$vapester_get_load_fonts_option',
				'type'    => 'text',
			);
			$fonts[ "load_fonts-{$i}-family" ] = array(
				'title'   => esc_html__( 'Font family', 'vapester' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Select font family to use it if font above is not available', 'vapester' ) )
							: '',
				'class'   => 'vapester_column-1_3',
				'refresh' => false,
				'std'     => '$vapester_get_load_fonts_option',
				'options' => array(
					'inherit'    => esc_html__( 'Inherit', 'vapester' ),
					'serif'      => esc_html__( 'serif', 'vapester' ),
					'sans-serif' => esc_html__( 'sans-serif', 'vapester' ),
					'monospace'  => esc_html__( 'monospace', 'vapester' ),
					'cursive'    => esc_html__( 'cursive', 'vapester' ),
					'fantasy'    => esc_html__( 'fantasy', 'vapester' ),
				),
				'type'    => 'select',
			);
			$fonts[ "load_fonts-{$i}-styles" ] = array(
				'title'   => esc_html__( 'Font styles', 'vapester' ),
				'desc'    => 1 == $i
							? wp_kses_data( __( 'Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'vapester' ) )
								. '<br>'
								. wp_kses_data( __( 'Attention! Each weight and style increase download size! Specify only used weights and styles.', 'vapester' ) )
							: '',
				'class'   => 'vapester_column-1_3',
				'refresh' => false,
				'std'     => '$vapester_get_load_fonts_option',
				'type'    => 'text',
			);
		}
		$fonts['load_fonts_end'] = array(
			'type' => 'section_end',
		);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = vapester_get_theme_fonts();
		foreach ( $theme_fonts as $tag => $v ) {
			$fonts[ "{$tag}_section" ] = array(
				'title' => ! empty( $v['title'] )
								? $v['title']
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html( sprintf( __( '%s settings', 'vapester' ), $tag ) ),
				'desc'  => ! empty( $v['description'] )
								? $v['description']
								// Translators: Add tag's name to make description
								: wp_kses_post( sprintf( __( 'Font settings of the "%s" tag.', 'vapester' ), $tag ) ),
				'type'  => 'section',
			);

			foreach ( $v as $css_prop => $css_value ) {
				if ( in_array( $css_prop, array( 'title', 'description' ) ) ) {
					continue;
				}
				$options    = '';
				$type       = 'text';
				$load_order = 1;
				$title      = ucfirst( str_replace( '-', ' ', $css_prop ) );
				if ( 'font-family' == $css_prop ) {
					$type       = 'select';
					$options    = array();
					$load_order = 2;        // Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} elseif ( 'font-weight' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'vapester' ),
						'100'     => esc_html__( '100 (Light)', 'vapester' ),
						'200'     => esc_html__( '200 (Light)', 'vapester' ),
						'300'     => esc_html__( '300 (Thin)', 'vapester' ),
						'400'     => esc_html__( '400 (Normal)', 'vapester' ),
						'500'     => esc_html__( '500 (Semibold)', 'vapester' ),
						'600'     => esc_html__( '600 (Semibold)', 'vapester' ),
						'700'     => esc_html__( '700 (Bold)', 'vapester' ),
						'800'     => esc_html__( '800 (Black)', 'vapester' ),
						'900'     => esc_html__( '900 (Black)', 'vapester' ),
					);
				} elseif ( 'font-style' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit' => esc_html__( 'Inherit', 'vapester' ),
						'normal'  => esc_html__( 'Normal', 'vapester' ),
						'italic'  => esc_html__( 'Italic', 'vapester' ),
					);
				} elseif ( 'text-decoration' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'      => esc_html__( 'Inherit', 'vapester' ),
						'none'         => esc_html__( 'None', 'vapester' ),
						'underline'    => esc_html__( 'Underline', 'vapester' ),
						'overline'     => esc_html__( 'Overline', 'vapester' ),
						'line-through' => esc_html__( 'Line-through', 'vapester' ),
					);
				} elseif ( 'text-transform' == $css_prop ) {
					$type    = 'select';
					$options = array(
						'inherit'    => esc_html__( 'Inherit', 'vapester' ),
						'none'       => esc_html__( 'None', 'vapester' ),
						'uppercase'  => esc_html__( 'Uppercase', 'vapester' ),
						'lowercase'  => esc_html__( 'Lowercase', 'vapester' ),
						'capitalize' => esc_html__( 'Capitalize', 'vapester' ),
					);
				}
				$fonts[ "{$tag}_{$css_prop}" ] = array(
					'title'      => $title,
					'desc'       => '',
					'class'      => 'vapester_column-1_5',
					'refresh'    => false,
					'load_order' => $load_order,
					'std'        => '$vapester_get_theme_fonts_option',
					'options'    => $options,
					'type'       => $type,
				);
			}

			$fonts[ "{$tag}_section_end" ] = array(
				'type' => 'section_end',
			);
		}

		$fonts['fonts_end'] = array(
			'type' => 'panel_end',
		);

		// Add fonts parameters to Theme Options
		vapester_storage_set_array_before( 'options', 'panel_colors', $fonts );

		// Add Header Video if WP version < 4.7
		// -----------------------------------------------------
		if ( ! function_exists( 'get_header_video_url' ) ) {
			vapester_storage_set_array_after(
				'options', 'header_image_override', 'header_video', array(
					'title'    => esc_html__( 'Header video', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select video to use it as background for the header', 'vapester' ) ),
					'override' => array(
						'mode'    => 'page',
						'section' => esc_html__( 'Header', 'vapester' ),
					),
					'std'      => '',
					'type'     => 'video',
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		// ------------------------------------------------------
		if ( ! function_exists( 'the_custom_logo' ) || ( isset( $_REQUEST['page'] ) && in_array( $_REQUEST['page'], array( 'theme_options', 'trx_addons_theme_panel' ) ) ) ) {
			vapester_storage_set_array_before(
				'options', 'logo_retina', function_exists( 'the_custom_logo' ) ? 'custom_logo' : 'logo', array(
					'title'    => esc_html__( 'Logo', 'vapester' ),
					'desc'     => wp_kses_data( __( 'Select or upload the site logo', 'vapester' ) ),
					'class'    => 'vapester_column-1_2 vapester_new_row',
					'priority' => 60,
					'std'      => '',
					'qsetup'   => esc_html__( 'General', 'vapester' ),
					'type'     => 'image',
				)
			);
		}

	}
}


// Returns a list of options that can be overridden for CPT
if ( ! function_exists( 'vapester_options_get_list_cpt_options' ) ) {
	function vapester_options_get_list_cpt_options( $cpt, $title = '' ) {
		if ( empty( $title ) ) {
			$title = ucfirst( $cpt );
		}
		return array(
			"header_info_{$cpt}"            => array(
				'title' => esc_html__( 'Header', 'vapester' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"header_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Header style', 'vapester' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'vapester' ) ),
				'std'     => 'inherit',
				'options' => vapester_get_list_header_footer_types( true ),
				'type'    => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'vapester' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select custom layout to display the site header on the %s pages', 'vapester' ), $title ) ),
				'dependency' => array(
					"header_type_{$cpt}" => array( 'custom' ),
				),
				'std'        => 'inherit',
				'options'    => array(),
				'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
			),
			"header_position_{$cpt}"        => array(
				'title'   => esc_html__( 'Header position', 'vapester' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to display the site header on the %s pages', 'vapester' ), $title ) ),
				'std'     => 'inherit',
				'options' => array(),
				'type'    => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
			),
			"header_image_override_{$cpt}"  => array(
				'title'   => esc_html__( 'Header image override', 'vapester' ),
				'desc'    => wp_kses_data( __( "Allow override the header image with the post's featured image", 'vapester' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'vapester' ),
					1         => esc_html__( 'Yes', 'vapester' ),
					0         => esc_html__( 'No', 'vapester' ),
				),
				'type'    => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
			),
			

			"sidebar_info_{$cpt}"           => array(
				'title' => esc_html__( 'Sidebar', 'vapester' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"sidebar_position_{$cpt}"       => array(
				'title'   => esc_html__( 'Sidebar position', 'vapester' ),
				// Translators: Add CPT name to the description
				'desc'    => wp_kses_data( sprintf( __( 'Select position to show sidebar on the %s pages', 'vapester' ), $title ) ),
				'std'     => 'right',
				'options' => array(),
				'type'    => 'switch',
			),
			"sidebar_widgets_{$cpt}"        => array(
				'title'      => esc_html__( 'Sidebar widgets', 'vapester' ),
				// Translators: Add CPT name to the description
				'desc'       => wp_kses_data( sprintf( __( 'Select sidebar to show on the %s pages', 'vapester' ), $title ) ),
				'dependency' => array(
					"sidebar_position_{$cpt}" => array( 'left', 'right' ),
				),
				'std'        => 'hide',
				'options'    => array(),
				'type'       => 'select',
			),
			"hide_sidebar_on_single_{$cpt}" => array(
				'title'   => esc_html__( 'Hide sidebar on the single pages', 'vapester' ),
				'desc'    => wp_kses_data( __( 'Hide sidebar on the single page', 'vapester' ) ),
				'std'     => 'inherit',
				'options' => array(
					'inherit' => esc_html__( 'Inherit', 'vapester' ),
					1         => esc_html__( 'Hide', 'vapester' ),
					0         => esc_html__( 'Show', 'vapester' ),
				),
				'type'    => 'switch',
			),

			"footer_info_{$cpt}"            => array(
				'title' => esc_html__( 'Footer', 'vapester' ),
				'desc'  => '',
				'type'  => 'info',
			),
			"footer_type_{$cpt}"            => array(
				'title'   => esc_html__( 'Footer style', 'vapester' ),
				'desc'    => wp_kses_data( __( 'Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'vapester' ) ),
				'std'     => 'inherit',
				'options' => vapester_get_list_header_footer_types( true ),
				'type'    => VAPESTER_THEME_FREE ? 'hidden' : 'switch',
			),
			"footer_style_{$cpt}"           => array(
				'title'      => esc_html__( 'Select custom layout', 'vapester' ),
				'desc'       => wp_kses_data( __( 'Select custom layout to display the site footer', 'vapester' ) ),
				'std'        => 'inherit',
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'custom' ),
				),
				'options'    => array(),
				'type'       => VAPESTER_THEME_FREE ? 'hidden' : 'select',
			),
			"footer_widgets_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer widgets', 'vapester' ),
				'desc'       => wp_kses_data( __( 'Select set of widgets to show in the footer', 'vapester' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 'footer_widgets',
				'options'    => array(),
				'type'       => 'select',
			),
			"footer_columns_{$cpt}"         => array(
				'title'      => esc_html__( 'Footer columns', 'vapester' ),
				'desc'       => wp_kses_data( __( 'Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'vapester' ) ),
				'dependency' => array(
					"footer_type_{$cpt}"    => array( 'default' ),
					"footer_widgets_{$cpt}" => array( '^hide' ),
				),
				'std'        => 0,
				'options'    => vapester_get_list_range( 0, 6 ),
				'type'       => 'select',
			),
			"footer_wide_{$cpt}"            => array(
				'title'      => esc_html__( 'Footer fullwidth', 'vapester' ),
				'desc'       => wp_kses_data( __( 'Do you want to stretch the footer to the entire window width?', 'vapester' ) ),
				'dependency' => array(
					"footer_type_{$cpt}" => array( 'default' ),
				),
				'std'        => 0,
				'type'       => 'checkbox',
			),
		);
	}
}


// Return lists with choises when its need in the admin mode
if ( ! function_exists( 'vapester_options_get_list_choises' ) ) {
	add_filter( 'vapester_filter_options_get_list_choises', 'vapester_options_get_list_choises', 10, 2 );
	function vapester_options_get_list_choises( $list, $id ) {
		if ( is_array( $list ) && count( $list ) == 0 ) {
			if ( strpos( $id, 'header_style' ) === 0 ) {
				$list = vapester_get_list_header_styles( strpos( $id, 'header_style_' ) === 0 );
			} elseif ( strpos( $id, 'header_position' ) === 0 ) {
				$list = vapester_get_list_header_positions( strpos( $id, 'header_position_' ) === 0 );
			} elseif ( strpos( $id, 'header_widgets' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'header_widgets_' ) === 0, true );
			} elseif ( strpos( $id, '_scheme' ) > 0 ) {
				$list = vapester_get_list_schemes( 'color_scheme' != $id );
			} elseif ( strpos( $id, 'sidebar_widgets' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'sidebar_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'sidebar_position' ) === 0 ) {
				$list = vapester_get_list_sidebars_positions( strpos( $id, 'sidebar_position_' ) === 0 );
			} elseif ( strpos( $id, 'widgets_above_page' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'widgets_above_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_above_content' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'widgets_above_content_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_page' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'widgets_below_page_' ) === 0, true );
			} elseif ( strpos( $id, 'widgets_below_content' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'widgets_below_content_' ) === 0, true );
			} elseif ( strpos( $id, 'footer_style' ) === 0 ) {
				$list = vapester_get_list_footer_styles( strpos( $id, 'footer_style_' ) === 0 );
			} elseif ( strpos( $id, 'footer_widgets' ) === 0 ) {
				$list = vapester_get_list_sidebars( strpos( $id, 'footer_widgets_' ) === 0, true );
			} elseif ( strpos( $id, 'blog_style' ) === 0 ) {
				$list = vapester_get_list_blog_styles( strpos( $id, 'blog_style_' ) === 0 );
			} elseif ( strpos( $id, 'post_type' ) === 0 ) {
				$list = vapester_get_list_posts_types();
			} elseif ( strpos( $id, 'parent_cat' ) === 0 ) {
				$list = vapester_array_merge( array( 0 => esc_html__( '- Select category -', 'vapester' ) ), vapester_get_list_categories() );
			} elseif ( strpos( $id, 'blog_animation' ) === 0 ) {
				$list = vapester_get_list_animations_in();
			} elseif ( 'color_scheme_editor' == $id ) {
				$list = vapester_get_list_schemes();
			} elseif ( strpos( $id, '_font-family' ) > 0 ) {
				$list = vapester_get_list_load_fonts( true );
			}
		}
		return $list;
	}
}
/* Action color */
if (!function_exists('trx_addons_sc_action_add_in_elementor')) {
	add_action( 'elementor/widgets/widgets_registered', 'trx_addons_sc_action_add_in_elementor' );
	function trx_addons_sc_action_add_in_elementor() {
		
		if (!class_exists('TRX_Addons_Elementor_Widget')) return;	

		class TRX_Addons_Elementor_Widget_Action extends TRX_Addons_Elementor_Widget {

			/**
			 * Widget base constructor.
			 *
			 * Initializing the widget base class.
			 *
			 * @since 1.6.41
			 * @access public
			 *
			 * @param array      $data Widget data. Default is an empty array.
			 * @param array|null $args Optional. Widget default arguments. Default is null.
			 */
			public function __construct( $data = [], $args = null ) {
				parent::__construct( $data, $args );
				$this->add_plain_params([
					'height' => 'size+unit'
				]);
			}

			/**
			 * Retrieve widget name.
			 *
			 * @since 1.6.41
			 * @access public
			 *
			 * @return string Widget name.
			 */
			public function get_name() {
				return 'trx_sc_action';
			}

			/**
			 * Retrieve widget title.
			 *
			 * @since 1.6.41
			 * @access public
			 *
			 * @return string Widget title.
			 */
			public function get_title() {
				return esc_html__( 'Actions', 'vapester' );
			}

			/**
			 * Retrieve widget icon.
			 *
			 * @since 1.6.41
			 * @access public
			 *
			 * @return string Widget icon.
			 */
			public function get_icon() {
				return 'eicon-call-to-action';
			}

			/**
			 * Retrieve the list of categories the widget belongs to.
			 *
			 * Used to determine where to display the widget in the editor.
			 *
			 * @since 1.6.41
			 * @access public
			 *
			 * @return array Widget categories.
			 */
			public function get_categories() {
				return ['trx_addons-elements'];
			}

			/**
			 * Register widget controls.
			 *
			 * Adds different input fields to allow the user to change and customize the widget settings.
			 *
			 * @since 1.6.41
			 * @access protected
			 */
			protected function _register_controls() {
				$this->start_controls_section(
					'section_sc_action',
					[
						'label' => esc_html__( 'Actions', 'vapester' ),
					]
				);

				$this->add_control(
					'type',
					[
						'label' => esc_html__( 'Layout', 'vapester' ),
						'label_block' => false,
						'type' => \Elementor\Controls_Manager::SELECT,
						'options' => apply_filters('trx_addons_sc_type', trx_addons_components_get_allowed_layouts('sc', 'action'), 'trx_sc_action'),
						'default' => 'default'
					]
				);

				$this->add_control(
					'columns',
					[
						'label' => esc_html__( 'Columns', 'vapester' ),
						'description' => wp_kses_data( __("Specify number of columns for actions. If empty or 0 - auto detect by items number", 'vapester') ),
						'type' => \Elementor\Controls_Manager::SLIDER,
						'default' => [
							'size' => 0
						],
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 12
							]
						]
					]
				);

				$this->add_control(
					'full_height',
					[
						'label' => esc_html__( 'Full height', 'vapester' ),
						'label_block' => false,
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label_off' => esc_html__( 'Off', 'vapester' ),
						'label_on' => esc_html__( 'On', 'vapester' ),
						'return_value' => '1'
					]
				);
				
				$this->add_control(
					'actions',
					[
						'label' => '',
						'type' => \Elementor\Controls_Manager::REPEATER,
						'default' => apply_filters('trx_addons_sc_param_group_value', [
							[
								'position' => 'mc',
								'height' => ['size' => 0, 'unit' => 'px'],
								'title' => esc_html__( 'First action', 'vapester' ),
								'subtitle' => $this->get_default_subtitle(),
								'date' => '',
								'info' => '',
								'description' => $this->get_default_description(),
								'link' => ['url' => ''],
								'link_text' => '',
								'icon' => 'icon-star-empty',
								'image' => ['url' => ''],
								'color' => '',
								'bg_color' => '#aa0000',
								'bg_image' => ['url' => ''],
							],
							[
								'position' => 'mc',
								'height' => ['size' => 0, 'unit' => 'px'],
								'title' => esc_html__( 'Second action', 'vapester' ),
								'subtitle' => $this->get_default_subtitle(),
								'date' => '',
								'info' => '',
								'description' => $this->get_default_description(),
								'link' => ['url' => ''],
								'link_text' => '',
								'icon' => 'icon-heart-empty',
								'image' => ['url' => ''],
								'color' => '',
								'bg_color' => '#00aa00',
								'bg_image' => ['url' => ''],
							],
							[
								'position' => 'mc',
								'height' => ['size' => 0, 'unit' => 'px'],
								'title' => esc_html__( 'Third action', 'vapester' ),
								'subtitle' => $this->get_default_subtitle(),
								'date' => '',
								'info' => '',
								'description' => $this->get_default_description(),
								'link' => ['url' => ''],
								'link_text' => '',
								'icon' => 'icon-clock-empty',
								'image' => ['url' => ''],
								'color' => '',
								'bg_color' => '#0000aa',
								'bg_image' => ['url' => ''],
							]
						], 'trx_sc_action'),
						'fields' => apply_filters('trx_addons_sc_param_group_params', array_merge(
							[
								[
									'name' => 'position',
									'label' => esc_html__( 'Position', 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::SELECT,
									'options' => trx_addons_get_list_sc_positions(),
									'default' => 'mc',
									// Not work in the group params - hide always!
								
								],
								[
									'name' => 'height',
									'label' => esc_html__( 'Height', 'vapester' ),
									'type' => \Elementor\Controls_Manager::SLIDER,
									'default' => [
										'size' => 0,
										'unit' => 'px'
									],
									'range' => [
										'px' => [
											'min' => 0,
											'max' => 1000
										],
										'em' => [
											'min' => 0,
											'max' => 100,
											'step' => 0.1
										],
									],
									'size_units' => [ 'px', 'em' ]
								],
								[
									'name' => 'title',
									'label' => esc_html__( 'Title', 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::TEXT,
									'placeholder' => esc_html__( "Item's title", 'vapester' ),
									'default' => ''
								],
								[
									'name' => 'title_color',
									'label' => esc_html__( 'Background Color Title', 'vapester' ),
									'type' => \Elementor\Controls_Manager::COLOR,
									'default' => '',
									'scheme' => [
										'type' => \Elementor\Scheme_Color::get_type(),
										'value' => \Elementor\Scheme_Color::COLOR_1,
									],
								],
								[
									'name' => 'subtitle',
									'label' => esc_html__( 'Subtitle', 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::TEXT,
									'placeholder' => esc_html__( "Item's subtitle", 'vapester' ),
									'default' => ''
								],
								[
									'name' => 'date',
									'label' => esc_html__( 'Date', 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::TEXT,
									'placeholder' => esc_html__( "Event's date", 'vapester' ),
									'default' => '',
									'condition' => ['type' => 'event']
								],
								[
									'name' => 'info',
									'label' => esc_html__( 'Additional info', 'vapester' ),
									'label_block' => true,
									'type' => \Elementor\Controls_Manager::TEXT,
									'placeholder' => esc_html__( "Additional info about this item", 'vapester' ),
									'default' => ''
								],
								[
									'name' => 'description',
									'label' => esc_html__( 'Description', 'vapester' ),
									'label_block' => true,
									'type' => \Elementor\Controls_Manager::TEXTAREA,
									'placeholder' => esc_html__( "Short description of this item", 'vapester' ),
									'default' => '',
									'separator' => 'none',
									'rows' => 10,
									'show_label' => false,
								],
								[
									'name' => 'link',
									'label' => esc_html__( 'Link', 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::URL,
									'default' => ['url' => ''],
									'placeholder' => esc_html__( 'http://your-link.com', 'vapester' ),
								],
								[
									'name' => 'link_text',
									'label' => esc_html__( "Link's text", 'vapester' ),
									'label_block' => false,
									'type' => \Elementor\Controls_Manager::TEXT,
									'placeholder' => esc_html__( "Link's text", 'vapester' ),
									'default' => ''
								],
							],
							$this->get_icon_param(),
							[
								[
									'name' => 'image',
									'label' => esc_html__( 'Image', 'vapester' ),
									'type' => \Elementor\Controls_Manager::MEDIA,
									'default' => [
										'url' => '',
									],
								],
								[
									'name' => 'color',
									'label' => esc_html__( 'Color', 'vapester' ),
									'type' => \Elementor\Controls_Manager::COLOR,
									'default' => '',
									'scheme' => [
										'type' => \Elementor\Scheme_Color::get_type(),
										'value' => \Elementor\Scheme_Color::COLOR_1,
									],
								],
								[
									'name' => 'bg_color',
									'label' => esc_html__( 'Background Color', 'vapester' ),
									'type' => \Elementor\Controls_Manager::COLOR,
									'default' => '',
									'scheme' => [
										'type' => \Elementor\Scheme_Color::get_type(),
										'value' => \Elementor\Scheme_Color::COLOR_2,
									],
								],
								[
									'name' => 'bg_image',
									'label' => esc_html__( 'Background Image', 'vapester' ),
									'type' => \Elementor\Controls_Manager::MEDIA,
									'default' => [
										'url' => '',
									],
								]
							]),
							'trx_sc_action'),
						'title_field' => '{{{ title }}}',
					]
				);

				$this->end_controls_section();

				$this->add_slider_param();
				$this->add_title_param();
			}

			/**
			 * Render widget's template for the editor.
			 *
			 * Written as a Backbone JavaScript template and used to generate the live preview.
			 *
			 * @since 1.6.41
			 * @access protected
			 */
			protected function _content_template() {
				trx_addons_get_template_part(TRX_ADDONS_PLUGIN_SHORTCODES . "action/tpe.action.php",
 										'trx_addons_args_sc_action',
										array('element' => $this)
									);
			}
		}
		
		// Register widget
		\Elementor\Plugin::$instance->widgets_manager->register_widget_type( new TRX_Addons_Elementor_Widget_Action() );
	}
}

/* Add new types shortcodes */
if ( ! function_exists( 'vapester_trx_addons_sc_list' ) ) {
	add_filter('trx_addons_sc_list', 'vapester_trx_addons_sc_list', 10, 1);
	function vapester_trx_addons_sc_list( $settings ) {
		/* New buttons */
		$settings['button']['layouts_sc'] = array_slice($settings['button']['layouts_sc'], 0, 1, true)
		+ array(
	 		"inverse" => esc_html__('Inverse', 'vapester'),
	 		"flat" => esc_html__('Flat', 'vapester'),
			"flat_inverse" => esc_html__('Flat Inverse', 'vapester'),
		)
		+ array_slice($settings['button']['layouts_sc'], 1, count($settings['button']['layouts_sc'])-1, true);

		/* New action */
		$settings['action']['layouts_sc']['contacts'] = esc_html__('Contacts', 'vapester');
		$settings['action']['layouts_sc']['city'] = esc_html__('City', 'vapester');
		$settings['action']['layouts_sc']['date'] = esc_html__('Date', 'vapester');

		/* New blogger */
		$settings['blogger']['layouts_sc']['products'] = esc_html__('Products', 'vapester');

		return $settings;
	}
}

if ( ! function_exists( 'vapeser_trx_addons_sc_type' ) ) {
	add_filter('trx_addons_sc_type', 'vapeser_trx_addons_sc_type', 10, 2);
	function vapeser_trx_addons_sc_type( $settings, $shortcode ) {
		if ( $shortcode == 'trx_sc_testimonials' ) {
			$settings['flip'] = esc_html__('Flip', 'vapester');
			$settings['grid'] = esc_html__('Grid', 'vapester');
		}
		return $settings;
	}
}




// Change image size
if (!function_exists('trx_addons_filter_thumb_size')) {
	add_filter( 'trx_addons_filter_thumb_size', 'trx_addons_filter_thumb_size', 100, 2);
	function trx_addons_filter_thumb_size( $size, $shortcode ) {
		if ( $shortcode == 'team-featured' ) {
			return trx_addons_get_thumb_size('medium');
		}
		if ( $shortcode == 'team-default' ) {
			return trx_addons_get_thumb_size('team');
		}
		return $size;
	}
}

// Add popup support
if (!function_exists('vapester_popup_support')) {
	add_action( 'wp_footer', 'vapester_popup_support', 30 );
	function vapester_popup_support() {
		if ( !(isset($_COOKIE['legal']) && $_COOKIE['legal']) && vapester_get_theme_option( 'popup_enable' ) && !(current_user_can('editor') || current_user_can('administrator')) ) { ?>
			<div class="legal">
				<div class="legal-overlay"></div>
				<div class="sc_item_title sc_item_title_style_accent legal-title">
					<?php $title = explode('|', vapester_get_theme_option( 'popup_title' ) );
					foreach ($title as $str) { ?>
						<span><?php echo trim($str); ?></span>
					<?php } ?>
				</div>
				<div class="legal-description">
					<?php $description = explode('|', vapester_get_theme_option( 'popup_description' ) );
					foreach ($description as $str) { ?>
						<span><?php echo trim($str); ?></span>
					<?php } ?>
				</div>
				<div class="legal-buttons">
					<a href="#" class="sc_button sc_button_<?php echo esc_attr( vapester_get_theme_option( 'popup_btn_accept_style' ) ) ?> legal-agree"><?php echo esc_attr( vapester_get_theme_option( 'popup_btn_accept_caption' ) ) ?></a>
					<a href="/" class="sc_button sc_button_<?php echo esc_attr( vapester_get_theme_option( 'popup_btn_reject_style' ) ) ?> legal-disable"><?php echo esc_attr( vapester_get_theme_option( 'popup_btn_reject_caption' ) ) ?></a>
				</div>
			</div>
		<?php }
	}
}