<?php 
if ( 'product' == get_post_type(get_the_ID()) ) {
	global $product;
	if ($args['slider']) {
		?><div class="slider-slide swiper-slide"><?php
	} else if ($args['columns'] > 1) {
		?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
	} ?>
	<div class="product">
		<div class="post_item post_layout_thumbs">
			<div class="post_featured hover_shop">
				<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
					<?php echo wp_kses_post( $product->get_image() ); ?>
				</a>
			</div><!-- /.post_featured -->
		</div>
		<div class="post_data">
			<div class="post_data_inner">
				<div class="post_header entry-header">
					<h2 class="woocommerce-loop-product__title">
						<a href="<?php echo esc_url( $product->get_permalink() ); ?>"><?php echo esc_html( $product->get_name() ); ?></a>
					</h2>
				</div><!-- /.post_header -->
				<div class="price_wrap">
					<span class="price">
						<?php echo wp_kses_post( $product->get_price_html() )?>
					</span>
				</div><!-- /.price_wrap -->
				<?php echo wp_kses_post( wc_get_rating_html( $product->get_average_rating() ) ); ?>
			</div><!-- /.post_data_inner -->
		</div><!-- /.post_data -->
	</div><!-- /.post_item -->
	
	<?php if ($args['slider'] || $args['columns'] > 1) {
		?></div><?php
	} ?>
<?php }