<?php
/**
 * JoomLine mp3 player - Joomla mp3 player
 *
 * @version 1.2.9
 * @package JoomLine mp3 player
 * @author Anton Voynov (anton@joomline.ru)
 * @copyright (C) 2010 by Anton Voynov(http://www.joomline.ru)
 * @license GNU/GPL: http://www.gnu.org/copyleft/gpl.html
 *
 * If you fork this to create your own project,
 * please make a reference to JoomLine someplace in your code
 * and provide a link to http://www.joomline.ru
 **/

defined('_JEXEC') or die('Restricted access');

function ascii2hex($ascii) {
	$hex = '';
	for ($i = 0; $i < strlen($ascii); $i++) {
		$byte = strtoupper(dechex(ord($ascii{$i})));
		$byte = str_repeat('0', 2 - strlen($byte)).$byte;
		$hex.=$byte." ";
	}
	return $hex;
}

function read_frame (&$f, &$tagdata, $frame) {
	$pos = strpos($tagdata,$frame);
	if ( $pos !== FALSE) {
		// frame found. read length of this frame
		fseek($f, 10+$pos+4);
		$frame2len = hexdec(ascii2hex(fread($f,4)));
		// read frame data
		fseek($f, 10+$pos+4+2+4+1);
		$data = fread($f,$frame2len-1);
		
		$hexfdata = ascii2hex($data);
		if ( substr($hexfdata,0,5) == 'FF FE' ) {
			$data = mb_convert_encoding($data,"cp1251",'UCS-2');
			$data = substr($data,1);
		}
		return $data;
	} else {
		return false;
	}
	
}

function readmp3tag($file) {
	$f = fopen($file, 'rb');
	// read tag length
	fseek($f, 8);
	$tmp = fread($f,2);
	$tmp = ascii2hex($tmp);
	$taglen= hexdec($tmp);
	//read tag data
	fseek($f, 10);
	$tagdata = fread($f,$taglen);
	
	// find song title frame
	$title = read_frame ($f, $tagdata, "TIT2");
	if (!$title) {
		$title = explode(DS,$file);
		$title = $title[count($title)-1];
		$title = explode('.',$title);
		$title=$title[0];
	}
	$artist = read_frame ($f, $tagdata, "TPE1");
	if (!$artist) $artist = "Unknown artist";
	
	if (preg_match('//u', $title)) { 
		$dd = 1;
	}
	$id3tag['NAME'] = iconv('cp1251','utf-8',$title);
	$id3tag['ARTIST'] = iconv('cp1251','utf-8',$artist);
	
	return $id3tag;
}

if (DS == "/") 
	$dir = str_replace("\\",DS,$music_dir);
else 
	$dir = str_replace("/",DS,$music_dir);
$dir = JPATH_ROOT.DS.$dir;


if (!is_dir($dir)) {
	echo "Wrong dir in settings";
} else {
	$files = glob($dir.DS."*.{mp3,MP3}",GLOB_BRACE);
	if (count($files) > 0) {
		sort($files);
		$host = $base_uri;
		foreach ($files as $file) {
			$tags = readmp3tag($file);
			$tagsarr[] = $tags;
			$file = explode (DS, $file);
			if ($server_utf8 == 1) {
				$fname = rawurlencode(iconv("cp1251","utf-8",$file[count($file)-1]));
			} else {
				$fname = rawurlencode($file[count($file)-1]);
			}
			
			$file = $host."/".$music_dir."/".$fname;
			$playlist[] = '{name:"'.$tags['ARTIST'].' - '.$tags['NAME'].'",mp3:"'.$file.'"}';
		}
	}
	
	?>
	<script type="text/javascript">
	var myPlayList = [
		<?php echo implode(",\n		",$playlist)."\n"; ?>
		];

	if(!window.jQuery) {
		document.write(unescape('<script type="text/javascript" src="<?=$base_uri?>/modules/mod_jlplayer/js/jq.js">%3C/script%3E'));
		document.write(unescape('<script type="text/javascript">jQuery.noConflict();%3C/script%3E'));
	}
	</script>	
	<link href="<?=$base_uri?>/modules/mod_jlplayer/skin/skin.css" rel="stylesheet" type="text/css" />
	<script type="text/javascript" src="<?=$base_uri?>/modules/mod_jlplayer/js/jquery.jplayer.min.js"></script>
	
	<script type="text/javascript" src="<?=$base_uri?>/modules/mod_jlplayer/js/jlplayer.js"></script>
	
	<div id="jquery_jplayer"></div>

	<div class="jp-playlist-player">
		<div class="jp-interface">
			<div class="jp-controls">
				<div style="width: 90%; margin-top: 10px;">
					<div style="float: left; width: 24%;"><div id="jplayer_previous" class="jlp-previous">&nbsp;</div></div>
					<div style="float: left; width: 24%;">
						<div id="jplayer_play" class="jlp-play">&nbsp;</div>
						<div id="jplayer_pause" class="jlp-pause">&nbsp;</div>
					</div>
					<div style="float: left; width: 24%;"><div id="jplayer_stop" class="jlp-stop">&nbsp;</div></div>
					<div style="float: left; width: 24%;"><div id="jplayer_next" class="jlp-next">&nbsp;</div></div>
				</div>
				<br /><br />
				<table width="100%">
					<tr>
						<td width="50"><div id="jplayer_play_time" class="jp-play-time">&nbsp;</div></td>
						<td>
							<div class="jp-progress">
								<div id="jplayer_load_bar" class="jp-load-bar">
									<div id="jplayer_play_bar" class="jp-play-bar"></div>
								</div>
							</div>
						</td>
						<td width="50"><div id="jplayer_total_time" class="jp-total-time">&nbsp;</div></td>
					</tr>
				</table>

				<table width="100%">
					<tr>
						<td width="28"><div id="jplayer_volume_min" class="jlp-volume-min">&nbsp;</div></td>
						<td>
							<div id="jplayer_volume_bar" class="jp-volume-bar">
								<div id="jplayer_volume_bar_value" class="jp-volume-bar-value"></div>
							</div>
						</td>
						<td width="28"><div id="jplayer_volume_max" class="jlp-volume-max">&nbsp;</div></td>
					</tr>
				</table>
			</div>


		</div>

		<div id="jplayer_playlist" class="jp-playlist">

		</div>
	</div>
	
	<?php
}
