/**
 * JoomLine mp3 player - Joomla mp3 player
 *
 * @version 1.2.9
 * @package JoomLine mp3 player
 * @author Anton Voynov (anton@joomline.ru)
 * @copyright (C) 2010 by Anton Voynov(http://www.joomline.ru)
 * @license GNU/GPL: http://www.gnu.org/copyleft/gpl.html
 *
 * If you fork this to create your own project,
 * please make a reference to JoomLine someplace in your code
 * and provide a link to http://www.joomline.ru
 **/
	var playItem = 0;
 
	// Local copy of jQuery selectors, for performance.

	
	jQuery(function(){
		var jpPlayTime = jQuery("#jplayer_play_time");
		var jpTotalTime = jQuery("#jplayer_total_time");
		
		jQuery("#jquery_jplayer").jPlayer({
			ready: function() {
				displayPlayList();
				playListInit(enable_autoplay); // Parameter is a boolean for autoplay.
			},
			errorAlerts:true,
			warningAlerts:true,
			swfPath: baseuri+'/modules/mod_jlplayer/js/'
		})
		.jPlayer("onProgressChange", function(loadPercent, playedPercentRelative, playedPercentAbsolute, playedTime, totalTime) {
			jpPlayTime.text(jQuery.jPlayer.convertTime(playedTime));
			jpTotalTime.text(jQuery.jPlayer.convertTime(totalTime));
		})
		.jPlayer("onSoundComplete", function() {
			playListNext();
		});
	 
		
		
		jQuery("#jplayer_previous").click( function() {
			playListPrev();
			return false;
		});
	 
		jQuery("#jplayer_next").click( function() {
			playListNext();
			return false;
		});
		
		
	});	
	
	
	function displayPlayList() {
		for (i=0; i < myPlayList.length; i++) {
			jQuery("#jplayer_playlist").append("<div id='jplayer_playlist_item_"+i+"'>"+ myPlayList[i].name +"</div>");
			jQuery("#jplayer_playlist_item_"+i).data( "index", i ).click( function() {
				var index = jQuery(this).data("index");
				if (playItem != index) {
					playListChange( index );
				} else {
					jQuery("#jquery_jplayer").jPlayer("play");
				}
			});
		}
	}
 
	function playListInit(autoplay) {
		if(autoplay) {
			playListChange( playItem );
		} else {
			playListConfig( playItem );
		}
	}
 
	function playListConfig( index ) {
		jQuery("#jplayer_playlist_item_"+playItem).removeClass("jplayer_playlist_current");
		jQuery("#jplayer_playlist_item_"+index).addClass("jplayer_playlist_current");
		playItem = index;
		jQuery("#jquery_jplayer").jPlayer("setFile", myPlayList[playItem].mp3);
	}
 
	function playListChange( index ) {
		playListConfig( index );
		jQuery("#jquery_jplayer").jPlayer("play");
	}
 
	function playListNext() {
		var index = (playItem+1 < myPlayList.length) ? playItem+1 : 0;
		playListChange( index );
	}
 
	function playListPrev() {
		var index = (playItem-1 >= 0) ? playItem-1 : myPlayList.length-1;
		playListChange( index );
	}